/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.util.NumberUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class ByteUtil {
    public static final ByteOrder DEFAULT_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final ByteOrder CPU_ENDIAN = "little".equals(System.getProperty("sun.cpu.endian")) ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;

    public static byte intToByte(int intValue) {
        return (byte)intValue;
    }

    public static int byteToUnsignedInt(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static short bytesToShort(byte[] bytes) {
        return ByteUtil.bytesToShort(bytes, DEFAULT_ORDER);
    }

    /*
     * WARNING - void declaration
     */
    public static short bytesToShort(byte[] bytes, ByteOrder byteOrder) {
        void var1_1;
        return ByteUtil.bytesToShort(bytes, 0, (ByteOrder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static short bytesToShort(byte[] bytes, int start, ByteOrder byteOrder) {
        void var1_1;
        byte[] byArray;
        void var2_2;
        if (ByteOrder.LITTLE_ENDIAN == var2_2) {
            return (short)(bytes[start] & 0xFF | (bytes[start + 1] & 0xFF) << 8);
        }
        return (short)(bytes[start + 1] & 0xFF | (byArray[var1_1] & 0xFF) << 8);
    }

    public static byte[] shortToBytes(short shortValue) {
        return ByteUtil.shortToBytes(shortValue, DEFAULT_ORDER);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] shortToBytes(short shortValue, ByteOrder byteOrder) {
        void var2_2;
        void var1_1;
        byte[] b = new byte[2];
        if (ByteOrder.LITTLE_ENDIAN == var1_1) {
            b[0] = (byte)shortValue;
            b[1] = (byte)(shortValue >> 8);
        } else {
            short s;
            b[1] = (byte)shortValue;
            b[0] = (byte)(s >> 8);
        }
        return var2_2;
    }

    public static int bytesToInt(byte[] bytes) {
        return ByteUtil.bytesToInt(bytes, DEFAULT_ORDER);
    }

    /*
     * WARNING - void declaration
     */
    public static int bytesToInt(byte[] bytes, ByteOrder byteOrder) {
        void var1_1;
        return ByteUtil.bytesToInt(bytes, 0, (ByteOrder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int bytesToInt(byte[] bytes, int start, ByteOrder byteOrder) {
        void var1_1;
        byte[] byArray;
        void var2_2;
        if (ByteOrder.LITTLE_ENDIAN == var2_2) {
            return bytes[start] & 0xFF | (bytes[start + 1] & 0xFF) << 8 | (bytes[start + 2] & 0xFF) << 16 | (bytes[start + 3] & 0xFF) << 24;
        }
        return bytes[start + 3] & 0xFF | (bytes[start + 2] & 0xFF) << 8 | (bytes[start + 1] & 0xFF) << 16 | (byArray[var1_1] & 0xFF) << 24;
    }

    public static byte[] intToBytes(int intValue) {
        return ByteUtil.intToBytes(intValue, DEFAULT_ORDER);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] intToBytes(int intValue, ByteOrder byteOrder) {
        int n;
        void var1_1;
        if (ByteOrder.LITTLE_ENDIAN == var1_1) {
            return new byte[]{(byte)intValue, (byte)(intValue >> 8), (byte)(intValue >> 16), (byte)(intValue >>> 24)};
        }
        return new byte[]{(byte)(intValue >>> 24), (byte)(intValue >> 16), (byte)(intValue >> 8), (byte)n};
    }

    public static byte[] longToBytes(long longValue) {
        return ByteUtil.longToBytes(longValue, DEFAULT_ORDER);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] longToBytes(long longValue, ByteOrder byteOrder) {
        void var3_4;
        byte[] result = new byte[8];
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)(longValue & 0xFFL);
                longValue >>= 8;
            }
        } else {
            int cfr_ignored_0 = result.length;
            for (int i = 7; i >= 0; --i) {
                result[i] = (byte)(longValue & 0xFFL);
                longValue >>= 8;
            }
        }
        return var3_4;
    }

    public static long bytesToLong(byte[] bytes) {
        return ByteUtil.bytesToLong(bytes, DEFAULT_ORDER);
    }

    /*
     * WARNING - void declaration
     */
    public static long bytesToLong(byte[] bytes, ByteOrder byteOrder) {
        void var1_1;
        return ByteUtil.bytesToLong(bytes, 0, (ByteOrder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long bytesToLong(byte[] bytes, int start, ByteOrder byteOrder) {
        void var3_5;
        long values = 0L;
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = 7; i >= 0; --i) {
                values <<= 8;
                values |= (long)(bytes[i + start] & 0xFF);
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                values <<= 8;
                values |= (long)(bytes[i + start] & 0xFF);
            }
        }
        return (long)var3_5;
    }

    public static byte[] floatToBytes(float floatValue) {
        return ByteUtil.floatToBytes(floatValue, DEFAULT_ORDER);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] floatToBytes(float floatValue, ByteOrder byteOrder) {
        void var1_1;
        return ByteUtil.intToBytes(Float.floatToIntBits(floatValue), (ByteOrder)var1_1);
    }

    public static float bytesToFloat(byte[] bytes) {
        return ByteUtil.bytesToFloat(bytes, DEFAULT_ORDER);
    }

    /*
     * WARNING - void declaration
     */
    public static float bytesToFloat(byte[] bytes, ByteOrder byteOrder) {
        void var1_1;
        return Float.intBitsToFloat(ByteUtil.bytesToInt(bytes, (ByteOrder)var1_1));
    }

    public static byte[] doubleToBytes(double doubleValue) {
        return ByteUtil.doubleToBytes(doubleValue, DEFAULT_ORDER);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] doubleToBytes(double doubleValue, ByteOrder byteOrder) {
        void var2_1;
        return ByteUtil.longToBytes(Double.doubleToLongBits(doubleValue), (ByteOrder)var2_1);
    }

    public static double bytesToDouble(byte[] bytes) {
        return ByteUtil.bytesToDouble(bytes, DEFAULT_ORDER);
    }

    /*
     * WARNING - void declaration
     */
    public static double bytesToDouble(byte[] bytes, ByteOrder byteOrder) {
        void var1_1;
        return Double.longBitsToDouble(ByteUtil.bytesToLong(bytes, (ByteOrder)var1_1));
    }

    public static byte[] numberToBytes(Number number) {
        return ByteUtil.numberToBytes(number, DEFAULT_ORDER);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] numberToBytes(Number number, ByteOrder byteOrder) {
        void var1_1;
        Number number2;
        if (number instanceof Byte) {
            return new byte[]{number.byteValue()};
        }
        if (number instanceof Double) {
            return ByteUtil.doubleToBytes((Double)number, byteOrder);
        }
        if (number instanceof Long) {
            return ByteUtil.longToBytes((Long)number, byteOrder);
        }
        if (number instanceof Integer) {
            return ByteUtil.intToBytes((Integer)number, byteOrder);
        }
        if (number instanceof Short) {
            return ByteUtil.shortToBytes((Short)number, byteOrder);
        }
        if (number instanceof Float) {
            return ByteUtil.floatToBytes(((Float)number).floatValue(), byteOrder);
        }
        return ByteUtil.doubleToBytes(number2.doubleValue(), (ByteOrder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Number> T bytesToNumber(byte[] bytes, Class<T> targetClass, ByteOrder byteOrder) throws IllegalArgumentException {
        Object object;
        void var1_1;
        LongAdder longValue;
        Object number;
        if (Byte.class == targetClass) {
            number = bytes[0];
        } else if (Short.class == targetClass) {
            number = ByteUtil.bytesToShort(number, byteOrder);
        } else if (Integer.class == targetClass) {
            number = ByteUtil.bytesToInt(number, byteOrder);
        } else if (AtomicInteger.class == targetClass) {
            number = new AtomicInteger(ByteUtil.bytesToInt(number, byteOrder));
        } else if (Long.class == targetClass) {
            number = ByteUtil.bytesToLong(number, byteOrder);
        } else if (AtomicLong.class == targetClass) {
            number = new AtomicLong(ByteUtil.bytesToLong(number, byteOrder));
        } else if (LongAdder.class == targetClass) {
            longValue = new LongAdder();
            longValue.add(ByteUtil.bytesToLong(number, byteOrder));
            number = longValue;
        } else if (Float.class == longValue) {
            number = Float.valueOf(ByteUtil.bytesToFloat(number, byteOrder));
        } else if (Double.class == longValue) {
            number = ByteUtil.bytesToDouble(number, byteOrder);
        } else if (DoubleAdder.class == longValue) {
            DoubleAdder doubleAdder = new DoubleAdder();
            doubleAdder.add(ByteUtil.bytesToDouble(number, byteOrder));
            number = var1_1;
        } else if (BigDecimal.class == var1_1) {
            number = NumberUtil.toBigDecimal(ByteUtil.bytesToDouble(number, byteOrder));
        } else if (BigInteger.class == var1_1) {
            number = BigInteger.valueOf(ByteUtil.bytesToLong(number, byteOrder));
        } else if (Number.class == var1_1) {
            void var2_2;
            number = ByteUtil.bytesToDouble(number, (ByteOrder)var2_2);
        } else {
            throw new IllegalArgumentException("Unsupported Number type: " + var1_1.getName());
        }
        return (T)object;
    }
}

