/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Set;

public class BooleanUtil {
    private static final Set<String> TRUE_SET = CollUtil.newHashSet("true", "yes", "y", "t", "ok", "1", "on", "\u662f", "\u5bf9", "\u771f", "\u5c0d", "\u221a");
    private static final Set<String> FALSE_SET = CollUtil.newHashSet("false", "no", "n", "f", "0", "off", "\u5426", "\u9519", "\u5047", "\u932f", "\u00d7");

    public static Boolean negate(Boolean bool) {
        Boolean bl;
        if (bool == null) {
            return null;
        }
        if (bl.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean isTrue(Boolean bool) {
        Boolean bl;
        return Boolean.TRUE.equals(bl);
    }

    public static boolean isFalse(Boolean bool) {
        Boolean bl;
        return Boolean.FALSE.equals(bl);
    }

    public static boolean negate(boolean bool) {
        return !bool;
    }

    public static boolean toBoolean(String valueStr) {
        if (StrUtil.isNotBlank(valueStr)) {
            String string;
            valueStr = valueStr.trim().toLowerCase();
            return TRUE_SET.contains(string);
        }
        return false;
    }

    public static Boolean toBooleanObject(String valueStr) {
        if (StrUtil.isNotBlank(valueStr)) {
            String string;
            if (TRUE_SET.contains(valueStr = valueStr.trim().toLowerCase())) {
                return Boolean.TRUE;
            }
            if (FALSE_SET.contains(string)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static int toInt(boolean value) {
        if (value) {
            return 1;
        }
        return 0;
    }

    public static Integer toInteger(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static char toChar(boolean value) {
        return (char)BooleanUtil.toInt(value);
    }

    public static Character toCharacter(boolean value) {
        return Character.valueOf(BooleanUtil.toChar(value));
    }

    public static byte toByte(boolean value) {
        return (byte)BooleanUtil.toInt(value);
    }

    public static Byte toByteObj(boolean value) {
        return BooleanUtil.toByte(value);
    }

    public static long toLong(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static Long toLongObj(boolean value) {
        return BooleanUtil.toLong(value);
    }

    public static short toShort(boolean value) {
        return (short)BooleanUtil.toInt(value);
    }

    public static Short toShortObj(boolean value) {
        return BooleanUtil.toShort(value);
    }

    public static float toFloat(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static Float toFloatObj(boolean value) {
        return Float.valueOf(BooleanUtil.toFloat(value));
    }

    public static double toDouble(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static Double toDoubleObj(boolean value) {
        return BooleanUtil.toDouble(value);
    }

    public static String toStringTrueFalse(boolean bool) {
        return BooleanUtil.toString(bool, "true", "false");
    }

    public static String toStringOnOff(boolean bool) {
        return BooleanUtil.toString(bool, "on", "off");
    }

    public static String toStringYesNo(boolean bool) {
        return BooleanUtil.toString(bool, "yes", "no");
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(boolean bool, String trueString, String falseString) {
        void var2_2;
        if (bool) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Boolean bool, String trueString, String falseString, String nullString) {
        void var2_2;
        Boolean bl;
        if (bool == null) {
            void var3_3;
            return var3_3;
        }
        if (bl.booleanValue()) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean and(boolean ... array) {
        boolean[] blArray;
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean element : blArray) {
            void var3_3;
            if (var3_3 != false) continue;
            return false;
        }
        return true;
    }

    public static Boolean andOfWrap(Boolean ... array) {
        Boolean[] booleanArray;
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (Boolean bl : booleanArray) {
            if (!BooleanUtil.isFalse(bl)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean or(boolean ... array) {
        boolean[] blArray;
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean bl : blArray) {
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static Boolean orOfWrap(Boolean ... array) {
        Boolean[] booleanArray;
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (Boolean bl : booleanArray) {
            if (!BooleanUtil.isTrue(bl)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean xor(boolean ... array) {
        void var1_1;
        boolean[] blArray;
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty");
        }
        boolean result = false;
        for (boolean element : blArray) {
            result ^= element;
        }
        return (boolean)var1_1;
    }

    public static Boolean xorOfWrap(Boolean ... array) {
        Object[] objectArray;
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] blArray = Convert.convert(boolean[].class, (Object)objectArray);
        objectArray = blArray;
        return BooleanUtil.xor(blArray);
    }

    public static boolean isBoolean(Class<?> clazz) {
        Class<?> clazz2;
        return clazz == Boolean.class || clazz2 == Boolean.TYPE;
    }
}

