/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.UniqueKeySet;
import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.text.StrJoiner;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PrimitiveArrayUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ArrayUtil
extends PrimitiveArrayUtil {
    public static <T> boolean isEmpty(T[] array) {
        T[] TArray;
        return array == null || TArray.length == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] defaultIfEmpty(T[] array, T[] defaultArray) {
        T[] TArray;
        if (ArrayUtil.isEmpty(array)) {
            void var1_1;
            return var1_1;
        }
        return TArray;
    }

    public static boolean isEmpty(Object array) {
        if (array != null) {
            if (ArrayUtil.isArray(array)) {
                Object object;
                return 0 == Array.getLength(object);
            }
            return false;
        }
        return true;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        T[] TArray;
        return array != null && TArray.length != 0;
    }

    public static boolean isNotEmpty(Object array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static <T> boolean hasNull(T ... array) {
        T[] TArray;
        if (ArrayUtil.isNotEmpty(array)) {
            T[] TArray2 = array;
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                T t = TArray2[i];
                if (!ObjectUtil.isNull(t)) continue;
                return true;
            }
        }
        return TArray == null;
    }

    public static <T> boolean isAllNull(T ... array) {
        T[] TArray;
        return null == ArrayUtil.firstNonNull(TArray);
    }

    public static <T> T firstNonNull(T ... array) {
        T[] TArray;
        return (T)ArrayUtil.firstMatch(ObjectUtil::isNotNull, TArray);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T firstMatch(Matcher<T> matcher, T ... array) {
        void var0_1;
        void var1_2;
        int index = ArrayUtil.matchIndex(matcher, array);
        if (index < 0) {
            return null;
        }
        return var1_2[var0_1];
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int matchIndex(Matcher<T> matcher, T ... array) {
        void var1_1;
        return ArrayUtil.matchIndex(matcher, 0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int matchIndex(Matcher<T> matcher, int beginIndexInclude, T ... array) {
        Assert.notNull(matcher, "Matcher must be not null !", new Object[0]);
        if (ArrayUtil.isNotEmpty(array)) {
            void i;
            while (i < array.length) {
                if (matcher.match(array[i])) {
                    return (int)i;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        void var1_1;
        return (Object[])Array.newInstance(componentType, (int)var1_1);
    }

    public static Object[] newArray(int newSize) {
        return new Object[newSize];
    }

    public static Class<?> getComponentType(Object array) {
        Object object;
        if (array == null) {
            return null;
        }
        return object.getClass().getComponentType();
    }

    public static Class<?> getComponentType(Class<?> arrayClass) {
        Class<?> clazz;
        if (arrayClass == null) {
            return null;
        }
        return clazz.getComponentType();
    }

    public static Class<?> getArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] cast(Class<?> type, Object arrayObj) throws NullPointerException, IllegalArgumentException {
        Object[] objectArray;
        void var1_1;
        Object[] componentType;
        if (arrayObj == null) {
            throw new NullPointerException("Argument [arrayObj] is null !");
        }
        if (!arrayObj.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array !");
        }
        if (type == null) {
            return (Object[])arrayObj;
        }
        componentType = type.isArray() ? type.getComponentType() : componentType;
        Object[] array = (Object[])arrayObj;
        Object[] result = ArrayUtil.newArray(componentType, array.length);
        System.arraycopy(array, 0, result, 0, ((void)var1_1).length);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        void var1_1;
        T[] TArray;
        if (ArrayUtil.isEmpty(buffer)) {
            return newElements;
        }
        return ArrayUtil.insert(TArray, TArray.length, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> Object append(Object array, T ... newElements) {
        void var1_1;
        Object object;
        if (ArrayUtil.isEmpty(array)) {
            return newElements;
        }
        Object object2 = object;
        return ArrayUtil.insert(object2, ArrayUtil.length(object2), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] setOrAppend(T[] buffer, int index, T value) {
        void var2_3;
        T[] TArray;
        if (index < buffer.length) {
            Array.set(buffer, index, value);
            return buffer;
        }
        if (ArrayUtil.isEmpty(buffer)) {
            void var1_2;
            T[] TArray2 = ArrayUtil.newArray(value.getClass(), 1);
            T[] values = TArray2;
            TArray2[0] = value;
            return ArrayUtil.append(buffer, var1_2);
        }
        return ArrayUtil.append(TArray, new Object[]{var2_3});
    }

    /*
     * WARNING - void declaration
     */
    public static Object setOrAppend(Object array, int index, Object value) {
        void var2_2;
        Object object;
        if (index < ArrayUtil.length(array)) {
            void var1_1;
            Array.set(array, (int)var1_1, value);
            return array;
        }
        return ArrayUtil.append(object, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] replace(T[] buffer, int index, T ... values) {
        void var3_4;
        void var2_2;
        void var1_1;
        T[] TArray;
        if (ArrayUtil.isEmpty(values)) {
            return buffer;
        }
        if (ArrayUtil.isEmpty(buffer)) {
            return values;
        }
        if (index < 0) {
            return ArrayUtil.insert(buffer, 0, values);
        }
        if (index >= buffer.length) {
            return ArrayUtil.append(buffer, values);
        }
        if (buffer.length >= values.length + index) {
            System.arraycopy(values, 0, buffer, index, values.length);
            return buffer;
        }
        int newArrayLength = index + values.length;
        T[] result = ArrayUtil.newArray(buffer.getClass().getComponentType(), newArrayLength);
        System.arraycopy(TArray, 0, result, 0, index);
        System.arraycopy(values, 0, result, (int)var1_1, ((void)var2_2).length);
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] insert(T[] buffer, int index, T ... newElements) {
        void var2_2;
        void var1_1;
        return (Object[])ArrayUtil.insert(buffer, (int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Object insert(Object array, int index, T ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return array;
        }
        if (ArrayUtil.isEmpty(array)) {
            return newElements;
        }
        int len = ArrayUtil.length(array);
        if (index < 0) {
            index = index % len + len;
        }
        Class<?> originComponentType = array.getClass().getComponentType();
        Object newEleArr = newElements;
        if (originComponentType.isPrimitive()) {
            newEleArr = Convert.convert(array.getClass(), newElements);
        }
        Object result = Array.newInstance(originComponentType, Math.max(len, index) + newElements.length);
        System.arraycopy(array, 0, result, 0, Math.min(len, index));
        System.arraycopy(newEleArr, 0, result, index, newElements.length);
        if (index < len) {
            void var1_1;
            void var3_3;
            void var2_2;
            Object object;
            System.arraycopy(object, index, result, index + ((void)var2_2).length, (int)(var3_3 - var1_1));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] resize(T[] data, int newSize, Class<?> componentType) {
        void var2_2;
        if (newSize < 0) {
            return data;
        }
        T[] newArray = ArrayUtil.newArray(componentType, newSize);
        if (newSize > 0 && ArrayUtil.isNotEmpty(data)) {
            void var1_1;
            T[] TArray;
            System.arraycopy(data, 0, newArray, 0, Math.min(TArray.length, (int)var1_1));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Object resize(Object array, int newSize) {
        void var3_3;
        if (newSize < 0) {
            return array;
        }
        if (array == null) {
            return null;
        }
        int length = ArrayUtil.length(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newSize);
        if (newSize > 0 && ArrayUtil.isNotEmpty(array)) {
            void var1_1;
            void var2_2;
            Object object;
            System.arraycopy(object, 0, newArray, 0, Math.min((int)var2_2, (int)var1_1));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] resize(T[] buffer, int newSize) {
        T[] TArray;
        void var1_1;
        return ArrayUtil.resize(buffer, (int)var1_1, TArray.getClass().getComponentType());
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] ... arrays) {
        int n;
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        T[][] TArray = arrays;
        int n2 = arrays.length;
        for (n = 0; n < n2; ++n) {
            T[] array = TArray[n];
            if (!ArrayUtil.isNotEmpty(array)) continue;
            length += array.length;
        }
        T[] result = ArrayUtil.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        T[][] TArray2 = arrays;
        n = arrays.length;
        for (int i = 0; i < n; ++i) {
            T[][] TArray3;
            T[][] array = TArray2[i];
            if (!ArrayUtil.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += TArray3.length;
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    public static Object copy(Object src, int srcPos, Object dest, int destPos, int length) {
        void var2_2;
        void var3_3;
        void var1_1;
        System.arraycopy(src, (int)var1_1, dest, (int)var3_3, length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Object copy(Object src, Object dest, int length) {
        void var1_1;
        void var2_2;
        System.arraycopy(src, 0, dest, 0, (int)var2_2);
        return var1_1;
    }

    public static <T> T[] clone(T[] array) {
        T[] TArray;
        if (array == null) {
            return null;
        }
        return (Object[])TArray.clone();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T clone(T obj) {
        if (obj == null) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            void var1_1;
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(obj, length));
                }
            } else {
                T t;
                result = ((Object[])t).clone();
            }
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] edit(T[] array, Editor<T> editor) {
        void var2_2;
        T[] TArray;
        if (editor == null) {
            return array;
        }
        ArrayList<void> list = new ArrayList<void>(array.length);
        T[] TArray2 = array;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            void var3_6;
            T t = TArray2[i];
            T modified = editor.edit(t);
            if (modified == null) continue;
            list.add(var3_6);
        }
        T[] result = ArrayUtil.newArray(TArray.getClass().getComponentType(), list.size());
        return var2_2.toArray(result);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] filter(T[] array, Filter<T> filter) {
        void var1_1;
        T[] TArray;
        if (array == null || filter == null) {
            return array;
        }
        return ArrayUtil.edit(TArray, arg_0 -> ArrayUtil.lambda$filter$0((Filter)var1_1, arg_0));
    }

    public static <T> T[] removeNull(T[] array) {
        return ArrayUtil.edit(array, t -> t);
    }

    public static <T extends CharSequence> T[] removeEmpty(T[] array) {
        return ArrayUtil.filter(array, CharSequenceUtil::isNotEmpty);
    }

    public static <T extends CharSequence> T[] removeBlank(T[] array) {
        return ArrayUtil.filter(array, CharSequenceUtil::isNotBlank);
    }

    public static String[] nullToEmpty(String[] array) {
        return ArrayUtil.edit(array, t -> {
            String string;
            if (t == null) {
                return "";
            }
            return string;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> zip(K[] keys, V[] values, boolean isOrder) {
        void var2_3;
        if (ArrayUtil.isEmpty(keys) || ArrayUtil.isEmpty(values)) {
            return null;
        }
        int size = Math.min(keys.length, values.length);
        HashMap<K, V> map = MapUtil.newHashMap(size, isOrder);
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> zip(K[] keys, V[] values) {
        void var1_1;
        return ArrayUtil.zip(keys, var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int indexOf(T[] array, Object value, int beginIndexInclude) {
        T[] TArray;
        void var2_2;
        return ArrayUtil.matchIndex((T obj) -> {
            void var1_1;
            return ObjectUtil.equal(value, var1_1);
        }, (int)var2_2, TArray);
    }

    public static <T> int indexOf(T[] array, Object value) {
        T[] TArray;
        return ArrayUtil.matchIndex((T obj) -> {
            void var1_1;
            return ObjectUtil.equal(value, var1_1);
        }, TArray);
    }

    public static int indexOfIgnoreCase(CharSequence[] array, CharSequence value) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!StrUtil.equalsIgnoreCase(array[i], value)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int lastIndexOf(T[] array, Object value) {
        T[] TArray;
        void var1_1;
        if (ArrayUtil.isEmpty(array)) {
            return -1;
        }
        return ArrayUtil.lastIndexOf(array, var1_1, TArray.length - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int lastIndexOf(T[] array, Object value, int endInclude) {
        if (ArrayUtil.isNotEmpty(array)) {
            void i;
            while (i >= 0) {
                if (ObjectUtil.equal(value, array[i])) {
                    return (int)i;
                }
                --i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean contains(T[] array, T value) {
        void var1_1;
        return ArrayUtil.indexOf(array, var1_1) >= 0;
    }

    public static <T> boolean containsAny(T[] array, T ... values) {
        T[] TArray = values;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            T value = TArray[i];
            if (!ArrayUtil.contains(array, value)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(T[] array, T ... values) {
        T[] TArray = values;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            T value = TArray[i];
            if (ArrayUtil.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsIgnoreCase(CharSequence[] array, CharSequence value) {
        void var1_1;
        return ArrayUtil.indexOfIgnoreCase(array, (CharSequence)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] wrap(Object obj) {
        Object object;
        if (obj == null) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return (Object[])obj;
            }
            catch (Exception e) {
                void var1_1;
                switch (obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return ArrayUtil.wrap((long[])obj);
                    }
                    case "int": {
                        return ArrayUtil.wrap((int[])obj);
                    }
                    case "short": {
                        return ArrayUtil.wrap((short[])obj);
                    }
                    case "char": {
                        return ArrayUtil.wrap((char[])obj);
                    }
                    case "byte": {
                        return ArrayUtil.wrap((byte[])obj);
                    }
                    case "boolean": {
                        return ArrayUtil.wrap((boolean[])obj);
                    }
                    case "float": {
                        return ArrayUtil.wrap((float[])obj);
                    }
                    case "double": {
                        return ArrayUtil.wrap((double[])obj);
                    }
                }
                throw new UtilException((Throwable)var1_1);
            }
        }
        throw new UtilException(StrUtil.format("[{}] is not Array!", object.getClass()));
    }

    public static boolean isArray(Object obj) {
        Object object;
        return obj != null && object.getClass().isArray();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(Object array, int index) {
        if (array == null) {
            return null;
        }
        if (index < 0) {
            index += Array.getLength(array);
        }
        try {
            void var1_1;
            Object object;
            return (T)Array.get(object, (int)var1_1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] getAny(Object array, int ... indexes) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (indexes == null) {
            return ArrayUtil.newArray(array.getClass().getComponentType(), 0);
        }
        T[] result = ArrayUtil.newArray(array.getClass().getComponentType(), indexes.length);
        for (int i = 0; i < indexes.length; ++i) {
            result[i] = ArrayUtil.get(array, indexes[i]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] sub(T[] array, int start, int end) {
        void var2_2;
        void var1_1;
        T[] TArray;
        int length = ArrayUtil.length(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return ArrayUtil.newArray(array.getClass().getComponentType(), 0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            void var3_3;
            if (start >= length) {
                return ArrayUtil.newArray(array.getClass().getComponentType(), 0);
            }
            end = var3_3;
        }
        return Arrays.copyOfRange(TArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] sub(Object array, int start, int end) {
        void var2_2;
        void var1_1;
        return ArrayUtil.sub(array, (int)var1_1, (int)var2_2, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] sub(Object array, int start, int end, int step) {
        void i;
        int length = ArrayUtil.length(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new Object[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new Object[0];
            }
            end = length;
        }
        if (step <= 1) {
            step = 1;
        }
        ArrayList list = new ArrayList();
        while (i < end) {
            list.add(ArrayUtil.get(array, (int)i));
            i += step;
        }
        return list.toArray();
    }

    public static String toString(Object obj) {
        Object object;
        if (obj == null) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {}
        }
        return object.toString();
    }

    public static int length(Object array) throws IllegalArgumentException {
        Object object;
        if (array == null) {
            return 0;
        }
        return Array.getLength(object);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String join(T[] array, CharSequence conjunction) {
        void var1_1;
        return ArrayUtil.join(array, (CharSequence)var1_1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String join(T[] array, CharSequence delimiter, String prefix, String suffix) {
        T[] TArray;
        void var3_3;
        void var2_2;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StrJoiner.of((CharSequence)var1_1, (CharSequence)var2_2, (CharSequence)var3_3).setWrapElement(true).append(TArray).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String join(T[] array, CharSequence conjunction, Editor<T> editor) {
        void var2_2;
        T[] TArray;
        return StrJoiner.of(conjunction).append(TArray, arg_0 -> ArrayUtil.lambda$join$5((Editor)var2_2, arg_0)).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Object array, CharSequence conjunction) {
        Object object;
        void var1_1;
        if (array == null) {
            return null;
        }
        if (!ArrayUtil.isArray(array)) {
            throw new IllegalArgumentException(StrUtil.format("[{}] is not a Array!", array.getClass()));
        }
        return StrJoiner.of((CharSequence)var1_1).append(object).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toArray(ByteBuffer bytebuffer) {
        void var2_3;
        void var1_1;
        ByteBuffer byteBuffer;
        if (bytebuffer.hasArray()) {
            return Arrays.copyOfRange(bytebuffer.array(), bytebuffer.position(), bytebuffer.limit());
        }
        int oldPosition = bytebuffer.position();
        bytebuffer.position(0);
        int n = bytebuffer.limit();
        byte[] buffers = new byte[n];
        bytebuffer.get(buffers);
        byteBuffer.position((int)var1_1);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] toArray(Iterator<T> iterator, Class<T> componentType) {
        void var1_1;
        return ArrayUtil.toArray(CollUtil.newArrayList(iterator), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] toArray(Iterable<T> iterable, Class<T> componentType) {
        void var1_1;
        return ArrayUtil.toArray(CollectionUtil.toCollection(iterable), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        void var1_1;
        return collection.toArray(ArrayUtil.newArray(var1_1, 0));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] remove(T[] array, int index) throws IllegalArgumentException {
        void var1_1;
        return (Object[])ArrayUtil.remove(array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] removeEle(T[] array, T element) throws IllegalArgumentException {
        void var1_1;
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] reverse(T[] array, int startIndexInclusive, int endIndexExclusive) {
        T[] TArray;
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            void var3_3;
            T tmp = array[j];
            array[j] = array[i];
            array[i] = var3_3;
        }
        return TArray;
    }

    public static <T> T[] reverse(T[] array) {
        T[] TArray;
        return ArrayUtil.reverse(array, 0, TArray.length);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)ArrayUtil.min(numberArray, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Comparable<? super T>> T min(T[] numberArray, Comparator<T> comparator) {
        void var2_2;
        T[] TArray;
        if (ArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T min = numberArray[0];
        for (T t : TArray) {
            if (CompareUtil.compare(min, t, comparator) <= 0) continue;
            min = t;
        }
        return var2_2;
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        return (T)ArrayUtil.max(numberArray, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Comparable<? super T>> T max(T[] numberArray, Comparator<T> comparator) {
        void var2_2;
        if (ArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (CompareUtil.compare(max, numberArray[i], comparator) >= 0) continue;
            max = numberArray[i];
        }
        return var2_2;
    }

    public static <T> T[] shuffle(T[] array) {
        return ArrayUtil.shuffle(array, (Random)RandomUtil.getRandom());
    }

    public static <T> T[] shuffle(T[] array, Random random) {
        T[] TArray;
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            ArrayUtil.swap(array, i - 1, random.nextInt(i));
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] swap(T[] array, int index1, int index2) {
        T[] TArray;
        void var3_3;
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        T tmp = array[index1];
        array[var1_1] = array[index2];
        array[var2_2] = var3_3;
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    public static Object swap(Object array, int index1, int index2) {
        Object object;
        void var3_3;
        void var2_2;
        void var1_1;
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        Object tmp = ArrayUtil.get(array, index1);
        Array.set(array, (int)var1_1, Array.get(array, index2));
        Array.set(array, (int)var2_2, var3_3);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static int emptyCount(Object ... args) {
        void var1_1;
        int count = 0;
        if (ArrayUtil.isNotEmpty(args)) {
            Object[] objectArray;
            for (Object object : objectArray) {
                if (!ObjectUtil.isEmpty(object)) continue;
                ++count;
            }
        }
        return (int)var1_1;
    }

    public static boolean hasEmpty(Object ... args) {
        if (ArrayUtil.isNotEmpty(args)) {
            Object[] objectArray;
            for (Object object : objectArray) {
                if (!ObjectUtil.isEmpty(object)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAllEmpty(Object ... args) {
        Object[] objectArray = args;
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            void var3_3;
            Object obj = objectArray[i];
            if (ObjectUtil.isEmpty(var3_3)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(Object ... args) {
        Object[] objectArray;
        return false == ArrayUtil.hasEmpty(objectArray);
    }

    public static <T> boolean isAllNotNull(T ... array) {
        T[] TArray;
        return false == ArrayUtil.hasNull(TArray);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] distinct(T[] array) {
        T[] TArray;
        void var1_1;
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        LinkedHashSet set = new LinkedHashSet(array.length, 1.0f);
        Collections.addAll(set, array);
        return ArrayUtil.toArray(var1_1, ArrayUtil.getComponentType(TArray));
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K> T[] distinct(T[] array, Function<T, K> uniqueGenerator, boolean override) {
        T[] TArray;
        void var1_1;
        void var2_2;
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        UniqueKeySet<K, T> set = new UniqueKeySet<K, T>(true, uniqueGenerator);
        if (var2_2 != false) {
            Collections.addAll(set, array);
        } else {
            T[] TArray2 = array;
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                T t = TArray2[i];
                set.addIfAbsent(t);
            }
        }
        return ArrayUtil.toArray(var1_1, ArrayUtil.getComponentType(TArray));
    }

    /*
     * WARNING - void declaration
     */
    public static <T, R> R[] map(T[] array, Class<R> targetComponentType, Function<? super T, ? extends R> func) {
        void var1_1;
        T[] result = ArrayUtil.newArray(targetComponentType, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = func.apply(array[i]);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T, R> R[] map(Object array, Class<R> targetComponentType, Function<? super T, ? extends R> func) {
        void var1_1;
        int length = ArrayUtil.length(array);
        T[] result = ArrayUtil.newArray(targetComponentType, length);
        for (int i = 0; i < length; ++i) {
            result[i] = func.apply(ArrayUtil.get(array, i));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T, R> List<R> map(T[] array, Function<? super T, ? extends R> func) {
        void var1_1;
        return Arrays.stream(array).map(var1_1).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    public static <T, R> Set<R> mapToSet(T[] array, Function<? super T, ? extends R> func) {
        void var1_1;
        return Arrays.stream(array).map(var1_1).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(Object array1, Object array2) {
        void var1_1;
        Object object;
        if (array1 == array2) {
            return true;
        }
        if (ArrayUtil.hasNull(array1, array2)) {
            return false;
        }
        Assert.isTrue(ArrayUtil.isArray(array1), "First is not a Array !", new Object[0]);
        Assert.isTrue(ArrayUtil.isArray(array2), "Second is not a Array !", new Object[0]);
        if (array1 instanceof long[]) {
            return Arrays.equals((long[])array1, (long[])array2);
        }
        if (array1 instanceof int[]) {
            return Arrays.equals((int[])array1, (int[])array2);
        }
        if (array1 instanceof short[]) {
            return Arrays.equals((short[])array1, (short[])array2);
        }
        if (array1 instanceof char[]) {
            return Arrays.equals((char[])array1, (char[])array2);
        }
        if (array1 instanceof byte[]) {
            return Arrays.equals((byte[])array1, (byte[])array2);
        }
        if (array1 instanceof double[]) {
            return Arrays.equals((double[])array1, (double[])array2);
        }
        if (array1 instanceof float[]) {
            return Arrays.equals((float[])array1, (float[])array2);
        }
        if (array1 instanceof boolean[]) {
            return Arrays.equals((boolean[])array1, (boolean[])array2);
        }
        return Arrays.deepEquals((Object[])object, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean isSub(T[] array, T[] subArray) {
        void var1_1;
        return ArrayUtil.indexOfSub(array, var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int indexOfSub(T[] array, T[] subArray) {
        void var1_1;
        return ArrayUtil.indexOfSub(array, 0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int indexOfSub(T[] array, int beginInclude, T[] subArray) {
        void var1_1;
        block0: while (true) {
            if (ArrayUtil.isEmpty(array) || ArrayUtil.isEmpty(subArray) || subArray.length > array.length) {
                return -1;
            }
            int firstIndex = ArrayUtil.indexOf(array, subArray[0], beginInclude);
            if (firstIndex < 0 || firstIndex + subArray.length > array.length) {
                return -1;
            }
            for (int i = 0; i < subArray.length; ++i) {
                if (ObjectUtil.equal(array[i + firstIndex], subArray[i])) continue;
                ++firstIndex;
                continue block0;
            }
            break;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int lastIndexOfSub(T[] array, T[] subArray) {
        void var1_1;
        T[] TArray;
        if (ArrayUtil.isEmpty(array) || ArrayUtil.isEmpty(subArray)) {
            return -1;
        }
        return ArrayUtil.lastIndexOfSub(TArray, TArray.length - 1, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int lastIndexOfSub(T[] array, int endInclude, T[] subArray) {
        void var1_1;
        block0: while (true) {
            if (ArrayUtil.isEmpty(array) || ArrayUtil.isEmpty(subArray) || subArray.length > array.length || endInclude < 0) {
                return -1;
            }
            int firstIndex = ArrayUtil.lastIndexOf(array, subArray[0]);
            if (firstIndex < 0 || firstIndex + subArray.length > array.length) {
                return -1;
            }
            for (int i = 0; i < subArray.length; ++i) {
                if (ObjectUtil.equal(array[i + firstIndex], subArray[i])) continue;
                --firstIndex;
                continue block0;
            }
            break;
        }
        return (int)var1_1;
    }

    public static <T> boolean isSorted(T[] array, Comparator<? super T> comparator) {
        if (array == null || comparator == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (comparator.compare(array[i], array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array) {
        return ArrayUtil.isSortedASC(array);
    }

    public static <T extends Comparable<? super T>> boolean isSortedASC(T[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i].compareTo(array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSortedDESC(T[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i].compareTo(array[i + 1]) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ CharSequence lambda$join$5(Editor editor, Object t) {
        void var1_1;
        return String.valueOf(editor.edit(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$filter$0(Filter filter, Object t) {
        if (filter.accept(t)) {
            void var1_1;
            return var1_1;
        }
        return null;
    }
}

