/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.thread;

import cn.hutool.core.thread.ConcurrencyTester;
import cn.hutool.core.thread.ExecutorBuilder;
import cn.hutool.core.thread.GlobalThreadPool;
import cn.hutool.core.thread.NamedThreadFactory;
import cn.hutool.core.thread.RejectPolicy;
import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.hutool.core.util.RuntimeUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ThreadUtil {
    /*
     * WARNING - void declaration
     */
    public static ExecutorService newExecutor(int corePoolSize) {
        void var1_1;
        ExecutorBuilder builder = ExecutorBuilder.create();
        if (corePoolSize > 0) {
            int n;
            builder.setCorePoolSize(n);
        }
        return var1_1.build();
    }

    public static ExecutorService newExecutor() {
        return ExecutorBuilder.create().useSynchronousQueue().build();
    }

    public static ExecutorService newSingleExecutor() {
        return ExecutorBuilder.create().setCorePoolSize(1).setMaxPoolSize(1).setKeepAliveTime(0L).buildFinalizable();
    }

    /*
     * WARNING - void declaration
     */
    public static ThreadPoolExecutor newExecutor(int corePoolSize, int maximumPoolSize) {
        void var1_1;
        int n;
        return ExecutorBuilder.create().setCorePoolSize(n).setMaxPoolSize((int)var1_1).build();
    }

    /*
     * WARNING - void declaration
     */
    public static ExecutorService newExecutor(int corePoolSize, int maximumPoolSize, int maximumQueueSize) {
        void var2_2;
        void var1_1;
        int n;
        return ExecutorBuilder.create().setCorePoolSize(n).setMaxPoolSize((int)var1_1).setWorkQueue(new LinkedBlockingQueue<Runnable>((int)var2_2)).build();
    }

    /*
     * WARNING - void declaration
     */
    public static ThreadPoolExecutor newExecutorByBlockingCoefficient(float blockingCoefficient) {
        void var0_1;
        if (blockingCoefficient >= 1.0f || blockingCoefficient < 0.0f) {
            throw new IllegalArgumentException("[blockingCoefficient] must between 0 and 1, or equals 0.");
        }
        int poolSize = (int)((float)RuntimeUtil.getProcessorCount() / (1.0f - blockingCoefficient));
        return ExecutorBuilder.create().setCorePoolSize(poolSize).setMaxPoolSize((int)var0_1).setKeepAliveTime(0L).build();
    }

    /*
     * WARNING - void declaration
     */
    public static ExecutorService newFixedExecutor(int nThreads, String threadNamePrefix, boolean isBlocked) {
        void var2_2;
        void var1_1;
        return ThreadUtil.newFixedExecutor(nThreads, 1024, (String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ExecutorService newFixedExecutor(int nThreads, int maximumQueueSize, String threadNamePrefix, boolean isBlocked) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ThreadUtil.newFixedExecutor(nThreads, (int)var1_1, (String)var2_2, (var3_3 != false ? RejectPolicy.BLOCK : RejectPolicy.ABORT).getValue());
    }

    /*
     * WARNING - void declaration
     */
    public static ExecutorService newFixedExecutor(int nThreads, int maximumQueueSize, String threadNamePrefix, RejectedExecutionHandler handler) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        return ExecutorBuilder.create().setCorePoolSize(nThreads).setMaxPoolSize(n).setWorkQueue(new LinkedBlockingQueue<Runnable>((int)var1_1)).setThreadFactory(ThreadUtil.createThreadFactory((String)var2_2)).setHandler((RejectedExecutionHandler)var3_3).build();
    }

    public static void execute(Runnable runnable) {
        GlobalThreadPool.execute(runnable);
    }

    /*
     * WARNING - void declaration
     */
    public static Runnable execAsync(Runnable runnable, boolean isDaemon) {
        Runnable runnable2;
        void var2_2;
        void var1_1;
        Thread thread = new Thread(runnable);
        thread.setDaemon((boolean)var1_1);
        var2_2.start();
        return runnable2;
    }

    public static <T> Future<T> execAsync(Callable<T> task) {
        return GlobalThreadPool.submit(task);
    }

    public static Future<?> execAsync(Runnable runnable) {
        return GlobalThreadPool.submit(runnable);
    }

    public static <T> CompletionService<T> newCompletionService() {
        return new ExecutorCompletionService(GlobalThreadPool.getExecutor());
    }

    public static <T> CompletionService<T> newCompletionService(ExecutorService executor) {
        ExecutorService executorService;
        return new ExecutorCompletionService(executorService);
    }

    public static CountDownLatch newCountDownLatch(int threadCount) {
        int n;
        return new CountDownLatch(n);
    }

    /*
     * WARNING - void declaration
     */
    public static Thread newThread(Runnable runnable, String name) {
        Runnable runnable2;
        void var1_1;
        Runnable t = ThreadUtil.newThread(runnable, (String)var1_1, false);
        if (((Thread)t).getPriority() != 5) {
            ((Thread)t).setPriority(5);
        }
        return runnable2;
    }

    /*
     * WARNING - void declaration
     */
    public static Thread newThread(Runnable runnable, String name, boolean isDaemon) {
        Runnable runnable2;
        void var2_2;
        void var1_1;
        Runnable t = new Thread(null, runnable, (String)var1_1);
        ((Thread)t).setDaemon((boolean)var2_2);
        return runnable2;
    }

    public static boolean sleep(Number timeout, TimeUnit timeUnit) {
        try {
            Number number;
            timeUnit.sleep(number.longValue());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public static boolean sleep(Number millis) {
        Number number;
        if (millis == null) {
            return true;
        }
        return ThreadUtil.sleep(number.longValue());
    }

    public static boolean sleep(long millis) {
        if (millis > 0L) {
            try {
                long l;
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public static boolean safeSleep(Number millis) {
        Number number;
        if (millis == null) {
            return true;
        }
        return ThreadUtil.safeSleep(number.longValue());
    }

    public static boolean safeSleep(long millis) {
        long before;
        for (long done = 0L; done < millis; done += (System.nanoTime() - before) / 1000000L) {
            before = System.nanoTime();
            if (ThreadUtil.sleep(millis - done)) continue;
            return false;
        }
        return true;
    }

    public static StackTraceElement[] getStackTrace() {
        return Thread.currentThread().getStackTrace();
    }

    /*
     * WARNING - void declaration
     */
    public static StackTraceElement getStackTraceElement(int i) {
        int n;
        void var1_1;
        StackTraceElement[] stackTrace = ThreadUtil.getStackTrace();
        if (i < 0) {
            i += stackTrace.length;
        }
        return var1_1[n];
    }

    public static <T> ThreadLocal<T> createThreadLocal(boolean isInheritable) {
        if (isInheritable) {
            return new InheritableThreadLocal();
        }
        return new ThreadLocal();
    }

    public static <T> ThreadLocal<T> createThreadLocal(Supplier<? extends T> supplier) {
        return ThreadLocal.withInitial(supplier);
    }

    public static ThreadFactoryBuilder createThreadFactoryBuilder() {
        return ThreadFactoryBuilder.create();
    }

    public static ThreadFactory createThreadFactory(String threadNamePrefix) {
        String string;
        return ThreadFactoryBuilder.create().setNamePrefix(string).build();
    }

    /*
     * WARNING - void declaration
     */
    public static void interrupt(Thread thread, boolean isJoin) {
        if (thread != null && !thread.isInterrupted()) {
            void var1_1;
            thread.interrupt();
            if (var1_1 != false) {
                Thread thread2;
                ThreadUtil.waitForDie(thread2);
            }
        }
    }

    public static void waitForDie() {
        ThreadUtil.waitForDie(Thread.currentThread());
    }

    public static void waitForDie(Thread thread) {
        if (thread == null) {
            return;
        }
        boolean dead = false;
        do {
            try {
                thread.join();
                dead = true;
            }
            catch (InterruptedException interruptedException) {}
        } while (!dead);
    }

    public static Thread[] getThreads() {
        return ThreadUtil.getThreads(Thread.currentThread().getThreadGroup().getParent());
    }

    /*
     * WARNING - void declaration
     */
    public static Thread[] getThreads(ThreadGroup group) {
        void var2_3;
        void var0_1;
        void var1_2;
        Thread[] slackList = new Thread[group.activeCount() << 1];
        int actualSize = group.enumerate(slackList);
        Thread[] result = new Thread[actualSize];
        System.arraycopy(var1_2, 0, result, 0, (int)var0_1);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static Thread getMainThread() {
        for (Thread thread : ThreadUtil.getThreads()) {
            void var3_3;
            if (thread.getId() != 1L) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static ThreadGroup currentThreadGroup() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            void var0;
            return var0.getThreadGroup();
        }
        return Thread.currentThread().getThreadGroup();
    }

    /*
     * WARNING - void declaration
     */
    public static ThreadFactory newNamedThreadFactory(String prefix, boolean isDaemon) {
        void var1_1;
        String string;
        return new NamedThreadFactory(string, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ThreadFactory newNamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDaemon) {
        void var2_2;
        void var1_1;
        String string;
        return new NamedThreadFactory(string, (ThreadGroup)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ThreadFactory newNamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDaemon, Thread.UncaughtExceptionHandler handler) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return new NamedThreadFactory(string, (ThreadGroup)var1_1, (boolean)var2_2, (Thread.UncaughtExceptionHandler)var3_3);
    }

    public static void sync(Object obj) {
        Object object = obj;
        synchronized (object) {
            try {
                Object object2;
                object2.wait();
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ConcurrencyTester concurrencyTest(int threadSize, Runnable runnable) {
        void var1_1;
        int n;
        return new ConcurrencyTester(n).test((Runnable)var1_1);
    }

    public static ScheduledThreadPoolExecutor createScheduledExecutor(int corePoolSize) {
        int n;
        return new ScheduledThreadPoolExecutor(n);
    }

    /*
     * WARNING - void declaration
     */
    public static ScheduledThreadPoolExecutor schedule(ScheduledThreadPoolExecutor executor, Runnable command, long initialDelay, long period, boolean fixedRateOrFixedDelay) {
        void var2_2;
        void var1_1;
        return ThreadUtil.schedule(executor, (Runnable)var1_1, (long)var2_2, period, TimeUnit.MILLISECONDS, fixedRateOrFixedDelay);
    }

    /*
     * WARNING - void declaration
     */
    public static ScheduledThreadPoolExecutor schedule(ScheduledThreadPoolExecutor executor, Runnable command, long initialDelay, long period, TimeUnit timeUnit, boolean fixedRateOrFixedDelay) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        if (executor == null) {
            executor = ThreadUtil.createScheduledExecutor(2);
        }
        if (fixedRateOrFixedDelay) {
            executor.scheduleAtFixedRate(command, initialDelay, period, timeUnit);
        } else {
            void var2_2;
            void var1_1;
            executor.scheduleWithFixedDelay((Runnable)var1_1, (long)var2_2, period, timeUnit);
        }
        return scheduledThreadPoolExecutor;
    }
}

