/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.thread;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.util.StrUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadFactoryBuilder
implements Builder<ThreadFactory> {
    private static final long serialVersionUID = 1L;
    private ThreadFactory backingThreadFactory;
    private String namePrefix;
    private Boolean daemon;
    private Integer priority;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public static ThreadFactoryBuilder create() {
        return new ThreadFactoryBuilder();
    }

    /*
     * WARNING - void declaration
     */
    public ThreadFactoryBuilder setThreadFactory(ThreadFactory backingThreadFactory) {
        void var1_1;
        this.backingThreadFactory = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ThreadFactoryBuilder setNamePrefix(String namePrefix) {
        void var1_1;
        this.namePrefix = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ThreadFactoryBuilder setDaemon(boolean daemon) {
        void var1_1;
        this.daemon = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ThreadFactoryBuilder setPriority(int priority) {
        void var1_1;
        if (priority <= 0) {
            throw new IllegalArgumentException(StrUtil.format("Thread priority ({}) must be >= {}", priority, 1));
        }
        if (priority > 10) {
            throw new IllegalArgumentException(StrUtil.format("Thread priority ({}) must be <= {}", priority, 10));
        }
        this.priority = (int)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        void var1_1;
        this.uncaughtExceptionHandler = var1_1;
        return this;
    }

    @Override
    public ThreadFactory build() {
        return ThreadFactoryBuilder.build(this);
    }

    /*
     * WARNING - void declaration
     */
    private static ThreadFactory build(ThreadFactoryBuilder builder) {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        void var3_3;
        void var2_2;
        void var1_1;
        ThreadFactory backingThreadFactory = builder.backingThreadFactory != null ? builder.backingThreadFactory : Executors.defaultThreadFactory();
        String namePrefix = builder.namePrefix;
        Boolean daemon = builder.daemon;
        Integer priority = builder.priority;
        Thread.UncaughtExceptionHandler handler = builder.uncaughtExceptionHandler;
        AtomicLong count = namePrefix == null ? null : new AtomicLong();
        return arg_0 -> ThreadFactoryBuilder.lambda$build$0((ThreadFactory)var1_1, (String)var2_2, count, (Boolean)var3_3, priority, uncaughtExceptionHandler, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Thread lambda$build$0(ThreadFactory backingThreadFactory, String namePrefix, AtomicLong count, Boolean daemon, Integer priority, Thread.UncaughtExceptionHandler handler, Runnable r) {
        Thread thread;
        Thread thread2 = backingThreadFactory.newThread(r);
        if (namePrefix != null) {
            void var2_2;
            void var1_1;
            thread2.setName((String)var1_1 + var2_2.getAndIncrement());
        }
        if (daemon != null) {
            void var3_3;
            thread2.setDaemon(var3_3.booleanValue());
        }
        if (priority != null) {
            thread2.setPriority(priority);
        }
        if (handler != null) {
            thread2.setUncaughtExceptionHandler(handler);
        }
        return thread;
    }
}

