/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.thread;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.thread.ExecutorBuilder;
import cn.hutool.core.thread.NamedThreadFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public class SyncFinisher
implements Closeable {
    private final Set<Worker> workers;
    private final int threadSize;
    private ExecutorService executorService;
    private boolean isBeginAtSameTime;
    private final CountDownLatch beginLatch = new CountDownLatch(1);
    private CountDownLatch endLatch;
    private Thread.UncaughtExceptionHandler exceptionHandler;

    /*
     * WARNING - void declaration
     */
    public SyncFinisher(int threadSize) {
        void var1_1;
        this.threadSize = var1_1;
        this.workers = new LinkedHashSet<Worker>();
    }

    /*
     * WARNING - void declaration
     */
    public SyncFinisher setBeginAtSameTime(boolean isBeginAtSameTime) {
        void var1_1;
        this.isBeginAtSameTime = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SyncFinisher setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        void var1_1;
        this.exceptionHandler = var1_1;
        return this;
    }

    public SyncFinisher addRepeatWorker(final Runnable runnable) {
        for (int i = 0; i < this.threadSize; ++i) {
            this.addWorker(new Worker(){
                {
                    void var1_1;
                    super((SyncFinisher)var1_1);
                }

                @Override
                public void work() {
                    runnable.run();
                }
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SyncFinisher addWorker(Runnable runnable) {
        void var1_1;
        return this.addWorker(new Worker((Runnable)var1_1){
            final /* synthetic */ Runnable val$runnable;
            {
                void var1_1;
                this.val$runnable = runnable;
                super((SyncFinisher)var1_1);
            }

            @Override
            public void work() {
                this.val$runnable.run();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public synchronized SyncFinisher addWorker(Worker worker) {
        void var1_1;
        this.workers.add((Worker)var1_1);
        return this;
    }

    public void start() {
        this.start(true);
    }

    /*
     * WARNING - void declaration
     */
    public void start(boolean sync) {
        void var1_1;
        this.endLatch = new CountDownLatch(this.workers.size());
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.executorService = this.buildExecutor();
        }
        for (Worker worker : this.workers) {
            void var3_4;
            if (this.exceptionHandler != null) {
                this.executorService.execute(worker);
                continue;
            }
            this.executorService.submit((Runnable)var3_4);
        }
        this.beginLatch.countDown();
        if (var1_1 != false) {
            try {
                this.endLatch.await();
                return;
            }
            catch (InterruptedException e) {
                void var2_3;
                throw new UtilException((Throwable)var2_3);
            }
        }
    }

    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
        this.clearWorker();
    }

    public void stopNow() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        this.clearWorker();
    }

    public void clearWorker() {
        this.workers.clear();
    }

    public long count() {
        return this.endLatch.getCount();
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    private ExecutorService buildExecutor() {
        return ExecutorBuilder.create().setCorePoolSize(this.threadSize).setThreadFactory(new NamedThreadFactory("hutool-", null, false, this.exceptionHandler)).build();
    }

    public abstract class Worker
    implements Runnable {
        final /* synthetic */ SyncFinisher this$0;

        /*
         * WARNING - void declaration
         */
        public Worker(SyncFinisher this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            if (this.this$0.isBeginAtSameTime) {
                try {
                    this.this$0.beginLatch.await();
                }
                catch (InterruptedException e) {
                    void var1_1;
                    throw new UtilException((Throwable)var1_1);
                }
            }
            try {
                this.work();
                return;
            }
            finally {
                this.this$0.endLatch.countDown();
            }
        }

        public abstract void work();
    }
}

