/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.thread;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.thread.ExecutorBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class GlobalThreadPool {
    private static ExecutorService executor;

    private GlobalThreadPool() {
    }

    public static synchronized void init() {
        if (executor != null) {
            executor.shutdownNow();
        }
        executor = ExecutorBuilder.create().useSynchronousQueue().build();
    }

    public static synchronized void shutdown(boolean isNow) {
        if (executor != null) {
            boolean bl;
            if (bl) {
                executor.shutdownNow();
                return;
            }
            executor.shutdown();
        }
    }

    public static ExecutorService getExecutor() {
        return executor;
    }

    /*
     * WARNING - void declaration
     */
    public static void execute(Runnable runnable) {
        try {
            executor.execute(runnable);
            return;
        }
        catch (Exception e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1, "Exception when running task!", new Object[0]);
        }
    }

    public static <T> Future<T> submit(Callable<T> task) {
        Callable<T> callable;
        return executor.submit(callable);
    }

    public static Future<?> submit(Runnable runnable) {
        Runnable runnable2;
        return executor.submit(runnable2);
    }

    static {
        GlobalThreadPool.init();
    }
}

