/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.thread;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.thread.FinalizableDelegatedExecutorService;
import cn.hutool.core.thread.RejectPolicy;
import cn.hutool.core.util.ObjectUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorBuilder
implements Builder<ThreadPoolExecutor> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_QUEUE_CAPACITY = 1024;
    private int corePoolSize;
    private int maxPoolSize = Integer.MAX_VALUE;
    private long keepAliveTime = TimeUnit.SECONDS.toNanos(60L);
    private BlockingQueue<Runnable> workQueue;
    private ThreadFactory threadFactory;
    private RejectedExecutionHandler handler;
    private Boolean allowCoreThreadTimeOut;

    /*
     * WARNING - void declaration
     */
    public ExecutorBuilder setCorePoolSize(int corePoolSize) {
        void var1_1;
        this.corePoolSize = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorBuilder setMaxPoolSize(int maxPoolSize) {
        void var1_1;
        this.maxPoolSize = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorBuilder setKeepAliveTime(long keepAliveTime, TimeUnit unit) {
        void var1_1;
        void var3_2;
        return this.setKeepAliveTime(var3_2.toNanos((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorBuilder setKeepAliveTime(long keepAliveTime) {
        void var1_1;
        this.keepAliveTime = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorBuilder setWorkQueue(BlockingQueue<Runnable> workQueue) {
        void var1_1;
        this.workQueue = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorBuilder useArrayBlockingQueue(int capacity) {
        void var1_1;
        return this.setWorkQueue(new ArrayBlockingQueue<Runnable>((int)var1_1));
    }

    public ExecutorBuilder useSynchronousQueue() {
        return this.useSynchronousQueue(false);
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorBuilder useSynchronousQueue(boolean fair) {
        void var1_1;
        return this.setWorkQueue(new SynchronousQueue<Runnable>((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorBuilder setThreadFactory(ThreadFactory threadFactory) {
        void var1_1;
        this.threadFactory = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorBuilder setHandler(RejectedExecutionHandler handler) {
        void var1_1;
        this.handler = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorBuilder setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        void var1_1;
        this.allowCoreThreadTimeOut = (boolean)var1_1;
        return this;
    }

    public static ExecutorBuilder create() {
        return new ExecutorBuilder();
    }

    @Override
    public ThreadPoolExecutor build() {
        return ExecutorBuilder.build(this);
    }

    public ExecutorService buildFinalizable() {
        return new FinalizableDelegatedExecutorService(this.build());
    }

    /*
     * WARNING - void declaration
     */
    private static ThreadPoolExecutor build(ExecutorBuilder builder) {
        void var1_2;
        void var3_4;
        void var2_3;
        int corePoolSize = builder.corePoolSize;
        int maxPoolSize = builder.maxPoolSize;
        long keepAliveTime = builder.keepAliveTime;
        SynchronousQueue<Runnable> workQueue = builder.workQueue != null ? builder.workQueue : (corePoolSize <= 0 ? new SynchronousQueue<Runnable>() : new LinkedBlockingQueue(1024));
        ThreadFactory threadFactory = builder.threadFactory != null ? builder.threadFactory : Executors.defaultThreadFactory();
        RejectedExecutionHandler handler = ObjectUtil.defaultIfNull(builder.handler, RejectPolicy.ABORT.getValue());
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, (int)var2_3, (long)var3_4, TimeUnit.NANOSECONDS, workQueue, threadFactory, handler);
        if (builder.allowCoreThreadTimeOut != null) {
            ExecutorBuilder executorBuilder;
            threadPoolExecutor.allowCoreThreadTimeOut(executorBuilder.allowCoreThreadTimeOut);
        }
        return var1_2;
    }
}

