/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.split;

import cn.hutool.core.collection.ComputeIter;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.finder.TextFinder;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class SplitIter
extends ComputeIter<String>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String text;
    private final TextFinder finder;
    private final int limit;
    private final boolean ignoreEmpty;
    private int offset;
    private int count;

    /*
     * WARNING - void declaration
     */
    public SplitIter(CharSequence text, TextFinder separatorFinder, int limit, boolean ignoreEmpty) {
        int n;
        void var1_1;
        void var2_2;
        Assert.notNull(text, "Text must be not null!", new Object[0]);
        this.text = text.toString();
        this.finder = var2_2.setText((CharSequence)var1_1);
        this.limit = limit > 0 ? n : Integer.MAX_VALUE;
        this.ignoreEmpty = ignoreEmpty;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String computeNext() {
        void var2_3;
        void var1_1;
        if (this.count >= this.limit || this.offset > this.text.length()) {
            return null;
        }
        if (this.count == this.limit - 1) {
            if (this.ignoreEmpty && this.offset == this.text.length()) {
                return null;
            }
            ++this.count;
            return this.text.substring(this.offset);
        }
        int start = this.finder.start(this.offset);
        if (start < 0) {
            if (this.offset <= this.text.length()) {
                String result = this.text.substring(this.offset);
                if (!this.ignoreEmpty || !result.isEmpty()) {
                    this.offset = Integer.MAX_VALUE;
                    return result;
                }
            }
            return null;
        }
        String result = this.text.substring(this.offset, start);
        this.offset = this.finder.end((int)var1_1);
        if (this.ignoreEmpty && result.isEmpty()) {
            return this.computeNext();
        }
        ++this.count;
        return var2_3;
    }

    public void reset() {
        this.finder.reset();
        this.offset = 0;
        this.count = 0;
    }

    /*
     * WARNING - void declaration
     */
    public String[] toArray(boolean trim) {
        void var1_1;
        return this.toList((boolean)var1_1).toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> toList(boolean trim) {
        void var1_1;
        return this.toList(arg_0 -> SplitIter.lambda$toList$0((boolean)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> toList(Function<String, T> mapping) {
        void var2_2;
        ArrayList<void> result = new ArrayList<void>();
        while (this.hasNext()) {
            void var3_3;
            T apply = mapping.apply((String)this.next());
            if (this.ignoreEmpty && StrUtil.isEmptyIfStr(apply)) continue;
            result.add(var3_3);
        }
        if (result.isEmpty()) {
            return new ArrayList(0);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ String lambda$toList$0(boolean trim, String str) {
        void var1_1;
        if (trim) {
            return StrUtil.trim(str);
        }
        return var1_1;
    }
}

