/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.csv;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.csv.CsvData;
import cn.hutool.core.text.csv.CsvWriteConfig;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CsvWriter
implements Closeable,
Flushable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Writer writer;
    private final CsvWriteConfig config;
    private boolean newline = true;
    private boolean isFirstLine = true;

    /*
     * WARNING - void declaration
     */
    public CsvWriter(String filePath) {
        this(FileUtil.file((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CsvWriter(File file) {
        this((File)var1_1, CharsetUtil.CHARSET_UTF_8);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CsvWriter(String filePath, Charset charset) {
        this(FileUtil.file((String)var1_1), (Charset)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CsvWriter(File file, Charset charset) {
        this((File)var1_1, (Charset)var2_2, false);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CsvWriter(String filePath, Charset charset, boolean isAppend) {
        this(FileUtil.file((String)var1_1), (Charset)var2_2, (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CsvWriter(File file, Charset charset, boolean isAppend) {
        this((File)var1_1, (Charset)var2_2, (boolean)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CsvWriter(String filePath, Charset charset, boolean isAppend, CsvWriteConfig config) {
        this(FileUtil.file((String)var1_1), (Charset)var2_2, (boolean)var3_3, config);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CsvWriter(File file, Charset charset, boolean isAppend, CsvWriteConfig config) {
        this(FileUtil.getWriter((File)var1_1, (Charset)var2_2, isAppend), var3_3 != false ? (config == null ? CsvWriteConfig.defaultConfig().setEndingLineBreak(true) : config.setEndingLineBreak(true)) : config);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CsvWriter(Writer writer) {
        this((Writer)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CsvWriter(Writer writer, CsvWriteConfig config) {
        void var2_2;
        void var1_1;
        this.writer = writer instanceof BufferedWriter ? writer : new BufferedWriter((Writer)var1_1);
        this.config = ObjectUtil.defaultIfNull(var2_2, CsvWriteConfig::defaultConfig);
    }

    /*
     * WARNING - void declaration
     */
    public final CsvWriter setAlwaysDelimitText(boolean alwaysDelimitText) {
        void var1_1;
        this.config.setAlwaysDelimitText((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CsvWriter setLineDelimiter(char[] lineDelimiter) {
        void var1_1;
        this.config.setLineDelimiter((char[])var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CsvWriter write(String[] ... lines) throws IORuntimeException {
        void var1_1;
        return this.write(new ArrayIter((E[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final CsvWriter write(Iterable<?> lines) throws IORuntimeException {
        if (CollUtil.isNotEmpty(lines)) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Object values = iterator.next();
                this.appendLine(Convert.toStrArray(var2_2));
            }
            this.flush();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CsvWriter write(CsvData csvData) {
        if (csvData != null) {
            void var1_1;
            List<String> header = csvData.getHeader();
            if (CollUtil.isNotEmpty(header)) {
                void var2_2;
                this.writeHeaderLine(var2_2.toArray(new String[0]));
            }
            this.write(var1_1.getRows());
            this.flush();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CsvWriter writeBeans(Iterable<?> beans2) {
        if (CollUtil.isNotEmpty(beans2)) {
            boolean isFirst = true;
            for (Iterable<?> beans2 : beans2) {
                void var1_1;
                Map<String, Object> map = BeanUtil.beanToMap(beans2, new String[0]);
                if (isFirst) {
                    this.writeHeaderLine(map.keySet().toArray(new String[0]));
                    isFirst = false;
                }
                this.writeLine(Convert.toStrArray(var1_1.values()));
            }
            this.flush();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CsvWriter writeHeaderLine(String ... fields) throws IORuntimeException {
        void var1_1;
        Map<String, String> headerAlias = this.config.headerAlias;
        if (MapUtil.isNotEmpty(headerAlias)) {
            for (int i = 0; i < fields.length; ++i) {
                void var3_4;
                String alias = headerAlias.get(fields[i]);
                if (alias == null) continue;
                fields[i] = var3_4;
            }
        }
        return this.writeLine((String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final CsvWriter writeLine(String ... fields) throws IORuntimeException {
        void var1_1;
        if (ArrayUtil.isEmpty(fields)) {
            return this.writeLine();
        }
        this.appendLine((String[])var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CsvWriter writeLine() throws IORuntimeException {
        try {
            this.writer.write(this.config.lineDelimiter);
        }
        catch (IOException e) {
            void var1_1;
            throw new IORuntimeException((Throwable)var1_1);
        }
        this.newline = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final CsvWriter writeComment(String comment) {
        Assert.notNull(this.config.commentCharacter, "Comment is disable!", new Object[0]);
        try {
            if (this.isFirstLine) {
                this.isFirstLine = false;
            } else {
                this.writer.write(this.config.lineDelimiter);
            }
            this.writer.write(this.config.commentCharacter.charValue());
            this.writer.write(comment);
            this.newline = true;
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
        return this;
    }

    @Override
    public final void close() {
        if (this.config.endingLineBreak) {
            this.writeLine();
        }
        IoUtil.close(this.writer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void flush() throws IORuntimeException {
        try {
            this.writer.flush();
            return;
        }
        catch (IOException e) {
            void var1_1;
            throw new IORuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void appendLine(String ... fields) throws IORuntimeException {
        try {
            this.doAppendLine(fields);
            return;
        }
        catch (IOException e) {
            void var1_2;
            throw new IORuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doAppendLine(String ... fields) throws IOException {
        if (fields != null) {
            void var1_1;
            if (this.isFirstLine) {
                this.isFirstLine = false;
            } else {
                this.writer.write(this.config.lineDelimiter);
            }
            for (void field : var1_1) {
                this.appendField((String)field);
            }
            this.newline = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void appendField(String value) throws IOException {
        void var2_2;
        boolean needsTextDelimiter;
        char c;
        int n;
        boolean alwaysDelimitText = this.config.alwaysDelimitText;
        char textDelimiter = this.config.textDelimiter;
        char fieldSeparator = this.config.fieldSeparator;
        if (!this.newline) {
            this.writer.write(fieldSeparator);
        } else {
            this.newline = false;
        }
        if (value == null) {
            if (alwaysDelimitText) {
                this.writer.write(new char[]{textDelimiter, textDelimiter});
            }
            return;
        }
        char[] valueChars = value.toCharArray();
        boolean containsTextDelimiter = false;
        char[] cArray = valueChars;
        int n2 = valueChars.length;
        for (n = 0; n < n2; ++n) {
            c = cArray[n];
            if (c == textDelimiter) {
                needsTextDelimiter = true;
                containsTextDelimiter = true;
                break;
            }
            if (c != fieldSeparator && c != '\n' && c != '\r') continue;
            needsTextDelimiter = true;
        }
        if (needsTextDelimiter) {
            this.writer.write(textDelimiter);
        }
        if (containsTextDelimiter) {
            cArray = valueChars;
            n2 = valueChars.length;
            for (n = 0; n < n2; ++n) {
                c = cArray[n];
                if (c == textDelimiter) {
                    this.writer.write(textDelimiter);
                }
                this.writer.write(c);
            }
        } else {
            void var1_1;
            this.writer.write((char[])var1_1);
        }
        if (var2_2 != false) {
            void var3_3;
            this.writer.write((int)var3_3);
        }
    }
}

