/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.csv;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Assert;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class CsvRow
implements List<String> {
    private final long originalLineNumber;
    final Map<String, Integer> headerMap;
    final List<String> fields;

    /*
     * WARNING - void declaration
     */
    public CsvRow(long originalLineNumber, Map<String, Integer> headerMap, List<String> fields) {
        void var3_2;
        void var1_1;
        Assert.notNull(fields, "fields must be not null!", new Object[0]);
        this.originalLineNumber = var1_1;
        this.headerMap = var3_2;
        this.fields = fields;
    }

    public final long getOriginalLineNumber() {
        return this.originalLineNumber;
    }

    /*
     * WARNING - void declaration
     */
    public final String getByName(String name) {
        Assert.notNull(this.headerMap, "No header available!", new Object[0]);
        Integer col = this.headerMap.get(name);
        if (col != null) {
            void var1_1;
            return this.get(var1_1.intValue());
        }
        return null;
    }

    public final List<String> getRawList() {
        return this.fields;
    }

    /*
     * WARNING - void declaration
     */
    public final Map<String, String> getFieldMap() {
        void var1_1;
        if (this.headerMap == null) {
            throw new IllegalStateException("No header available");
        }
        LinkedHashMap<Map.Entry<String, Integer>, void> fieldMap = new LinkedHashMap<Map.Entry<String, Integer>, void>(this.headerMap.size(), 1.0f);
        for (Map.Entry<String, Integer> entry : this.headerMap.entrySet()) {
            void var3_4;
            String key = entry.getKey();
            Integer col = this.headerMap.get(key);
            String val = col == null ? null : this.get(col);
            fieldMap.put(entry, var3_4);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T toBean(Class<T> clazz) {
        void var1_1;
        return BeanUtil.toBeanIgnoreError(this.getFieldMap(), var1_1);
    }

    public final int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public final int size() {
        return this.fields.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.fields.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object o) {
        void var1_1;
        return this.fields.contains(var1_1);
    }

    @Override
    public final Iterator<String> iterator() {
        return this.fields.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.fields.toArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T[] toArray(T[] a) {
        void var1_1;
        return this.fields.toArray((T[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(String e) {
        void var1_1;
        return this.fields.add((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean remove(Object o) {
        void var1_1;
        return this.fields.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsAll(Collection<?> c) {
        void var1_1;
        return this.fields.containsAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends String> c) {
        void var1_1;
        return this.fields.addAll((Collection<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(int index, Collection<? extends String> c) {
        void var2_2;
        void var1_1;
        return this.fields.addAll((int)var1_1, (Collection<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeAll(Collection<?> c) {
        void var1_1;
        return this.fields.removeAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean retainAll(Collection<?> c) {
        void var1_1;
        return this.fields.retainAll((Collection<?>)var1_1);
    }

    @Override
    public final void clear() {
        this.fields.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String get(int index) {
        void var1_1;
        if (index >= this.fields.size()) {
            return null;
        }
        return this.fields.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String set(int index, String element) {
        void var2_2;
        void var1_1;
        return this.fields.set((int)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(int index, String element) {
        void var2_2;
        void var1_1;
        this.fields.add((int)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String remove(int index) {
        void var1_1;
        return this.fields.remove((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int indexOf(Object o) {
        void var1_1;
        return this.fields.indexOf(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int lastIndexOf(Object o) {
        void var1_1;
        return this.fields.lastIndexOf(var1_1);
    }

    @Override
    public final ListIterator<String> listIterator() {
        return this.fields.listIterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ListIterator<String> listIterator(int index) {
        void var1_1;
        return this.fields.listIterator((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<String> subList(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        return this.fields.subList((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder("CsvRow{");
        sb.append("originalLineNumber=");
        sb.append(this.originalLineNumber);
        sb.append(", ");
        sb.append("fields=");
        if (this.headerMap != null) {
            sb.append('{');
            Iterator<Map.Entry<String, String>> it = this.getFieldMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                sb.append(entry.getKey());
                sb.append('=');
                if (entry.getValue() != null) {
                    void var3_3;
                    sb.append((String)var3_3.getValue());
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append('}');
        } else {
            sb.append(this.fields.toString());
        }
        sb.append('}');
        return var1_1.toString();
    }
}

