/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.csv;

import cn.hutool.core.collection.ComputeIter;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.text.csv.CsvReadConfig;
import cn.hutool.core.text.csv.CsvRow;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

public final class CsvParser
extends ComputeIter<CsvRow>
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_ROW_CAPACITY = 10;
    private final Reader reader;
    private final CsvReadConfig config;
    private final Buffer buf = new Buffer(32768);
    private int preChar = -1;
    private boolean inQuotes;
    private final StrBuilder currentField = new StrBuilder(512);
    private CsvRow header;
    private long lineNo = -1L;
    private long inQuotesLineCount;
    private int firstLineFieldCount = -1;
    private int maxFieldCount;
    private boolean finished;

    /*
     * WARNING - void declaration
     */
    public CsvParser(Reader reader, CsvReadConfig config) {
        void var2_2;
        void var1_1;
        this.reader = (Reader)Objects.requireNonNull(var1_1, "reader must not be null");
        this.config = ObjectUtil.defaultIfNull(var2_2, CsvReadConfig::defaultConfig);
    }

    public final List<String> getHeader() {
        if (this.config.headerLineNo < 0L) {
            throw new IllegalStateException("No header available - header parsing is disabled");
        }
        if (this.lineNo < this.config.beginLineNo) {
            throw new IllegalStateException("No header available - call nextRow() first");
        }
        return this.header.fields;
    }

    @Override
    protected final CsvRow computeNext() {
        return this.nextRow();
    }

    /*
     * WARNING - void declaration
     */
    public final CsvRow nextRow() throws IORuntimeException {
        List<String> currentFields;
        int fieldCount;
        while (!this.finished && (fieldCount = (currentFields = this.readLine()).size()) > 0) {
            void var1_1;
            if (this.lineNo < this.config.beginLineNo) continue;
            if (this.lineNo > this.config.endLineNo) break;
            if (this.config.skipEmptyRows && fieldCount == 1 && currentFields.get(0).isEmpty()) continue;
            if (this.config.errorOnDifferentFieldCount) {
                if (this.firstLineFieldCount < 0) {
                    this.firstLineFieldCount = fieldCount;
                } else if (fieldCount != this.firstLineFieldCount) {
                    throw new IORuntimeException(String.format("Line %d has %d fields, but first line has %d fields", this.lineNo, fieldCount, this.firstLineFieldCount));
                }
            }
            if (fieldCount > this.maxFieldCount) {
                void var2_2;
                this.maxFieldCount = var2_2;
            }
            if (this.lineNo == this.config.headerLineNo && this.header == null) {
                this.initHeader(currentFields);
                continue;
            }
            return new CsvRow(this.lineNo, this.header == null ? null : this.header.headerMap, (List<String>)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void initHeader(List<String> currentFields) {
        void var1_1;
        void var2_2;
        LinkedHashMap<String, Integer> localHeaderMap = new LinkedHashMap<String, Integer>(currentFields.size());
        for (int i = 0; i < currentFields.size(); ++i) {
            String field = currentFields.get(i);
            if (MapUtil.isNotEmpty(this.config.headerAlias)) {
                field = ObjectUtil.defaultIfNull(this.config.headerAlias.get(field), field);
            }
            if (!StrUtil.isNotEmpty(field) || localHeaderMap.containsKey(field)) continue;
            localHeaderMap.put(field, i);
        }
        this.header = new CsvRow(this.lineNo, Collections.unmodifiableMap(var2_2), Collections.unmodifiableList(var1_1));
    }

    /*
     * Unable to fully structure code
     */
    private List<String> readLine() throws IORuntimeException {
        if (this.inQuotesLineCount > 0L) {
            this.lineNo += this.inQuotesLineCount;
            this.inQuotesLineCount = 0L;
        }
        currentFields = new ArrayList<String>(this.maxFieldCount > 0 ? this.maxFieldCount : 10);
        currentField = this.currentField;
        buf = this.buf;
        preChar = this.preChar;
        copyLen = 0;
        inComment = false;
        while (true) {
            block19: {
                block21: {
                    block20: {
                        block18: {
                            if (!buf.hasRemaining()) {
                                if (copyLen > 0) {
                                    buf.appendTo(currentField, copyLen);
                                }
                                if (buf.read(this.reader) < 0) {
                                    this.finished = true;
                                    if (!currentField.hasContent() && preChar != this.config.fieldSeparator) break;
                                    this.addField(currentFields, currentField.toStringAndReset());
                                    break;
                                }
                                copyLen = 0;
                            }
                            c = buf.get();
                            if ((preChar < 0 || preChar == 13 || preChar == 10) && null != this.config.commentCharacter && c == this.config.commentCharacter.charValue()) {
                                inComment = true;
                            }
                            if (inComment) {
                                if (c == '\r' || c == '\n') {
                                    ++this.lineNo;
                                    inComment = false;
                                }
                                buf.mark();
                                preChar = c;
                                continue;
                            }
                            if (!this.inQuotes) break block18;
                            if (c == this.config.textDelimiter) {
                                this.inQuotes = false;
                            } else if (this.isLineEnd(c, preChar)) {
                                ++this.inQuotesLineCount;
                            }
                            ++copyLen;
                            break block19;
                        }
                        if (c != this.config.fieldSeparator) break block20;
                        if (copyLen > 0) {
                            buf.appendTo(currentField, copyLen);
                            copyLen = 0;
                        }
                        buf.mark();
                        this.addField(currentFields, currentField.toStringAndReset());
                        break block19;
                    }
                    if (c != this.config.textDelimiter) break block21;
                    this.inQuotes = true;
                    ** GOTO lbl-1000
                }
                if (c == '\r') {
                    if (copyLen > 0) {
                        buf.appendTo(currentField, copyLen);
                    }
                    buf.mark();
                    this.addField(currentFields, currentField.toStringAndReset());
                    preChar = c;
                    break;
                }
                if (c == '\n') {
                    if (preChar != 13) {
                        if (copyLen > 0) {
                            buf.appendTo(currentField, copyLen);
                        }
                        buf.mark();
                        this.addField(currentFields, currentField.toStringAndReset());
                        preChar = c;
                        break;
                    }
                    buf.mark();
                } else lbl-1000:
                // 2 sources

                {
                    ++copyLen;
                }
            }
            preChar = c;
        }
        this.preChar = preChar;
        ++this.lineNo;
        return var1_1;
    }

    @Override
    public final void close() throws IOException {
        this.reader.close();
    }

    /*
     * WARNING - void declaration
     */
    private void addField(List<String> currentFields, String field) {
        void var2_2;
        void var1_1;
        void var3_3;
        char textDelimiter = this.config.textDelimiter;
        field = StrUtil.trim(field, 1, c -> {
            Character c2;
            return c.charValue() == '\n' || c2.charValue() == '\r';
        });
        field = StrUtil.unWrap(field, textDelimiter);
        field = StrUtil.replace((CharSequence)field, (CharSequence)("" + textDelimiter + textDelimiter), "" + (char)var3_3);
        if (this.config.trimField) {
            field = StrUtil.trim(field);
        }
        var1_1.add(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isLineEnd(char c, int preChar) {
        void var2_2;
        void var1_1;
        return (c == '\r' || var1_1 == 10) && var2_2 != 13;
    }

    private static class Buffer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final char[] buf;
        private int mark;
        private int position;
        private int limit;

        /*
         * WARNING - void declaration
         */
        Buffer(int capacity) {
            void var1_1;
            this.buf = new char[var1_1];
        }

        public final boolean hasRemaining() {
            return this.position < this.limit;
        }

        /*
         * WARNING - void declaration
         */
        int read(Reader reader) {
            void var1_2;
            int length;
            try {
                length = reader.read(this.buf);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            this.mark = 0;
            this.position = 0;
            this.limit = length;
            return (int)var1_2;
        }

        char get() {
            return this.buf[this.position++];
        }

        void mark() {
            this.mark = this.position;
        }

        /*
         * WARNING - void declaration
         */
        void appendTo(StrBuilder builder, int length) {
            void var2_2;
            builder.append(this.buf, this.mark, (int)var2_2);
        }
    }
}

