/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.csv;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.csv.CsvData;
import cn.hutool.core.text.csv.CsvParser;
import cn.hutool.core.text.csv.CsvReadConfig;
import cn.hutool.core.text.csv.CsvRow;
import cn.hutool.core.text.csv.CsvRowHandler;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CsvBaseReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    private final CsvReadConfig config;

    public CsvBaseReader() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    public CsvBaseReader(CsvReadConfig config) {
        void var1_1;
        this.config = ObjectUtil.defaultIfNull(var1_1, CsvReadConfig::defaultConfig);
    }

    /*
     * WARNING - void declaration
     */
    public void setFieldSeparator(char fieldSeparator) {
        void var1_1;
        this.config.setFieldSeparator((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setTextDelimiter(char textDelimiter) {
        void var1_1;
        this.config.setTextDelimiter((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setContainsHeader(boolean containsHeader) {
        void var1_1;
        this.config.setContainsHeader((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSkipEmptyRows(boolean skipEmptyRows) {
        void var1_1;
        this.config.setSkipEmptyRows((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setErrorOnDifferentFieldCount(boolean errorOnDifferentFieldCount) {
        void var1_1;
        this.config.setErrorOnDifferentFieldCount((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public CsvData read(File file) throws IORuntimeException {
        void var1_1;
        return this.read((File)var1_1, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public CsvData readFromStr(String csvStr) {
        void var1_1;
        return this.read(new StringReader((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void readFromStr(String csvStr, CsvRowHandler rowHandler) {
        void var2_2;
        void var1_1;
        CsvBaseReader csvBaseReader = this;
        csvBaseReader.read(csvBaseReader.parse(new StringReader((String)var1_1)), true, (CsvRowHandler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CsvData read(File file, Charset charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return this.read(Objects.requireNonNull(var1_1.toPath(), "file must not be null"), (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CsvData read(Path path) throws IORuntimeException {
        void var1_1;
        return this.read((Path)var1_1, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public CsvData read(Path path, Charset charset) throws IORuntimeException {
        void var2_2;
        void var1_1;
        Assert.notNull(path, "path must not be null", new Object[0]);
        return this.read(FileUtil.getReader((Path)var1_1, (Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public CsvData read(Reader reader) throws IORuntimeException {
        void var1_1;
        return this.read((Reader)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public CsvData read(Reader reader, boolean close) throws IORuntimeException {
        void var3_3;
        void var1_1;
        void var2_2;
        CsvParser csvParser = this.parse(reader);
        ArrayList rows = new ArrayList();
        this.read(csvParser, (boolean)var2_2, rows::add);
        List<String> header = this.config.headerLineNo > -1L ? csvParser.getHeader() : null;
        return new CsvData((List<String>)var1_1, (List<CsvRow>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public List<Map<String, String>> readMapList(Reader reader) throws IORuntimeException {
        void var2_2;
        void var1_1;
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read((Reader)var1_1, (CsvRow row) -> {
            void var1_1;
            result.add(var1_1.getFieldMap());
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> read(Reader reader, Class<T> clazz) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read((Reader)var1_1, arg_0 -> CsvBaseReader.lambda$read$1(result, (Class)var2_2, arg_0));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public <T> List<T> read(String csvStr, Class<T> clazz) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read((Reader)new StringReader((String)var1_1), arg_0 -> CsvBaseReader.lambda$read$2(result, (Class)var2_2, arg_0));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void read(Reader reader, CsvRowHandler rowHandler) throws IORuntimeException {
        void var2_2;
        void var1_1;
        this.read((Reader)var1_1, true, (CsvRowHandler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void read(Reader reader, boolean close, CsvRowHandler rowHandler) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        CsvBaseReader csvBaseReader = this;
        csvBaseReader.read(csvBaseReader.parse((Reader)var1_1), (boolean)var2_2, (CsvRowHandler)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void read(CsvParser csvParser, boolean close, CsvRowHandler rowHandler) throws IORuntimeException {
        try {
            while (csvParser.hasNext()) {
                rowHandler.handle((CsvRow)csvParser.next());
            }
            if (!close) return;
        }
        catch (Throwable throwable) {
            void var1_1;
            void var2_2;
            if (var2_2 == false) throw throwable;
            IoUtil.close((Closeable)var1_1);
            throw throwable;
        }
        IoUtil.close(csvParser);
    }

    /*
     * WARNING - void declaration
     */
    protected CsvParser parse(Reader reader) throws IORuntimeException {
        void var1_1;
        return new CsvParser((Reader)var1_1, this.config);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$read$2(List result, Class clazz, CsvRow row) {
        void var1_1;
        void var2_2;
        result.add(var2_2.toBean(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$read$1(List result, Class clazz, CsvRow row) {
        void var1_1;
        void var2_2;
        result.add(var2_2.toBean(var1_1));
    }
}

