/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;

public class TextSimilarity {
    /*
     * WARNING - void declaration
     */
    public static double similar(String strA, String strB) {
        void var1_3;
        String string;
        void var2_4;
        String newStrB;
        String newStrA;
        if (strA.length() < strB.length()) {
            newStrA = TextSimilarity.removeSign(strB);
            newStrB = TextSimilarity.removeSign(strA);
        } else {
            newStrA = TextSimilarity.removeSign(newStrB);
            newStrB = TextSimilarity.removeSign(strB);
        }
        int temp = Math.max(newStrA.length(), newStrB.length());
        if (temp == 0) {
            return 1.0;
        }
        int n = TextSimilarity.longestCommonSubstringLength((String)var2_4, string);
        return NumberUtil.div((float)n, (float)var1_3);
    }

    /*
     * WARNING - void declaration
     */
    public static String similar(String strA, String strB, int scale) {
        void var2_2;
        void var1_1;
        return NumberUtil.formatPercent(TextSimilarity.similar(strA, (String)var1_1), (int)var2_2);
    }

    public static String longestCommonSubstring(String strA, String strB) {
        int[][] matrix = TextSimilarity.generateMatrix(strA, strB);
        int m = strA.length();
        int n = strB.length();
        char[] result = new char[matrix[m][n]];
        int currentIndex = result.length - 1;
        while (matrix[m][n] != 0) {
            if (matrix[m][n] == matrix[m][n - 1]) {
                --n;
                continue;
            }
            if (matrix[m][n] == matrix[m - 1][n]) {
                --m;
                continue;
            }
            result[currentIndex] = strA.charAt(m - 1);
            --currentIndex;
            --n;
            --m;
        }
        return new String(result);
    }

    /*
     * WARNING - void declaration
     */
    private static String removeSign(String str) {
        void var2_2;
        int length = str.length();
        StringBuilder sb = StrUtil.builder(length);
        for (int i = 0; i < length; ++i) {
            void var3_4;
            char c = str.charAt(i);
            if (!TextSimilarity.isValidChar(c)) continue;
            sb.append((char)var3_4);
        }
        return var2_2.toString();
    }

    private static boolean isValidChar(char charValue) {
        char c;
        return charValue >= '\u4e00' && charValue <= '\u9fff' || charValue >= 'a' && charValue <= 'z' || charValue >= 'A' && charValue <= 'Z' || charValue >= '0' && c <= '9';
    }

    /*
     * WARNING - void declaration
     */
    private static int longestCommonSubstringLength(String strA, String strB) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        int m = strA.length();
        int n = strB.length();
        return TextSimilarity.generateMatrix(string, (String)var1_1)[var2_2][var3_3];
    }

    private static int[][] generateMatrix(String strA, String strB) {
        int m = strA.length();
        int n = strB.length();
        int[][] matrix = new int[m + 1][n + 1];
        for (int i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                matrix[i][j] = strA.charAt(i - 1) == strB.charAt(j - 1) ? matrix[i - 1][j - 1] + 1 : Math.max(matrix[i][j - 1], matrix[i - 1][j]);
            }
        }
        return matrix;
    }
}

