/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.collection.ArrayIter;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.function.Function;

public class StrJoiner
implements Serializable,
Appendable {
    private static final long serialVersionUID = 1L;
    private Appendable appendable;
    private CharSequence delimiter;
    private CharSequence prefix;
    private CharSequence suffix;
    private boolean wrapElement;
    private NullMode nullMode = NullMode.NULL_STRING;
    private String emptyResult = "";
    private boolean hasContent;

    /*
     * WARNING - void declaration
     */
    public static StrJoiner of(StrJoiner joiner) {
        void var1_1;
        StrJoiner strJoiner;
        StrJoiner joinerNew = new StrJoiner(joiner.delimiter, joiner.prefix, joiner.suffix);
        new StrJoiner(joiner.delimiter, joiner.prefix, joiner.suffix).wrapElement = joiner.wrapElement;
        joinerNew.nullMode = joiner.nullMode;
        joinerNew.emptyResult = strJoiner.emptyResult;
        return var1_1;
    }

    public static StrJoiner of(CharSequence delimiter) {
        CharSequence charSequence;
        return new StrJoiner(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static StrJoiner of(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        return new StrJoiner(charSequence, (CharSequence)var1_1, (CharSequence)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public StrJoiner(CharSequence delimiter) {
        this(null, (CharSequence)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StrJoiner(Appendable appendable, CharSequence delimiter) {
        this((Appendable)var1_1, (CharSequence)var2_2, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StrJoiner(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        this(null, (CharSequence)var1_1, (CharSequence)var2_2, (CharSequence)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StrJoiner(Appendable appendable, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        void var3_3;
        void var2_2;
        if (appendable != null) {
            void var1_1;
            this.appendable = appendable;
            this.checkHasContent((Appendable)var1_1);
        }
        this.delimiter = var2_2;
        this.prefix = var3_3;
        this.suffix = suffix;
    }

    /*
     * WARNING - void declaration
     */
    public StrJoiner setDelimiter(CharSequence delimiter) {
        void var1_1;
        this.delimiter = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrJoiner setPrefix(CharSequence prefix) {
        void var1_1;
        this.prefix = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrJoiner setSuffix(CharSequence suffix) {
        void var1_1;
        this.suffix = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrJoiner setWrapElement(boolean wrapElement) {
        void var1_1;
        this.wrapElement = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrJoiner setNullMode(NullMode nullMode) {
        void var1_1;
        this.nullMode = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrJoiner setEmptyResult(String emptyResult) {
        void var1_1;
        this.emptyResult = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrJoiner append(Object obj) {
        if (obj == null) {
            this.append((CharSequence)null);
        } else if (ArrayUtil.isArray(obj)) {
            this.append(new ArrayIter(obj));
        } else if (obj instanceof Iterator) {
            this.append((Iterator)obj);
        } else if (obj instanceof Iterable) {
            this.append(((Iterable)obj).iterator());
        } else {
            void var1_1;
            this.append(ObjectUtil.toString(var1_1));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public <T> StrJoiner append(T[] array) {
        void var1_1;
        if (array == null) {
            return this;
        }
        return this.append(new ArrayIter((E[])var1_1));
    }

    public <T> StrJoiner append(Iterator<T> iterator) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.append(iterator.next());
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public <T> StrJoiner append(T[] array, Function<T, ? extends CharSequence> toStrFunc) {
        void var2_2;
        void var1_1;
        return this.append(new ArrayIter((E[])var1_1), (Function<? super E, ? extends CharSequence>)((Function)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public <E> StrJoiner append(Iterable<E> iterable, Function<? super E, ? extends CharSequence> toStrFunc) {
        void var2_2;
        void var1_1;
        return this.append(IterUtil.getIter(var1_1), (Function<? super E, ? extends CharSequence>)var2_2);
    }

    public <E> StrJoiner append(Iterator<E> iterator, Function<? super E, ? extends CharSequence> toStrFunc) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.append(toStrFunc.apply(iterator.next()));
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StrJoiner append(CharSequence csq) {
        void var1_1;
        return this.append(csq, 0, StrUtil.length((CharSequence)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StrJoiner append(CharSequence csq, int startInclude, int endExclude) {
        if (csq == null) {
            switch (this.nullMode) {
                case IGNORE: {
                    return this;
                }
                case TO_EMPTY: {
                    csq = "";
                    break;
                }
                case NULL_STRING: {
                    csq = "null";
                    endExclude = 4;
                }
            }
        }
        try {
            void var3_3;
            void var2_2;
            void var1_1;
            Appendable appendable = this.prepare();
            if (this.wrapElement && StrUtil.isNotEmpty(this.prefix)) {
                appendable.append(this.prefix);
            }
            appendable.append((CharSequence)var1_1, (int)var2_2, (int)var3_3);
            if (this.wrapElement && StrUtil.isNotEmpty(this.suffix)) {
                appendable.append(this.suffix);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StrJoiner append(char c) {
        void var1_1;
        return this.append(String.valueOf((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public StrJoiner merge(StrJoiner strJoiner) {
        if (strJoiner != null && strJoiner.appendable != null) {
            void var1_1;
            String otherStr = strJoiner.toString();
            if (var1_1.wrapElement) {
                this.append(otherStr);
            } else {
                void var2_2;
                this.append(otherStr, this.prefix.length(), var2_2.length());
            }
        }
        return this;
    }

    public int length() {
        if (this.appendable != null) {
            return this.appendable.toString().length() + StrUtil.length(this.suffix);
        }
        if (this.emptyResult == null) {
            return -1;
        }
        return this.emptyResult.length();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        if (this.appendable == null) {
            return this.emptyResult;
        }
        String result = this.appendable.toString();
        if (!this.wrapElement && StrUtil.isNotEmpty(this.suffix)) {
            result = result + this.suffix;
        }
        return var1_1;
    }

    private Appendable prepare() throws IOException {
        if (this.hasContent) {
            this.appendable.append(this.delimiter);
        } else {
            if (this.appendable == null) {
                this.appendable = new StringBuilder();
            }
            if (!this.wrapElement && StrUtil.isNotEmpty(this.prefix)) {
                this.appendable.append(this.prefix);
            }
            this.hasContent = true;
        }
        return this.appendable;
    }

    /*
     * WARNING - void declaration
     */
    private void checkHasContent(Appendable appendable) {
        void var1_1;
        CharSequence charSequence;
        if (appendable instanceof CharSequence) {
            charSequence = (CharSequence)((Object)appendable);
            if (charSequence.length() > 0 && StrUtil.endWith(charSequence, this.delimiter)) {
                this.hasContent = true;
            }
            return;
        }
        String initStr = ((Object)charSequence).toString();
        if (StrUtil.isNotEmpty(initStr) && !StrUtil.endWith((CharSequence)var1_1, this.delimiter)) {
            this.hasContent = true;
        }
    }

    public static enum NullMode {
        IGNORE,
        TO_EMPTY,
        NULL_STRING;

    }
}

