/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;

public class StrBuilder
implements Serializable,
Appendable,
CharSequence {
    private static final long serialVersionUID = 6341229705927508451L;
    public static final int DEFAULT_CAPACITY = 16;
    private char[] value;
    private int position;

    public static StrBuilder create() {
        return new StrBuilder();
    }

    public static StrBuilder create(int initialCapacity) {
        int n;
        return new StrBuilder(n);
    }

    public static StrBuilder create(CharSequence ... strs) {
        CharSequence[] charSequenceArray;
        return new StrBuilder(charSequenceArray);
    }

    public StrBuilder() {
        this(16);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder(int initialCapacity) {
        void var1_1;
        this.value = new char[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder(CharSequence ... strs) {
        this(ArrayUtil.isEmpty(strs) ? 16 : StrBuilder.totalLength(strs) + 16);
        void var1_1;
        for (void str : var1_1) {
            this.append((CharSequence)str);
        }
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(Object obj) {
        void var1_1;
        StrBuilder strBuilder = this;
        return strBuilder.insert(strBuilder.position, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StrBuilder append(char c) {
        void var1_1;
        StrBuilder strBuilder = this;
        return strBuilder.insert(strBuilder.position, (char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(char[] src) {
        void var1_1;
        if (ArrayUtil.isEmpty(src)) {
            return this;
        }
        return this.append(src, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder append(char[] src, int srcPos, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        StrBuilder strBuilder = this;
        return strBuilder.insert(strBuilder.position, (char[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StrBuilder append(CharSequence csq) {
        void var1_1;
        StrBuilder strBuilder = this;
        return strBuilder.insert(strBuilder.position, (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StrBuilder append(CharSequence csq, int start, int end) {
        void var3_3;
        void var2_2;
        void var1_1;
        StrBuilder strBuilder = this;
        return strBuilder.insert(strBuilder.position, (CharSequence)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, Object obj) {
        void var2_2;
        void var1_1;
        if (obj instanceof CharSequence) {
            return this.insert(index, (CharSequence)obj);
        }
        return this.insert((int)var1_1, Convert.toStr(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, char c) {
        void var1_1;
        void var2_2;
        if (index < 0) {
            index = this.position + index;
        }
        if (index < 0) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.moveDataAfterIndex(index, 1);
        this.value[index] = var2_2;
        this.position = Math.max(this.position, (int)var1_1) + 1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, char[] src) {
        void var2_2;
        void var1_1;
        if (ArrayUtil.isEmpty(src)) {
            return this;
        }
        return this.insert((int)var1_1, src, 0, ((void)var2_2).length);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, char[] src, int srcPos, int length) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (ArrayUtil.isEmpty(src) || srcPos > src.length || length <= 0) {
            return this;
        }
        if (index < 0) {
            index = this.position + index;
        }
        if (index < 0) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (srcPos < 0) {
            srcPos = 0;
        } else if (srcPos + length > src.length) {
            length = src.length - srcPos;
        }
        this.moveDataAfterIndex(index, length);
        System.arraycopy(var2_2, (int)var3_3, this.value, index, length);
        this.position = Math.max(this.position, (int)var1_1) + length;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, CharSequence csq) {
        void var3_3;
        void var1_1;
        if (index < 0) {
            index = this.position + index;
        }
        if (index < 0) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (csq == null) {
            csq = "";
        }
        int len = csq.length();
        this.moveDataAfterIndex(index, csq.length());
        if (csq instanceof String) {
            ((String)csq).getChars(0, len, this.value, index);
        } else if (csq instanceof StringBuilder) {
            ((StringBuilder)csq).getChars(0, len, this.value, index);
        } else if (csq instanceof StringBuffer) {
            ((StringBuffer)csq).getChars(0, len, this.value, index);
        } else if (csq instanceof StrBuilder) {
            ((StrBuilder)csq).getChars(0, len, this.value, index);
        } else {
            int i = 0;
            int j = this.position;
            while (i < len) {
                this.value[j] = csq.charAt(i);
                ++i;
                ++j;
            }
        }
        this.position = Math.max(this.position, (int)var1_1) + var3_3;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder insert(int index, CharSequence csq, int start, int end) {
        void var1_1;
        void i;
        int csqLen;
        if (csq == null) {
            csq = "null";
        }
        if (start > (csqLen = csq.length())) {
            return this;
        }
        if (start < 0) {
            start = 0;
        }
        if (end > csqLen) {
            end = csqLen;
        }
        if (start >= end) {
            return this;
        }
        if (index < 0) {
            index = this.position + index;
        }
        if (index < 0) {
            throw new StringIndexOutOfBoundsException(index);
        }
        int length = end - start;
        this.moveDataAfterIndex(index, length);
        int j = this.position;
        while (i < end) {
            this.value[j] = csq.charAt((int)i);
            ++i;
            ++j;
        }
        this.position = Math.max(this.position, (int)var1_1) + length;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (srcBegin < 0) {
            srcBegin = 0;
        }
        if (srcEnd < 0) {
            srcEnd = 0;
        } else if (srcEnd > this.position) {
            srcEnd = this.position;
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, var3_3, dstBegin, (int)(var2_2 - var1_1));
        return this;
    }

    public boolean hasContent() {
        return this.position > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.position == 0;
    }

    public StrBuilder clear() {
        return this.reset();
    }

    public StrBuilder reset() {
        this.position = 0;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder delTo(int newPosition) {
        void var1_1;
        if (newPosition < 0) {
            newPosition = 0;
        }
        return this.del((int)var1_1, this.position);
    }

    /*
     * WARNING - void declaration
     */
    public StrBuilder del(int start, int end) throws StringIndexOutOfBoundsException {
        void var3_3;
        int len;
        if (start < 0) {
            start = 0;
        }
        if (end >= this.position) {
            this.position = start;
            return this;
        }
        if (end < 0) {
            end = 0;
        }
        if ((len = end - start) > 0) {
            void var2_2;
            void var1_1;
            System.arraycopy(this.value, start + len, this.value, (int)var1_1, this.position - var2_2);
            this.position -= len;
        } else if (var3_3 < 0) {
            throw new StringIndexOutOfBoundsException("Start is greater than End.");
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public String toString(boolean isReset) {
        if (this.position > 0) {
            void var2_2;
            void var1_1;
            String s = new String(this.value, 0, this.position);
            if (var1_1 != false) {
                this.reset();
            }
            return var2_2;
        }
        return "";
    }

    public String toStringAndReset() {
        return this.toString(true);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public int length() {
        return this.position;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public char charAt(int index) {
        void var1_1;
        if (index < 0) {
            index = this.position + index;
        }
        if (index < 0 || index > this.position) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharSequence subSequence(int start, int end) {
        void var2_2;
        void var1_1;
        return this.subString((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String subString(int start) {
        void var1_1;
        return this.subString((int)var1_1, this.position);
    }

    /*
     * WARNING - void declaration
     */
    public String subString(int start, int end) {
        void var1_1;
        void var2_2;
        return new String(this.value, start, (int)(var2_2 - var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void moveDataAfterIndex(int index, int length) {
        StrBuilder strBuilder = this;
        strBuilder.ensureCapacity(Math.max(strBuilder.position, index) + length);
        if (index < this.position) {
            void var2_2;
            System.arraycopy(this.value, index, this.value, index + var2_2, this.position - index);
            return;
        }
        if (index > this.position) {
            void var1_1;
            Arrays.fill(this.value, this.position, (int)var1_1, ' ');
        }
    }

    /*
     * WARNING - void declaration
     */
    private void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity - this.value.length > 0) {
            void var1_1;
            this.expandCapacity((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void expandCapacity(int minimumCapacity) {
        void var2_2;
        int newCapacity = (this.value.length << 1) + 2;
        if (newCapacity - minimumCapacity < 0) {
            void var1_1;
            newCapacity = var1_1;
        }
        if (newCapacity < 0) {
            throw new OutOfMemoryError("Capacity is too long and max than Integer.MAX");
        }
        this.value = Arrays.copyOf(this.value, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static int totalLength(CharSequence ... strs) {
        void var1_1;
        CharSequence[] charSequenceArray;
        int totalLength = 0;
        for (CharSequence str : charSequenceArray) {
            totalLength += str == null ? 0 : str.length();
        }
        return (int)var1_1;
    }
}

