/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.comparator.VersionComparator;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.text.StrSplitter;
import cn.hutool.core.text.finder.CharFinder;
import cn.hutool.core.text.finder.StrFinder;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class CharSequenceUtil {
    public static final int INDEX_NOT_FOUND = -1;
    public static final String NULL = "null";
    public static final String EMPTY = "";
    public static final String SPACE = " ";

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharUtil.isBlankChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence str) {
        return !CharSequenceUtil.isBlank(str);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        CharSequence[] charSequenceArray;
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!CharSequenceUtil.isBlank(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        CharSequence[] charSequenceArray;
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!CharSequenceUtil.isNotBlank(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        CharSequence charSequence;
        return str == null || charSequence.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !CharSequenceUtil.isEmpty(str);
    }

    public static String emptyIfNull(CharSequence str) {
        return CharSequenceUtil.nullToEmpty(str);
    }

    public static String nullToEmpty(CharSequence str) {
        return CharSequenceUtil.nullToDefault(str, EMPTY);
    }

    /*
     * WARNING - void declaration
     */
    public static String nullToDefault(CharSequence str, String defaultStr) {
        CharSequence charSequence;
        if (str == null) {
            void var1_1;
            return var1_1;
        }
        return charSequence.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String emptyToDefault(CharSequence str, String defaultStr) {
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str)) {
            void var1_1;
            return var1_1;
        }
        return charSequence.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String blankToDefault(CharSequence str, String defaultStr) {
        CharSequence charSequence;
        if (CharSequenceUtil.isBlank(str)) {
            void var1_1;
            return var1_1;
        }
        return charSequence.toString();
    }

    public static String emptyToNull(CharSequence str) {
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str)) {
            return null;
        }
        return charSequence.toString();
    }

    public static boolean hasEmpty(CharSequence ... strs) {
        CharSequence[] charSequenceArray;
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!CharSequenceUtil.isEmpty(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(CharSequence ... strs) {
        CharSequence[] charSequenceArray;
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!CharSequenceUtil.isNotEmpty(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(CharSequence ... args) {
        CharSequence[] charSequenceArray;
        return false == CharSequenceUtil.hasEmpty(charSequenceArray);
    }

    public static boolean isAllNotBlank(CharSequence ... args) {
        CharSequence[] charSequenceArray;
        return false == CharSequenceUtil.hasBlank(charSequenceArray);
    }

    public static boolean isNullOrUndefined(CharSequence str) {
        CharSequence charSequence;
        if (str == null) {
            return true;
        }
        return CharSequenceUtil.isNullOrUndefinedStr(charSequence);
    }

    public static boolean isEmptyOrUndefined(CharSequence str) {
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str)) {
            return true;
        }
        return CharSequenceUtil.isNullOrUndefinedStr(charSequence);
    }

    public static boolean isBlankOrUndefined(CharSequence str) {
        CharSequence charSequence;
        if (CharSequenceUtil.isBlank(str)) {
            return true;
        }
        return CharSequenceUtil.isNullOrUndefinedStr(charSequence);
    }

    private static boolean isNullOrUndefinedStr(CharSequence str) {
        CharSequence charSequence;
        CharSequence strString = str.toString().trim();
        return NULL.equals(strString) || "undefined".equals(charSequence);
    }

    public static String trim(CharSequence str) {
        CharSequence charSequence;
        if (str == null) {
            return null;
        }
        return CharSequenceUtil.trim(charSequence, 0);
    }

    public static String trimToEmpty(CharSequence str) {
        CharSequence charSequence;
        if (str == null) {
            return EMPTY;
        }
        return CharSequenceUtil.trim(charSequence);
    }

    public static String trimToNull(CharSequence str) {
        CharSequence charSequence;
        CharSequence trimStr = CharSequenceUtil.trim(str);
        if (EMPTY.equals(trimStr)) {
            return null;
        }
        return charSequence;
    }

    public static String trimStart(CharSequence str) {
        return CharSequenceUtil.trim(str, -1);
    }

    public static String trimEnd(CharSequence str) {
        return CharSequenceUtil.trim(str, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String trim(CharSequence str, int mode) {
        void var1_1;
        return CharSequenceUtil.trim(str, (int)var1_1, CharUtil::isBlankChar);
    }

    /*
     * WARNING - void declaration
     */
    public static String trim(CharSequence str, int mode, Predicate<Character> predicate) {
        CharSequence charSequence;
        CharSequence result;
        if (str == null) {
            result = null;
        } else {
            void var3_3;
            void var1_1;
            int start;
            int length = result.length();
            int end = length;
            if (mode <= 0) {
                for (start = 0; start < end && predicate.test(Character.valueOf(result.charAt(start))); ++start) {
                }
            }
            if (var1_1 >= 0) {
                while (start < end && predicate.test(Character.valueOf(result.charAt(end - 1)))) {
                    --end;
                }
            }
            result = start > 0 || end < var3_3 ? result.toString().substring(start, end) : result.toString();
        }
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startWith(CharSequence str, char c) {
        CharSequence charSequence;
        void var1_1;
        if (CharSequenceUtil.isEmpty(str)) {
            return false;
        }
        return var1_1 == charSequence.charAt(0);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.startWith(str, (CharSequence)var1_1, (boolean)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        if (str == null || prefix == null) {
            if (ignoreEquals) {
                return false;
            }
            return str == null && prefix == null;
        }
        boolean bl = str.toString().regionMatches(ignoreCase, 0, prefix.toString(), 0, prefix.length());
        if (bl) {
            void var2_2;
            void var1_1;
            CharSequence charSequence;
            void var3_3;
            return var3_3 == false || false == CharSequenceUtil.equals(charSequence, (CharSequence)var1_1, (boolean)var2_2);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startWith(CharSequence str, CharSequence prefix) {
        void var1_1;
        return CharSequenceUtil.startWith(str, (CharSequence)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startWithIgnoreEquals(CharSequence str, CharSequence prefix) {
        void var1_1;
        return CharSequenceUtil.startWith(str, (CharSequence)var1_1, false, true);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startWithIgnoreCase(CharSequence str, CharSequence prefix) {
        void var1_1;
        return CharSequenceUtil.startWith(str, (CharSequence)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startWithAny(CharSequence str, CharSequence ... prefixes) {
        void var1_1;
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(prefixes)) {
            return false;
        }
        for (void suffix : var1_1) {
            if (!CharSequenceUtil.startWith(str, (CharSequence)suffix, false)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startWithAnyIgnoreCase(CharSequence str, CharSequence ... suffixes) {
        void var1_1;
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(suffixes)) {
            return false;
        }
        for (void suffix : var1_1) {
            if (!CharSequenceUtil.startWith(str, (CharSequence)suffix, true)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endWith(CharSequence str, char c) {
        void var1_1;
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str)) {
            return false;
        }
        CharSequence charSequence2 = charSequence;
        return var1_1 == charSequence2.charAt(charSequence2.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.endWith(str, (CharSequence)var1_1, (boolean)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase, boolean ignoreEquals) {
        if (str == null || suffix == null) {
            if (ignoreEquals) {
                return false;
            }
            return str == null && suffix == null;
        }
        int strOffset = str.length() - suffix.length();
        boolean bl = str.toString().regionMatches(ignoreCase, strOffset, suffix.toString(), 0, suffix.length());
        if (bl) {
            void var2_2;
            void var1_1;
            CharSequence charSequence;
            void var3_3;
            return var3_3 == false || false == CharSequenceUtil.equals(charSequence, (CharSequence)var1_1, (boolean)var2_2);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endWith(CharSequence str, CharSequence suffix) {
        void var1_1;
        return CharSequenceUtil.endWith(str, (CharSequence)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endWithIgnoreCase(CharSequence str, CharSequence suffix) {
        void var1_1;
        return CharSequenceUtil.endWith(str, (CharSequence)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endWithAny(CharSequence str, CharSequence ... suffixes) {
        void var1_1;
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(suffixes)) {
            return false;
        }
        for (void suffix : var1_1) {
            if (!CharSequenceUtil.endWith(str, (CharSequence)suffix, false)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endWithAnyIgnoreCase(CharSequence str, CharSequence ... suffixes) {
        void var1_1;
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(suffixes)) {
            return false;
        }
        for (void suffix : var1_1) {
            if (!CharSequenceUtil.endWith(str, (CharSequence)suffix, true)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(CharSequence str, char searchChar) {
        void var1_1;
        return CharSequenceUtil.indexOf(str, (char)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(CharSequence str, CharSequence searchStr) {
        void var1_1;
        CharSequence charSequence;
        if (str == null || searchStr == null) {
            return false;
        }
        return charSequence.toString().contains((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        void var1_1;
        CharSequence charSequence;
        return null != CharSequenceUtil.getContainsStr(charSequence, (CharSequence[])var1_1);
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (!CharSequenceUtil.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!ArrayUtil.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnly(CharSequence str, char ... testChars) {
        if (!CharSequenceUtil.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (ArrayUtil.contains(testChars, str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAll(CharSequence str, CharSequence ... testChars) {
        void var1_1;
        if (CharSequenceUtil.isBlank(str) || ArrayUtil.isEmpty(testChars)) {
            return false;
        }
        for (void testChar : var1_1) {
            if (CharSequenceUtil.contains(str, (CharSequence)testChar)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsBlank(CharSequence str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!CharUtil.isBlankChar(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        void var1_1;
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(testStrs)) {
            return null;
        }
        for (void checkStr : var1_1) {
            if (checkStr == null || !str.toString().contains((CharSequence)checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        void var1_1;
        CharSequence charSequence;
        if (str == null) {
            return testStr == null;
        }
        return CharSequenceUtil.indexOfIgnoreCase(charSequence, (CharSequence)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        void var1_1;
        CharSequence charSequence;
        return null != CharSequenceUtil.getContainsStrIgnoreCase(charSequence, (CharSequence[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getContainsStrIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        void var1_1;
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(testStrs)) {
            return null;
        }
        for (void testStr : var1_1) {
            if (!CharSequenceUtil.containsIgnoreCase(str, (CharSequence)testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(CharSequence str, char searchChar) {
        void var1_1;
        return CharSequenceUtil.indexOf(str, (char)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(CharSequence str, char searchChar, int start) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return CharSequenceUtil.indexOf(charSequence, (char)var1_1, (int)var2_2, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(CharSequence text, char searchChar, int start, int end) {
        void var2_2;
        void var3_3;
        CharSequence charSequence;
        void var1_1;
        if (CharSequenceUtil.isEmpty(text)) {
            return -1;
        }
        return new CharFinder((char)var1_1).setText(charSequence).setEndIndex((int)var3_3).start((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        void var1_1;
        return CharSequenceUtil.indexOfIgnoreCase(str, (CharSequence)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.indexOf(str, (CharSequence)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(CharSequence text, CharSequence searchStr, int from, boolean ignoreCase) {
        void var2_2;
        CharSequence charSequence;
        void var3_3;
        void var1_1;
        if (CharSequenceUtil.isEmpty(text) || CharSequenceUtil.isEmpty(searchStr)) {
            if (CharSequenceUtil.equals(text, searchStr)) {
                return 0;
            }
            return -1;
        }
        return new StrFinder((CharSequence)var1_1, (boolean)var3_3).setText(charSequence).start((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        CharSequence charSequence;
        void var1_1;
        return CharSequenceUtil.lastIndexOfIgnoreCase(str, (CharSequence)var1_1, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.lastIndexOf(str, (CharSequence)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(CharSequence text, CharSequence searchStr, int from, boolean ignoreCase) {
        void var2_2;
        CharSequence charSequence;
        void var3_3;
        void var1_1;
        if (CharSequenceUtil.isEmpty(text) || CharSequenceUtil.isEmpty(searchStr)) {
            if (CharSequenceUtil.equals(text, searchStr)) {
                return 0;
            }
            return -1;
        }
        return new StrFinder((CharSequence)var1_1, (boolean)var3_3).setText(charSequence).setNegative(true).start((int)var2_2);
    }

    public static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return 0;
        }
        int found = 0;
        int index = -1;
        do {
            if ((index = CharSequenceUtil.indexOf(str, searchStr, index + 1, false)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    /*
     * WARNING - void declaration
     */
    public static String removeAll(CharSequence str, CharSequence strToRemove) {
        void var1_1;
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(strToRemove)) {
            return CharSequenceUtil.str(str);
        }
        return charSequence.toString().replace((CharSequence)var1_1, EMPTY);
    }

    /*
     * WARNING - void declaration
     */
    public static String removeAny(CharSequence str, CharSequence ... strsToRemove) {
        void var2_3;
        CharSequence charSequence;
        String result = CharSequenceUtil.str(str);
        if (CharSequenceUtil.isNotEmpty(charSequence)) {
            void var1_1;
            for (CharSequence strToRemove : var1_1) {
                result = CharSequenceUtil.removeAll((CharSequence)result, strToRemove);
            }
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static String removeAll(CharSequence str, char ... chars) {
        void var3_3;
        if (str == null || ArrayUtil.isEmpty(chars)) {
            return CharSequenceUtil.str(str);
        }
        int len = str.length();
        if (len == 0) {
            return CharSequenceUtil.str(str);
        }
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (ArrayUtil.contains(chars, c)) continue;
            builder.append(c);
        }
        return var3_3.toString();
    }

    public static String removeAllLineBreaks(CharSequence str) {
        return CharSequenceUtil.removeAll(str, '\r', '\n');
    }

    /*
     * WARNING - void declaration
     */
    public static String removePreAndLowerFirst(CharSequence str, int preLength) {
        CharSequence charSequence;
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            void var2_2;
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                void var1_1;
                return first + str.toString().substring((int)(var1_1 + true));
            }
            return String.valueOf((char)var2_2);
        }
        return charSequence.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String removePreAndLowerFirst(CharSequence str, CharSequence prefix) {
        void var1_1;
        return CharSequenceUtil.lowerFirst(CharSequenceUtil.removePrefix(str, (CharSequence)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String removePrefix(CharSequence str, CharSequence prefix) {
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(prefix)) {
            return CharSequenceUtil.str(str);
        }
        CharSequence str2 = str.toString();
        if (((String)str2).startsWith(prefix.toString())) {
            void var1_1;
            return CharSequenceUtil.subSuf(str2, var1_1.length());
        }
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    public static String removePrefixIgnoreCase(CharSequence str, CharSequence prefix) {
        void var2_2;
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(prefix)) {
            return CharSequenceUtil.str(str);
        }
        String str2 = str.toString();
        if (CharSequenceUtil.startWithIgnoreCase(charSequence, prefix)) {
            void var1_1;
            return CharSequenceUtil.subSuf(str2, var1_1.length());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(suffix)) {
            return CharSequenceUtil.str(str);
        }
        CharSequence str2 = str.toString();
        if (((String)str2).endsWith(suffix.toString())) {
            void var1_1;
            CharSequence charSequence2 = str2;
            return CharSequenceUtil.subPre(charSequence2, ((String)charSequence2).length() - var1_1.length());
        }
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    public static String removeSufAndLowerFirst(CharSequence str, CharSequence suffix) {
        void var1_1;
        return CharSequenceUtil.lowerFirst(CharSequenceUtil.removeSuffix(str, (CharSequence)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String removeSuffixIgnoreCase(CharSequence str, CharSequence suffix) {
        void var2_2;
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(suffix)) {
            return CharSequenceUtil.str(str);
        }
        String str2 = str.toString();
        if (CharSequenceUtil.endWithIgnoreCase(charSequence, suffix)) {
            void var1_1;
            String string = str2;
            return CharSequenceUtil.subPre(string, string.length() - var1_1.length());
        }
        return var2_2;
    }

    public static String cleanBlank(CharSequence str) {
        return CharSequenceUtil.filter(str, c -> {
            Character c2;
            return false == CharUtil.isBlankChar(c2.charValue());
        });
    }

    /*
     * WARNING - void declaration
     */
    public static String strip(CharSequence str, CharSequence prefixOrSuffix) {
        CharSequence charSequence;
        void var1_1;
        if (CharSequenceUtil.equals(str, prefixOrSuffix)) {
            return EMPTY;
        }
        void v0 = var1_1;
        return CharSequenceUtil.strip(charSequence, (CharSequence)v0, (CharSequence)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static String strip(CharSequence str, CharSequence prefix, CharSequence suffix) {
        void var3_3;
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int from = 0;
        int to = str.length();
        CharSequence str2 = str.toString();
        if (CharSequenceUtil.startWith(str2, prefix)) {
            void var1_1;
            from = var1_1.length();
        }
        if (CharSequenceUtil.endWith(str2, suffix)) {
            void var2_2;
            to -= var2_2.length();
        }
        return ((String)charSequence).substring(Math.min(from, to), Math.max((int)var3_3, to));
    }

    /*
     * WARNING - void declaration
     */
    public static String stripIgnoreCase(CharSequence str, CharSequence prefixOrSuffix) {
        void var1_1;
        void v0 = var1_1;
        return CharSequenceUtil.stripIgnoreCase(str, (CharSequence)v0, (CharSequence)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static String stripIgnoreCase(CharSequence str, CharSequence prefix, CharSequence suffix) {
        void var3_3;
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int from = 0;
        int to = str.length();
        CharSequence str2 = str.toString();
        if (CharSequenceUtil.startWithIgnoreCase(str2, prefix)) {
            void var1_1;
            from = var1_1.length();
        }
        if (CharSequenceUtil.endWithIgnoreCase(str2, suffix)) {
            void var2_2;
            to -= var2_2.length();
        }
        return ((String)charSequence).substring((int)var3_3, to);
    }

    /*
     * WARNING - void declaration
     */
    public static String addPrefixIfNot(CharSequence str, CharSequence prefix) {
        void var1_1;
        return CharSequenceUtil.prependIfMissing(str, prefix, new CharSequence[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static String addSuffixIfNot(CharSequence str, CharSequence suffix) {
        void var1_1;
        return CharSequenceUtil.appendIfMissing(str, suffix, new CharSequence[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static long[] splitToLong(CharSequence str, char separator) {
        void var1_1;
        CharSequence charSequence;
        return Convert.convert(long[].class, CharSequenceUtil.splitTrim(charSequence, (char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static long[] splitToLong(CharSequence str, CharSequence separator) {
        void var1_1;
        CharSequence charSequence;
        return Convert.convert(long[].class, CharSequenceUtil.splitTrim(charSequence, (CharSequence)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int[] splitToInt(CharSequence str, char separator) {
        void var1_1;
        CharSequence charSequence;
        return Convert.convert(int[].class, CharSequenceUtil.splitTrim(charSequence, (char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int[] splitToInt(CharSequence str, CharSequence separator) {
        void var1_1;
        CharSequence charSequence;
        return Convert.convert(int[].class, CharSequenceUtil.splitTrim(charSequence, (CharSequence)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> split(CharSequence str, char separator) {
        void var1_1;
        return CharSequenceUtil.split(str, (char)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitToArray(CharSequence str, CharSequence separator) {
        void var1_1;
        CharSequence charSequence;
        if (str == null) {
            return new String[0];
        }
        return StrSplitter.splitToArray((CharSequence)charSequence.toString(), CharSequenceUtil.str((CharSequence)var1_1), 0, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitToArray(CharSequence str, char separator) {
        void var1_1;
        return CharSequenceUtil.splitToArray(str, (char)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitToArray(CharSequence text, char separator, int limit) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        Assert.notNull(text, "Text must be not null!", new Object[0]);
        return StrSplitter.splitToArray((CharSequence)charSequence.toString(), (char)var1_1, (int)var2_2, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> split(CharSequence str, char separator, int limit) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.split(str, (char)var1_1, (int)var2_2, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> splitTrim(CharSequence str, char separator) {
        void var1_1;
        return CharSequenceUtil.splitTrim(str, (char)var1_1, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> splitTrim(CharSequence str, CharSequence separator) {
        void var1_1;
        return CharSequenceUtil.splitTrim(str, (CharSequence)var1_1, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> splitTrim(CharSequence str, char separator, int limit) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.split(str, (char)var1_1, (int)var2_2, true, true);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> splitTrim(CharSequence str, CharSequence separator, int limit) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.split(str, (CharSequence)var1_1, (int)var2_2, true, true);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> split(CharSequence str, char separator, boolean isTrim, boolean ignoreEmpty) {
        void var3_3;
        void var2_2;
        void var1_1;
        return CharSequenceUtil.split(str, (char)var1_1, 0, (boolean)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> split(CharSequence str, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        void var3_3;
        void var2_2;
        void var1_1;
        return StrSplitter.split(str, (char)var1_1, (int)var2_2, (boolean)var3_3, ignoreEmpty);
    }

    /*
     * WARNING - void declaration
     */
    public static <R> List<R> split(CharSequence str, char separator, int limit, boolean ignoreEmpty, Function<String, R> mapping) {
        void var3_3;
        void var2_2;
        void var1_1;
        return StrSplitter.split(str, (char)var1_1, (int)var2_2, (boolean)var3_3, mapping);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> split(CharSequence str, CharSequence separator) {
        void var1_1;
        return CharSequenceUtil.split(str, (CharSequence)var1_1, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> split(CharSequence str, CharSequence separator, boolean isTrim, boolean ignoreEmpty) {
        void var3_3;
        void var2_2;
        void var1_1;
        return CharSequenceUtil.split(str, (CharSequence)var1_1, 0, (boolean)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> split(CharSequence str, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        void var3_3;
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        String separatorStr = separator == null ? null : separator.toString();
        return StrSplitter.split(charSequence, (String)var1_1, (int)var2_2, (boolean)var3_3, ignoreEmpty);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] split(CharSequence str, int len) {
        void var1_1;
        return StrSplitter.splitByLength(str, (int)var1_1);
    }

    public static String[] cut(CharSequence str, int partLength) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len < partLength) {
            return new String[]{str.toString()};
        }
        int part = NumberUtil.count(len, partLength);
        String[] array = new String[part];
        CharSequence str2 = str.toString();
        for (int i = 0; i < part; ++i) {
            array[i] = ((String)str2).substring(i * partLength, i == part - 1 ? len : partLength + i * partLength);
        }
        return array;
    }

    /*
     * WARNING - void declaration
     */
    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            void var3_3;
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = var3_3;
        }
        if (fromIndexInclude == toIndexExclude) {
            return EMPTY;
        }
        return charSequence.toString().substring((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String subByCodePoint(CharSequence str, int fromIndex, int toIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        int subLen = toIndex - fromIndex;
        charSequence.toString().codePoints().skip((long)var1_1).limit((long)var2_2).forEach(v -> {
            void var1_1;
            sb.append(Character.toChars((int)var1_1));
        });
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String subPreGbk(CharSequence str, int len, CharSequence suffix) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        return CharSequenceUtil.subPreGbk(charSequence, (int)var1_1, true) + var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String subPreGbk(CharSequence str, int len, boolean halfUp) {
        void var1_2;
        void var3_4;
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int counterOfDoubleByte = 0;
        byte[] b = CharSequenceUtil.bytes(str, CharsetUtil.CHARSET_GBK);
        if (b.length <= len) {
            return str.toString();
        }
        for (int i = 0; i < len; ++i) {
            if (b[i] >= 0) continue;
            ++counterOfDoubleByte;
        }
        if (var3_4 % 2 != false) {
            void var2_3;
            len = var2_3 != false ? ++len : --len;
        }
        return new String(b, 0, (int)var1_2, CharsetUtil.CHARSET_GBK);
    }

    /*
     * WARNING - void declaration
     */
    public static String subPre(CharSequence string, int toIndexExclude) {
        void var1_1;
        return CharSequenceUtil.sub(string, 0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String subSuf(CharSequence string, int fromIndex) {
        CharSequence charSequence;
        void var1_1;
        if (CharSequenceUtil.isEmpty(string)) {
            return null;
        }
        return CharSequenceUtil.sub(string, (int)var1_1, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    public static String subSufByLength(CharSequence string, int length) {
        CharSequence charSequence;
        void var1_1;
        if (CharSequenceUtil.isEmpty(string)) {
            return null;
        }
        if (length <= 0) {
            return EMPTY;
        }
        return CharSequenceUtil.sub(string, (int)(-var1_1), charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    public static String subWithLength(String input, int fromIndex, int length) {
        void var2_2;
        void var1_1;
        String string;
        int toIndex;
        toIndex = fromIndex < 0 ? fromIndex - length : fromIndex + toIndex;
        return CharSequenceUtil.sub(string, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        void var1_2;
        CharSequence charSequence;
        void var2_3;
        int pos;
        if (CharSequenceUtil.isEmpty(string) || separator == null) {
            if (string == null) {
                return null;
            }
            return string.toString();
        }
        CharSequence str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return EMPTY;
        }
        int n = pos = var2_3 != false ? ((String)str).lastIndexOf(sep) : ((String)str).indexOf(sep);
        if (-1 == pos) {
            return str;
        }
        if (pos == 0) {
            return EMPTY;
        }
        return ((String)charSequence).substring(0, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        void var1_1;
        CharSequence charSequence;
        void var2_2;
        int pos;
        if (CharSequenceUtil.isEmpty(string)) {
            if (string == null) {
                return null;
            }
            return EMPTY;
        }
        CharSequence str = string.toString();
        int n = pos = var2_2 != false ? ((String)str).lastIndexOf(separator) : ((String)str).indexOf(separator);
        if (-1 == pos) {
            return str;
        }
        if (pos == 0) {
            return EMPTY;
        }
        return ((String)charSequence).substring(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        void var1_1;
        void var2_2;
        void var3_3;
        CharSequence charSequence;
        int pos;
        if (CharSequenceUtil.isEmpty(string)) {
            if (string == null) {
                return null;
            }
            return EMPTY;
        }
        if (separator == null) {
            return EMPTY;
        }
        String str = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos || charSequence.length() - 1 == pos) {
            return EMPTY;
        }
        return var3_3.substring((int)(var2_2 + var1_1.length()));
    }

    /*
     * WARNING - void declaration
     */
    public static String subAfter(CharSequence string, char separator, boolean isLastSeparator) {
        void var1_1;
        CharSequence charSequence;
        void var2_2;
        int pos;
        if (CharSequenceUtil.isEmpty(string)) {
            if (string == null) {
                return null;
            }
            return EMPTY;
        }
        CharSequence str = string.toString();
        int n = pos = var2_2 != false ? ((String)str).lastIndexOf(separator) : ((String)str).indexOf(separator);
        if (-1 == pos) {
            return EMPTY;
        }
        return ((String)charSequence).substring((int)(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        int end;
        if (str == null || before == null || after == null) {
            return null;
        }
        CharSequence str2 = str.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = ((String)str2).indexOf(before2);
        if (start != -1 && (end = ((String)str2).indexOf(after2, start + before2.length())) != -1) {
            void var2_3;
            void var1_1;
            void var3_4;
            CharSequence charSequence;
            return ((String)charSequence).substring((int)(var3_4 + var1_1.length()), (int)var2_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String subBetween(CharSequence str, CharSequence beforeAndAfter) {
        void var1_1;
        void v0 = var1_1;
        return CharSequenceUtil.subBetween(str, (CharSequence)v0, (CharSequence)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] subBetweenAll(CharSequence str, CharSequence prefix, CharSequence suffix) {
        void var3_5;
        if (CharSequenceUtil.hasEmpty(str, prefix, suffix) || !CharSequenceUtil.contains(str, prefix)) {
            return new String[0];
        }
        LinkedList<String> result = new LinkedList<String>();
        String[] split = CharSequenceUtil.splitToArray(str, prefix);
        if (prefix.equals(suffix)) {
            int length = split.length - 1;
            for (int i = 1; i < length; i += 2) {
                result.add(split[i]);
            }
        } else {
            for (int i = 1; i < split.length; ++i) {
                void var1_3;
                String fragment = split[i];
                int suffixIndex = fragment.indexOf(suffix.toString());
                if (suffixIndex <= 0) continue;
                result.add(fragment.substring(0, (int)var1_3));
            }
        }
        return var3_5.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] subBetweenAll(CharSequence str, CharSequence prefixAndSuffix) {
        void var1_1;
        void v0 = var1_1;
        return CharSequenceUtil.subBetweenAll(str, (CharSequence)v0, (CharSequence)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static String repeat(char c, int count) {
        void var1_2;
        char c2;
        if (count <= 0) {
            return EMPTY;
        }
        char[] result = new char[count];
        Arrays.fill(result, c2);
        return new String((char[])var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String repeat(CharSequence str, int count) {
        void var3_5;
        void var0_1;
        void var1_2;
        void n;
        if (str == null) {
            return null;
        }
        if (count <= 0 || str.length() == 0) {
            return EMPTY;
        }
        if (count == 1) {
            return str.toString();
        }
        int len = str.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        str.toString().getChars(0, len, array, 0);
        for (n = var2_3; n < size - n; n <<= 1) {
            void v0 = n;
            System.arraycopy(array, 0, array, (int)v0, (int)v0);
        }
        System.arraycopy(array, 0, array, (int)n, (int)(var1_2 - var0_1));
        return new String((char[])var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public static String repeatByLength(CharSequence str, int padLen) {
        void var3_3;
        if (str == null) {
            return null;
        }
        if (padLen <= 0) {
            return EMPTY;
        }
        int strLen = str.length();
        if (strLen == padLen) {
            return str.toString();
        }
        if (strLen > padLen) {
            return CharSequenceUtil.subPre(str, padLen);
        }
        char[] padding = new char[padLen];
        for (int i = 0; i < padLen; ++i) {
            padding[i] = str.charAt(i % strLen);
        }
        return new String((char[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static String repeatAndJoin(CharSequence str, int count, CharSequence delimiter) {
        void var3_3;
        if (count <= 0) {
            return EMPTY;
        }
        StringBuilder builder = new StringBuilder(str.length() * count);
        builder.append(str);
        boolean isAppendDelimiter = CharSequenceUtil.isNotEmpty(delimiter);
        while (true) {
            int n = --count;
            --count;
            if (n <= 0) break;
            if (isAppendDelimiter) {
                builder.append(delimiter);
            }
            builder.append(str);
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(CharSequence str1, CharSequence str2) {
        void var1_1;
        return CharSequenceUtil.equals(str1, (CharSequence)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        void var1_1;
        return CharSequenceUtil.equals(str1, (CharSequence)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        void var1_1;
        CharSequence charSequence;
        void var2_2;
        if (str1 == null) {
            return str2 == null;
        }
        if (str2 == null) {
            return false;
        }
        if (var2_2 != false) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return charSequence.toString().contentEquals((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsAnyIgnoreCase(CharSequence str1, CharSequence ... strs) {
        void var1_1;
        return CharSequenceUtil.equalsAny(str1, true, (CharSequence[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsAny(CharSequence str1, CharSequence ... strs) {
        void var1_1;
        return CharSequenceUtil.equalsAny(str1, false, (CharSequence[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsAny(CharSequence str1, boolean ignoreCase, CharSequence ... strs) {
        void var2_2;
        if (ArrayUtil.isEmpty(strs)) {
            return false;
        }
        for (void str : var2_2) {
            if (!CharSequenceUtil.equals(str1, (CharSequence)str, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsCharAt(CharSequence str, int position, char c) {
        void var1_1;
        CharSequence charSequence;
        void var2_2;
        if (str == null || position < 0) {
            return false;
        }
        return str.length() > position && var2_2 == charSequence.charAt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, boolean ignoreCase) {
        void var3_3;
        void var2_2;
        void var1_1;
        return CharSequenceUtil.isSubEquals(str1, (int)var1_1, str2, 0, var2_2.length(), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        void var3_3;
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (str1 == null || str2 == null) {
            return false;
        }
        return charSequence.toString().regionMatches(ignoreCase, (int)var1_1, var2_2.toString(), (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(CharSequence template, Object ... params) {
        void var1_1;
        CharSequence charSequence;
        if (template == null) {
            return NULL;
        }
        if (ArrayUtil.isEmpty(params) || CharSequenceUtil.isBlank(template)) {
            return template.toString();
        }
        return StrFormatter.format(charSequence.toString(), (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String indexedFormat(CharSequence pattern, Object ... arguments) {
        void var1_1;
        return MessageFormat.format(pattern.toString(), (Object[])var1_1);
    }

    public static byte[] utf8Bytes(CharSequence str) {
        return CharSequenceUtil.bytes(str, CharsetUtil.CHARSET_UTF_8);
    }

    public static byte[] bytes(CharSequence str) {
        return CharSequenceUtil.bytes(str, Charset.defaultCharset());
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] bytes(CharSequence str, String charset) {
        void var1_1;
        return CharSequenceUtil.bytes(str, CharSequenceUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] bytes(CharSequence str, Charset charset) {
        void var1_1;
        CharSequence charSequence;
        if (str == null) {
            return null;
        }
        if (charset == null) {
            return str.toString().getBytes();
        }
        return charSequence.toString().getBytes((Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer byteBuffer(CharSequence str, String charset) {
        void var1_1;
        return ByteBuffer.wrap(CharSequenceUtil.bytes(str, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String wrap(CharSequence str, CharSequence prefixAndSuffix) {
        void var1_1;
        void v0 = var1_1;
        return CharSequenceUtil.wrap(str, (CharSequence)v0, (CharSequence)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static String wrap(CharSequence str, CharSequence prefix, CharSequence suffix) {
        void var2_2;
        CharSequence charSequence;
        return CharSequenceUtil.nullToEmpty(prefix).concat(CharSequenceUtil.nullToEmpty(charSequence)).concat(CharSequenceUtil.nullToEmpty((CharSequence)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static String[] wrapAllWithPair(CharSequence prefixAndSuffix, CharSequence ... strs) {
        void var1_1;
        CharSequence charSequence = prefixAndSuffix;
        return CharSequenceUtil.wrapAll(charSequence, charSequence, (CharSequence[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] wrapAll(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        void var3_3;
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = CharSequenceUtil.wrap(strs[i], prefix, suffix);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static String wrapIfMissing(CharSequence str, CharSequence prefix, CharSequence suffix) {
        void var3_4;
        CharSequence charSequence;
        int len = 0;
        if (CharSequenceUtil.isNotEmpty(str)) {
            len = 0 + str.length();
        }
        if (CharSequenceUtil.isNotEmpty(prefix)) {
            len += prefix.length();
        }
        if (CharSequenceUtil.isNotEmpty(suffix)) {
            len += suffix.length();
        }
        StringBuilder sb = new StringBuilder(len);
        if (CharSequenceUtil.isNotEmpty(prefix) && !CharSequenceUtil.startWith(str, prefix)) {
            void var1_1;
            sb.append((CharSequence)var1_1);
        }
        if (CharSequenceUtil.isNotEmpty(str)) {
            sb.append(str);
        }
        if (CharSequenceUtil.isNotEmpty(suffix) && !CharSequenceUtil.endWith(charSequence, suffix)) {
            void var2_2;
            sb.append((CharSequence)var2_2);
        }
        return var3_4.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String[] wrapAllWithPairIfMissing(CharSequence prefixAndSuffix, CharSequence ... strs) {
        void var1_1;
        CharSequence charSequence = prefixAndSuffix;
        return CharSequenceUtil.wrapAllIfMissing(charSequence, charSequence, (CharSequence[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] wrapAllIfMissing(CharSequence prefix, CharSequence suffix, CharSequence ... strs) {
        void var3_3;
        String[] results = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            results[i] = CharSequenceUtil.wrapIfMissing(strs[i], prefix, suffix);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static String unWrap(CharSequence str, String prefix, String suffix) {
        CharSequence charSequence;
        if (CharSequenceUtil.isWrap(str, prefix, suffix)) {
            void var2_2;
            void var1_1;
            return CharSequenceUtil.sub(str, var1_1.length(), str.length() - var2_2.length());
        }
        return charSequence.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String unWrap(CharSequence str, char prefix, char suffix) {
        CharSequence charSequence;
        void var1_1;
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        if (str.charAt(0) == var1_1) {
            void var2_2;
            CharSequence charSequence2 = str;
            if (charSequence2.charAt(charSequence2.length() - 1) == var2_2) {
                return CharSequenceUtil.sub(str, 1, str.length() - 1);
            }
        }
        return charSequence.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String unWrap(CharSequence str, char prefixAndSuffix) {
        void var1_1;
        void v0 = var1_1;
        return CharSequenceUtil.unWrap(str, (char)v0, (char)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWrap(CharSequence str, String prefix, String suffix) {
        void var2_2;
        CharSequence charSequence;
        void var1_1;
        if (ArrayUtil.hasNull(str, prefix, suffix)) {
            return false;
        }
        CharSequence str2 = str.toString();
        return ((String)str2).startsWith((String)var1_1) && ((String)charSequence).endsWith((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWrap(CharSequence str, String wrapper) {
        void var1_1;
        void v0 = var1_1;
        return CharSequenceUtil.isWrap(str, (String)v0, (String)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWrap(CharSequence str, char wrapper) {
        void var1_1;
        void v0 = var1_1;
        return CharSequenceUtil.isWrap(str, (char)v0, (char)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWrap(CharSequence str, char prefixChar, char suffixChar) {
        void var1_1;
        if (str == null) {
            return false;
        }
        if (str.charAt(0) == var1_1) {
            void var2_2;
            CharSequence charSequence;
            CharSequence charSequence2 = charSequence;
            if (charSequence2.charAt(charSequence2.length() - 1) == var2_2) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static String padPre(CharSequence str, int length, CharSequence padStr) {
        CharSequence charSequence;
        void var3_3;
        void var1_1;
        void var2_2;
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen == length) {
            return str.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.subPre(str, length);
        }
        return CharSequenceUtil.repeatByLength((CharSequence)var2_2, (int)(var1_1 - var3_3)).concat(charSequence.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static String padPre(CharSequence str, int length, char padChar) {
        CharSequence charSequence;
        void var3_3;
        void var1_1;
        void var2_2;
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen == length) {
            return str.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.subPre(str, length);
        }
        return CharSequenceUtil.repeat((char)var2_2, (int)(var1_1 - var3_3)).concat(charSequence.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static String padAfter(CharSequence str, int length, char padChar) {
        void var3_3;
        void var1_1;
        void var2_2;
        CharSequence charSequence;
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen == length) {
            return str.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.sub(str, strLen - length, strLen);
        }
        return charSequence.toString().concat(CharSequenceUtil.repeat((char)var2_2, (int)(var1_1 - var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    public static String padAfter(CharSequence str, int length, CharSequence padStr) {
        void var3_3;
        void var1_1;
        void var2_2;
        CharSequence charSequence;
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen == length) {
            return str.toString();
        }
        if (strLen > length) {
            return CharSequenceUtil.subSufByLength(str, length);
        }
        return charSequence.toString().concat(CharSequenceUtil.repeatByLength((CharSequence)var2_2, (int)(var1_1 - var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    public static String center(CharSequence str, int size) {
        void var1_1;
        return CharSequenceUtil.center(str, (int)var1_1, ' ');
    }

    /*
     * WARNING - void declaration
     */
    public static String center(CharSequence str, int size, char padChar) {
        void var2_2;
        void var1_1;
        void var3_3;
        CharSequence charSequence;
        if (str == null || size <= 0) {
            return CharSequenceUtil.str(str);
        }
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str.toString();
        }
        charSequence = CharSequenceUtil.padPre(charSequence, (int)(var3_3 + pads / 2), padChar);
        charSequence = CharSequenceUtil.padAfter(charSequence, (int)var1_1, (char)var2_2);
        return charSequence.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String center(CharSequence str, int size, CharSequence padStr) {
        void var2_2;
        void var1_1;
        void var3_3;
        CharSequence charSequence;
        int strLen;
        int pads;
        if (str == null || size <= 0) {
            return CharSequenceUtil.str(str);
        }
        if (CharSequenceUtil.isEmpty(padStr)) {
            padStr = SPACE;
        }
        if ((pads = size - (strLen = str.length())) <= 0) {
            return str.toString();
        }
        charSequence = CharSequenceUtil.padPre(charSequence, (int)(var3_3 + pads / 2), padStr);
        charSequence = CharSequenceUtil.padAfter(charSequence, (int)var1_1, (CharSequence)var2_2);
        return charSequence.toString();
    }

    public static String str(CharSequence cs) {
        CharSequence charSequence;
        if (cs == null) {
            return null;
        }
        return charSequence.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static int count(CharSequence content, CharSequence strForSearch) {
        void var2_2;
        if (CharSequenceUtil.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        CharSequence content2 = content.toString();
        String strForSearch2 = strForSearch.toString();
        while ((idx = ((String)content2).indexOf(strForSearch2, idx)) >= 0) {
            ++count;
            idx += strForSearch.length();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int count(CharSequence content, char charForSearch) {
        void var2_2;
        int count = 0;
        if (CharSequenceUtil.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        void var1_1;
        CharSequence charSequence;
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            if (nullIsLess) {
                return -1;
            }
            return 1;
        }
        if (str2 == null) {
            void var2_2;
            if (var2_2 != false) {
                return 1;
            }
            return -1;
        }
        return charSequence.toString().compareTo(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static int compareIgnoreCase(CharSequence str1, CharSequence str2, boolean nullIsLess) {
        void var1_1;
        CharSequence charSequence;
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            if (nullIsLess) {
                return -1;
            }
            return 1;
        }
        if (str2 == null) {
            void var2_2;
            if (var2_2 != false) {
                return 1;
            }
            return -1;
        }
        return charSequence.toString().compareToIgnoreCase(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static int compareVersion(CharSequence version1, CharSequence version2) {
        void var1_1;
        CharSequence charSequence;
        return VersionComparator.INSTANCE.compare(CharSequenceUtil.str(charSequence), CharSequenceUtil.str((CharSequence)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String appendIfMissing(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.appendIfMissing(str, (CharSequence)var1_1, false, (CharSequence[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String appendIfMissingIgnoreCase(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.appendIfMissing(str, (CharSequence)var1_1, true, (CharSequence[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String appendIfMissing(CharSequence str, CharSequence suffix, boolean ignoreCase, CharSequence ... testSuffixes) {
        void var1_1;
        CharSequence charSequence;
        if (str == null || CharSequenceUtil.isEmpty(suffix) || CharSequenceUtil.endWith(str, suffix, ignoreCase)) {
            return CharSequenceUtil.str(str);
        }
        if (ArrayUtil.isNotEmpty(testSuffixes)) {
            void var3_3;
            for (void testSuffix : var3_3) {
                if (!CharSequenceUtil.endWith(str, (CharSequence)testSuffix, ignoreCase)) continue;
                return str.toString();
            }
        }
        return charSequence.toString().concat(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static String prependIfMissing(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.prependIfMissing(str, (CharSequence)var1_1, false, (CharSequence[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String prependIfMissingIgnoreCase(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.prependIfMissing(str, (CharSequence)var1_1, true, (CharSequence[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String prependIfMissing(CharSequence str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        CharSequence charSequence;
        void var1_1;
        if (str == null || CharSequenceUtil.isEmpty(prefix) || CharSequenceUtil.startWith(str, prefix, ignoreCase)) {
            return CharSequenceUtil.str(str);
        }
        if (prefixes != null) {
            void var3_3;
            for (void s : var3_3) {
                if (!CharSequenceUtil.startWith(str, (CharSequence)s, ignoreCase)) continue;
                return str.toString();
            }
        }
        return var1_1.toString().concat(charSequence.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceIgnoreCase(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.replace(str, 0, (CharSequence)var1_1, (CharSequence)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.replace(str, 0, (CharSequence)var1_1, (CharSequence)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        void var3_3;
        void var2_2;
        void var1_1;
        return CharSequenceUtil.replace(str, 0, (CharSequence)var1_1, (CharSequence)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(CharSequence str, int fromIndex, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        int preIndex;
        int index;
        int searchStrLength;
        int strLength;
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(searchStr)) {
            return CharSequenceUtil.str(str);
        }
        if (replacement == null) {
            replacement = EMPTY;
        }
        if ((strLength = str.length()) < (searchStrLength = searchStr.length())) {
            return CharSequenceUtil.str(str);
        }
        if (fromIndex > strLength) {
            return CharSequenceUtil.str(str);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        StringBuilder result = new StringBuilder(strLength - searchStrLength + replacement.length());
        if (fromIndex != 0) {
            result.append(str.subSequence(0, fromIndex));
        }
        while ((index = CharSequenceUtil.indexOf(str, searchStr, preIndex, ignoreCase)) >= 0) {
            result.append(str.subSequence(preIndex, index));
            result.append(replacement);
            preIndex = index + searchStrLength;
        }
        if (preIndex < strLength) {
            void var1_1;
            CharSequence charSequence;
            result.append(charSequence.subSequence((int)var1_1, strLength));
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String replace(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        void var3_3;
        void var2_2;
        void var1_1;
        return CharSequenceUtil.replaceByCodePoint(str, (int)var1_1, (int)var2_2, (char)var3_3);
    }

    public static String replaceByCodePoint(CharSequence str, int startInclude, int endExclude, char replacedChar) {
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        CharSequence originalStr = CharSequenceUtil.str(str);
        int[] strCodePoints = ((String)originalStr).codePoints().toArray();
        int strLength = strCodePoints.length;
        if (startInclude > strLength) {
            return originalStr;
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return originalStr;
        }
        CharSequence stringBuilder = new StringBuilder();
        for (int i = 0; i < strLength; ++i) {
            if (i >= startInclude && i < endExclude) {
                ((StringBuilder)stringBuilder).append(replacedChar);
                continue;
            }
            ((StringBuilder)stringBuilder).append(new String(strCodePoints, i, 1));
        }
        return ((StringBuilder)charSequence).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String replace(CharSequence str, int startInclude, int endExclude, CharSequence replacedStr) {
        void var3_3;
        void var2_2;
        void var1_1;
        return CharSequenceUtil.replaceByCodePoint(str, (int)var1_1, (int)var2_2, (CharSequence)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceByCodePoint(CharSequence str, int startInclude, int endExclude, CharSequence replacedStr) {
        CharSequence charSequence;
        void var3_3;
        int i;
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        CharSequence originalStr = CharSequenceUtil.str(str);
        int[] strCodePoints = ((String)originalStr).codePoints().toArray();
        int strLength = strCodePoints.length;
        if (startInclude > strLength) {
            return originalStr;
        }
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (startInclude > endExclude) {
            return originalStr;
        }
        CharSequence stringBuilder = new StringBuilder();
        for (i = 0; i < startInclude; ++i) {
            ((StringBuilder)stringBuilder).append(new String(strCodePoints, i, 1));
        }
        ((StringBuilder)stringBuilder).append((CharSequence)var3_3);
        for (i = var2_2; i < strLength; ++i) {
            ((StringBuilder)stringBuilder).append(new String(strCodePoints, i, 1));
        }
        return ((StringBuilder)charSequence).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(CharSequence str, Pattern pattern, Func1<java.util.regex.Matcher, String> replaceFun) {
        void var2_2;
        void var1_1;
        return ReUtil.replaceAll(str, (Pattern)var1_1, (Func1<java.util.regex.Matcher, String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(CharSequence str, String regex, Func1<java.util.regex.Matcher, String> replaceFun) {
        void var2_2;
        void var1_1;
        return ReUtil.replaceAll(str, (String)var1_1, (Func1<java.util.regex.Matcher, String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceLast(CharSequence str, CharSequence searchStr, CharSequence replacedStr) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.replaceLast(str, (CharSequence)var1_1, (CharSequence)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceLast(CharSequence str, CharSequence searchStr, CharSequence replacedStr, boolean ignoreCase) {
        void var3_3;
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int lastIndex = CharSequenceUtil.lastIndexOf(str, searchStr, str.length(), ignoreCase);
        if (-1 == lastIndex) {
            return CharSequenceUtil.str(str);
        }
        return CharSequenceUtil.replace(charSequence, lastIndex, (CharSequence)var1_1, (CharSequence)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceFirst(CharSequence str, CharSequence searchStr, CharSequence replacedStr) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.replaceFirst(str, (CharSequence)var1_1, (CharSequence)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceFirst(CharSequence str, CharSequence searchStr, CharSequence replacedStr, boolean ignoreCase) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        void var3_3;
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int startInclude = CharSequenceUtil.indexOf(str, searchStr, 0, ignoreCase);
        if (-1 == startInclude) {
            return CharSequenceUtil.str(str);
        }
        void v0 = var3_3;
        return CharSequenceUtil.replaceByCodePoint(charSequence, (int)v0, (int)(v0 + var1_1.length()), (CharSequence)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String hide(CharSequence str, int startInclude, int endExclude) {
        void var2_2;
        void var1_1;
        return CharSequenceUtil.replaceByCodePoint(str, (int)var1_1, (int)var2_2, '*');
    }

    /*
     * WARNING - void declaration
     */
    public static String desensitized(CharSequence str, DesensitizedUtil.DesensitizedType desensitizedType) {
        void var1_1;
        return DesensitizedUtil.desensitized(str, (DesensitizedUtil.DesensitizedType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceChars(CharSequence str, String chars, CharSequence replacedStr) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str) || CharSequenceUtil.isEmpty(chars)) {
            return CharSequenceUtil.str(str);
        }
        return CharSequenceUtil.replaceChars(charSequence, var1_1.toCharArray(), (CharSequence)var2_2);
    }

    public static String replaceChars(CharSequence str, char[] chars, CharSequence replacedStr) {
        if (CharSequenceUtil.isEmpty(str) || ArrayUtil.isEmpty(chars)) {
            return CharSequenceUtil.str(str);
        }
        HashSet<Character> set = new HashSet<Character>(chars.length);
        for (char c : chars) {
            set.add(Character.valueOf(c));
        }
        int strLen = str.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            builder.append(set.contains(Character.valueOf(c)) ? replacedStr : Character.valueOf(c));
        }
        return builder.toString();
    }

    public static int length(CharSequence cs) {
        CharSequence charSequence;
        if (cs == null) {
            return 0;
        }
        return charSequence.length();
    }

    /*
     * WARNING - void declaration
     */
    public static int byteLength(CharSequence cs, Charset charset) {
        void var1_1;
        CharSequence charSequence;
        if (cs == null) {
            return 0;
        }
        return charSequence.toString().getBytes((Charset)var1_1).length;
    }

    /*
     * WARNING - void declaration
     */
    public static int totalLength(CharSequence ... strs) {
        void var1_1;
        CharSequence[] charSequenceArray;
        int totalLength = 0;
        for (CharSequence str : charSequenceArray) {
            totalLength += str == null ? 0 : str.length();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String maxLength(CharSequence string, int length) {
        void var1_1;
        CharSequence charSequence;
        Assert.isTrue(length > 0);
        if (string == null) {
            return null;
        }
        if (string.length() <= length) {
            return string.toString();
        }
        return CharSequenceUtil.sub(charSequence, 0, (int)var1_1) + "...";
    }

    public static <T extends CharSequence> T firstNonNull(T ... strs) {
        return (T)((CharSequence)ArrayUtil.firstNonNull(strs));
    }

    public static <T extends CharSequence> T firstNonEmpty(T ... strs) {
        T[] TArray;
        return (T)ArrayUtil.firstMatch(CharSequenceUtil::isNotEmpty, TArray);
    }

    public static <T extends CharSequence> T firstNonBlank(T ... strs) {
        T[] TArray;
        return (T)ArrayUtil.firstMatch(CharSequenceUtil::isNotBlank, TArray);
    }

    /*
     * WARNING - void declaration
     */
    public static String upperFirstAndAddPre(CharSequence str, String preString) {
        CharSequence charSequence;
        void var1_1;
        if (str == null || preString == null) {
            return null;
        }
        return (String)var1_1 + CharSequenceUtil.upperFirst(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static String upperFirst(CharSequence str) {
        CharSequence charSequence;
        char firstChar;
        if (str == null) {
            return null;
        }
        if (str.length() > 0 && Character.isLowerCase(firstChar = str.charAt(0))) {
            void var1_1;
            return Character.toUpperCase((char)var1_1) + CharSequenceUtil.subSuf(str, 1);
        }
        return charSequence.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String lowerFirst(CharSequence str) {
        CharSequence charSequence;
        char firstChar;
        if (str == null) {
            return null;
        }
        if (str.length() > 0 && Character.isUpperCase(firstChar = str.charAt(0))) {
            void var1_1;
            return Character.toLowerCase((char)var1_1) + CharSequenceUtil.subSuf(str, 1);
        }
        return charSequence.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String filter(CharSequence str, Filter<Character> filter) {
        void var3_3;
        if (str == null || filter == null) {
            return CharSequenceUtil.str(str);
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!filter.accept(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return var3_3.toString();
    }

    public static boolean isUpperCase(CharSequence str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static String swapCase(String str) {
        Object object;
        if (CharSequenceUtil.isEmpty(str)) {
            return str;
        }
        Object buffer = str.toCharArray();
        for (int i = 0; i < ((Object)buffer).length; ++i) {
            void var2_2;
            Object ch = buffer[i];
            if (Character.isUpperCase((char)ch)) {
                buffer[i] = Character.toLowerCase((char)ch);
                continue;
            }
            if (Character.isTitleCase((char)ch)) {
                buffer[i] = Character.toLowerCase((char)ch);
                continue;
            }
            if (!Character.isLowerCase((char)ch)) continue;
            buffer[i] = Character.toUpperCase((char)var2_2);
        }
        return new String((char[])object);
    }

    public static String toUnderlineCase(CharSequence str) {
        return NamingCase.toUnderlineCase(str);
    }

    /*
     * WARNING - void declaration
     */
    public static String toSymbolCase(CharSequence str, char symbol) {
        void var1_1;
        return NamingCase.toSymbolCase(str, (char)var1_1);
    }

    public static String toCamelCase(CharSequence name) {
        return NamingCase.toCamelCase(name);
    }

    /*
     * WARNING - void declaration
     */
    public static String toCamelCase(CharSequence name, char symbol) {
        void var1_1;
        return NamingCase.toCamelCase(name, (char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSurround(CharSequence str, CharSequence prefix, CharSequence suffix) {
        void var2_2;
        CharSequence charSequence;
        void var1_1;
        if (CharSequenceUtil.isBlank(str)) {
            return false;
        }
        if (str.length() < prefix.length() + suffix.length()) {
            return false;
        }
        CharSequence str2 = str.toString();
        return ((String)str2).startsWith(var1_1.toString()) && ((String)charSequence).endsWith(var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSurround(CharSequence str, char prefix, char suffix) {
        void var1_1;
        if (CharSequenceUtil.isBlank(str)) {
            return false;
        }
        if (str.length() < 2) {
            return false;
        }
        if (str.charAt(0) == var1_1) {
            void var2_2;
            CharSequence charSequence;
            CharSequence charSequence2 = charSequence;
            if (charSequence2.charAt(charSequence2.length() - 1) == var2_2) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static StringBuilder builder(CharSequence ... strs) {
        void var1_1;
        CharSequence[] charSequenceArray;
        StringBuilder sb = new StringBuilder();
        for (CharSequence str : charSequenceArray) {
            sb.append(str);
        }
        return var1_1;
    }

    public static StrBuilder strBuilder(CharSequence ... strs) {
        return StrBuilder.create(strs);
    }

    /*
     * WARNING - void declaration
     */
    public static String getGeneralField(CharSequence getOrSetMethodName) {
        void var1_1;
        String getOrSetMethodNameStr = getOrSetMethodName.toString();
        if (getOrSetMethodNameStr.startsWith("get") || getOrSetMethodNameStr.startsWith("set")) {
            return CharSequenceUtil.removePreAndLowerFirst(getOrSetMethodName, 3);
        }
        if (var1_1.startsWith("is")) {
            CharSequence charSequence;
            return CharSequenceUtil.removePreAndLowerFirst(charSequence, 2);
        }
        return null;
    }

    public static String genSetter(CharSequence fieldName) {
        return CharSequenceUtil.upperFirstAndAddPre(fieldName, "set");
    }

    public static String genGetter(CharSequence fieldName) {
        return CharSequenceUtil.upperFirstAndAddPre(fieldName, "get");
    }

    /*
     * WARNING - void declaration
     */
    public static String concat(boolean isNullToEmpty, CharSequence ... strs) {
        void var2_2;
        void var1_1;
        StrBuilder sb = new StrBuilder();
        for (void str : var1_1) {
            sb.append((CharSequence)(isNullToEmpty ? CharSequenceUtil.nullToEmpty((CharSequence)str) : str));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String brief(CharSequence str, int maxLength) {
        void var3_3;
        void var2_2;
        CharSequence charSequence;
        void var1_1;
        if (str == null) {
            return null;
        }
        int strLength = str.length();
        if (maxLength <= 0 || strLength <= maxLength) {
            return str.toString();
        }
        switch (maxLength) {
            case 1: {
                return String.valueOf(str.charAt(0));
            }
            case 2: {
                return str.charAt(0) + ".";
            }
            case 3: {
                return str.charAt(0) + "." + str.charAt(strLength - 1);
            }
            case 4: {
                return str.charAt(0) + ".." + str.charAt(strLength - 1);
            }
        }
        int suffixLength = (maxLength - 3) / 2;
        int preLength = suffixLength + (maxLength - 3) % 2;
        CharSequence str2 = str.toString();
        return CharSequenceUtil.format("{}...{}", ((String)str2).substring(0, (int)var1_1), ((String)charSequence).substring((int)(var2_2 - var3_3)));
    }

    public static String join(CharSequence conjunction, Object ... objs) {
        CharSequence charSequence;
        return ArrayUtil.join(objs, charSequence);
    }

    public static <T> String join(CharSequence conjunction, Iterable<T> iterable) {
        CharSequence charSequence;
        return CollUtil.join(iterable, charSequence);
    }

    public static boolean isAllCharMatch(CharSequence value, Matcher<Character> matcher) {
        if (CharSequenceUtil.isBlank(value)) {
            return false;
        }
        int i = value.length();
        while (--i >= 0) {
            if (matcher.match(Character.valueOf(value.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(CharSequence str) {
        return CharSequenceUtil.isAllCharMatch(str, Character::isDigit);
    }

    /*
     * WARNING - void declaration
     */
    public static String move(CharSequence str, int startInclude, int endExclude, int moveLength) {
        int endAfterMove;
        if (CharSequenceUtil.isEmpty(str)) {
            return CharSequenceUtil.str(str);
        }
        int len = str.length();
        if (Math.abs(moveLength) > len) {
            moveLength %= len;
        }
        StringBuilder strBuilder = new StringBuilder(len);
        if (moveLength > 0) {
            endAfterMove = Math.min(endExclude + moveLength, str.length());
            strBuilder.append(str.subSequence(0, startInclude)).append(str.subSequence(endExclude, endAfterMove)).append(str.subSequence(startInclude, endExclude)).append(str.subSequence(endAfterMove, str.length()));
        } else if (endAfterMove < 0) {
            void var2_2;
            void var1_1;
            void var3_3;
            int startAfterMove = Math.max(startInclude + endAfterMove, 0);
            strBuilder.append(str.subSequence(0, startAfterMove)).append(str.subSequence(startInclude, endExclude)).append(str.subSequence((int)var3_3, (int)var1_1)).append(str.subSequence((int)var2_2, str.length()));
        } else {
            CharSequence charSequence;
            return CharSequenceUtil.str(charSequence);
        }
        return strBuilder.toString();
    }

    public static boolean isCharEquals(CharSequence str) {
        CharSequence charSequence;
        Assert.notEmpty(str, "Str to check must be not empty!", new Object[0]);
        CharSequence charSequence2 = str;
        return CharSequenceUtil.count(charSequence2, charSequence2.charAt(0)) == charSequence.length();
    }

    public static String normalize(CharSequence str) {
        return Normalizer.normalize(str, Normalizer.Form.NFC);
    }

    /*
     * WARNING - void declaration
     */
    public static String fixLength(CharSequence str, char fixedChar, int length) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        int fixedLength = length - str.length();
        if (fixedLength <= 0) {
            return str.toString();
        }
        return charSequence + CharSequenceUtil.repeat((char)var1_1, (int)var2_2);
    }

    public static boolean hasLetter(CharSequence str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!CharUtil.isLetter(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static CharSequence commonPrefix(CharSequence str1, CharSequence str2) {
        void var3_3;
        CharSequence charSequence;
        if (CharSequenceUtil.isEmpty(str1) || CharSequenceUtil.isEmpty(str2)) {
            return EMPTY;
        }
        int minLength = Math.min(str1.length(), str2.length());
        for (int index = 0; index < minLength && str1.charAt(index) == str2.charAt(index); ++index) {
        }
        return charSequence.subSequence(0, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static CharSequence commonSuffix(CharSequence str1, CharSequence str2) {
        CharSequence charSequence;
        void var2_2;
        if (CharSequenceUtil.isEmpty(str1) || CharSequenceUtil.isEmpty(str2)) {
            return EMPTY;
        }
        int str1Index = str1.length() - 1;
        for (int str2Index = str2.length() - 1; str1Index >= 0 && str2Index >= 0 && str1.charAt(str1Index) == str2.charAt(str2Index); --str1Index, --str2Index) {
        }
        return str1.subSequence((int)(var2_2 + true), charSequence.length());
    }
}

