/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.map.SafeConcurrentHashMap;
import cn.hutool.core.text.StrSplitter;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AntPathMatcher {
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private static final int CACHE_TURNOFF_THRESHOLD = 65536;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{[^/]+?}");
    private static final char[] WILDCARD_CHARS = new char[]{'*', '?', '{'};
    private String pathSeparator;
    private PathSeparatorPatternCache pathSeparatorPatternCache;
    private boolean caseSensitive = true;
    private boolean trimTokens = false;
    private volatile Boolean cachePatterns;
    private final Map<String, String[]> tokenizedPatternCache = new SafeConcurrentHashMap<String, String[]>(256);
    private final Map<String, AntPathStringMatcher> stringMatcherCache = new SafeConcurrentHashMap<String, AntPathStringMatcher>(256);

    public AntPathMatcher() {
        this(DEFAULT_PATH_SEPARATOR);
    }

    /*
     * WARNING - void declaration
     */
    public AntPathMatcher(String pathSeparator) {
        void var1_1;
        if (pathSeparator == null) {
            pathSeparator = DEFAULT_PATH_SEPARATOR;
        }
        this.setPathSeparator((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AntPathMatcher setPathSeparator(String pathSeparator) {
        void var1_1;
        if (pathSeparator == null) {
            pathSeparator = DEFAULT_PATH_SEPARATOR;
        }
        this.pathSeparator = var1_1;
        this.pathSeparatorPatternCache = new PathSeparatorPatternCache(this.pathSeparator);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AntPathMatcher setCaseSensitive(boolean caseSensitive) {
        void var1_1;
        this.caseSensitive = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AntPathMatcher setTrimTokens(boolean trimTokens) {
        void var1_1;
        this.trimTokens = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public AntPathMatcher setCachePatterns(boolean cachePatterns) {
        void var1_1;
        this.cachePatterns = (boolean)var1_1;
        return this;
    }

    public boolean isPattern(String path) {
        if (path == null) {
            return false;
        }
        boolean uriVar = false;
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            char c = path.charAt(i);
            if (c == '*' || c == '?') {
                return true;
            }
            if (c == '{') {
                uriVar = true;
                continue;
            }
            if (c != '}' || !uriVar) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean match(String pattern, String path) {
        void var2_2;
        void var1_1;
        return this.doMatch((String)var1_1, (String)var2_2, true, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean matchStart(String pattern, String path) {
        void var2_2;
        void var1_1;
        return this.doMatch((String)var1_1, (String)var2_2, false, null);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean doMatch(String pattern, String path, boolean fullMatch, Map<String, String> uriTemplateVariables) {
        String pattDir;
        int pathIdxStart;
        if (path == null || path.startsWith(this.pathSeparator) != pattern.startsWith(this.pathSeparator)) {
            return false;
        }
        String[] pattDirs = this.tokenizePattern(pattern);
        if (fullMatch && this.caseSensitive && !this.isPotentialMatch(path, pattDirs)) {
            return false;
        }
        String[] pathDirs = this.tokenizePath(path);
        int pattIdxStart = 0;
        int pattIdxEnd = pattDirs.length - 1;
        int pathIdxEnd = pathDirs.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(pattDir = pattDirs[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (!this.notMatchStrings(pattDir, pathDirs[pathIdxStart], uriTemplateVariables)) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern.endsWith(this.pathSeparator) == path.endsWith(this.pathSeparator);
            }
            if (!fullMatch) {
                return true;
            }
            if (pattIdxStart == pattIdxEnd && pattDirs[pattIdxStart].equals("*") && path.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (!fullMatch && "**".equals(pattDirs[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(pattDir = pattDirs[pattIdxEnd]).equals("**")) {
            if (this.notMatchStrings(pattDir, pathDirs[pathIdxEnd], uriTemplateVariables)) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            void var1_2;
            void var3_5;
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!pattDirs[i].equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = pattDirs[pattIdxStart + j + 1];
                    String subStr = pathDirs[pathIdxStart + i + j];
                    if (this.notMatchStrings(subPat, subStr, uriTemplateVariables)) continue block6;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = var3_5 + var1_2;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (pattDirs[i].equals("**")) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isPotentialMatch(String path, String[] pattDirs) {
        if (!this.trimTokens) {
            void var2_2;
            int pos = 0;
            for (void pattDir : var2_2) {
                int skipped = this.skipSeparator(path, pos, this.pathSeparator);
                if ((skipped = this.skipSegment(path, pos += skipped, (String)pattDir)) < pattDir.length()) {
                    return skipped > 0 || pattDir.length() > 0 && this.isWildcardChar(pattDir.charAt(0));
                }
                pos += skipped;
            }
        }
        return true;
    }

    private int skipSegment(String path, int pos, String prefix) {
        int skipped = 0;
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (this.isWildcardChar(c)) {
                return skipped;
            }
            int currPos = pos + skipped;
            if (currPos >= path.length()) {
                return 0;
            }
            if (c != path.charAt(currPos)) continue;
            ++skipped;
        }
        return skipped;
    }

    private int skipSeparator(String path, int pos, String separator) {
        int skipped = 0;
        while (path.startsWith(separator, pos + skipped)) {
            skipped += separator.length();
        }
        return skipped;
    }

    private boolean isWildcardChar(char c) {
        char[] cArray = WILDCARD_CHARS;
        int n = WILDCARD_CHARS.length;
        for (int i = 0; i < n; ++i) {
            char candidate = cArray[i];
            if (c != candidate) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected String[] tokenizePattern(String pattern) {
        void var2_2;
        String[] tokenized = null;
        Boolean cachePatterns = this.cachePatterns;
        if (cachePatterns == null || cachePatterns.booleanValue()) {
            tokenized = this.tokenizedPatternCache.get(pattern);
        }
        if (tokenized == null) {
            void var3_3;
            tokenized = this.tokenizePath(pattern);
            if (cachePatterns == null && this.tokenizedPatternCache.size() >= 65536) {
                this.deactivatePatternCache();
                return tokenized;
            }
            if (cachePatterns == null || var3_3.booleanValue()) {
                void var1_1;
                this.tokenizedPatternCache.put((String)var1_1, tokenized);
            }
        }
        return var2_2;
    }

    private void deactivatePatternCache() {
        this.cachePatterns = Boolean.FALSE;
        this.tokenizedPatternCache.clear();
        this.stringMatcherCache.clear();
    }

    protected String[] tokenizePath(String path) {
        return StrSplitter.splitToArray((CharSequence)path, this.pathSeparator, 0, this.trimTokens, true);
    }

    /*
     * WARNING - void declaration
     */
    private boolean notMatchStrings(String pattern, String str, Map<String, String> uriTemplateVariables) {
        void var3_3;
        void var2_2;
        void var1_1;
        return false == this.getStringMatcher((String)var1_1).matchStrings((String)var2_2, (Map<String, String>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected AntPathStringMatcher getStringMatcher(String pattern) {
        void var2_2;
        AntPathStringMatcher matcher = null;
        Boolean cachePatterns = this.cachePatterns;
        if (cachePatterns == null || cachePatterns.booleanValue()) {
            matcher = this.stringMatcherCache.get(pattern);
        }
        if (matcher == null) {
            void var3_3;
            matcher = new AntPathStringMatcher(pattern, this.caseSensitive);
            if (cachePatterns == null && this.stringMatcherCache.size() >= 65536) {
                this.deactivatePatternCache();
                return matcher;
            }
            if (cachePatterns == null || var3_3.booleanValue()) {
                void var1_1;
                this.stringMatcherCache.put((String)var1_1, matcher);
            }
        }
        return var2_2;
    }

    public String extractPathWithinPattern(String pattern, String path) {
        String[] patternParts = this.tokenizePath(pattern);
        String[] pathParts = this.tokenizePath(path);
        StringBuilder builder = new StringBuilder();
        boolean pathStarted = false;
        for (int segment = 0; segment < patternParts.length; ++segment) {
            String patternPart = patternParts[segment];
            if (patternPart.indexOf(42) < 0 && patternPart.indexOf(63) < 0) continue;
            while (segment < pathParts.length) {
                if (pathStarted || segment == 0 && !pattern.startsWith(this.pathSeparator)) {
                    builder.append(this.pathSeparator);
                }
                builder.append(pathParts[segment]);
                pathStarted = true;
                ++segment;
            }
        }
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> extractUriTemplateVariables(String pattern, String path) {
        void var3_3;
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        boolean bl = this.doMatch(pattern, path, true, variables);
        if (!bl) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException("Pattern \"" + (String)var1_1 + "\" is not a match for \"" + (String)var2_2 + "\"");
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String combine(String pattern1, String pattern2) {
        void var1_1;
        void var3_4;
        boolean ext2All;
        boolean pattern1ContainsUriVar;
        if (StrUtil.isEmpty(pattern1) && StrUtil.isEmpty(pattern2)) {
            return "";
        }
        if (StrUtil.isEmpty(pattern1)) {
            return pattern2;
        }
        if (StrUtil.isEmpty(pattern2)) {
            return pattern1;
        }
        boolean bl = pattern1ContainsUriVar = pattern1.indexOf(123) != -1;
        if (!pattern1.equals(pattern2) && !pattern1ContainsUriVar && this.match(pattern1, pattern2)) {
            return pattern2;
        }
        if (pattern1.endsWith(this.pathSeparatorPatternCache.getEndsOnWildCard())) {
            return this.concat(pattern1.substring(0, pattern1.length() - 2), pattern2);
        }
        if (pattern1.endsWith(this.pathSeparatorPatternCache.getEndsOnDoubleWildCard())) {
            return this.concat(pattern1, pattern2);
        }
        int starDotPos1 = pattern1.indexOf("*.");
        if (pattern1ContainsUriVar || starDotPos1 == -1 || this.pathSeparator.equals(".")) {
            return this.concat(pattern1, pattern2);
        }
        String ext1 = pattern1.substring(starDotPos1 + 1);
        int dotPos2 = pattern2.indexOf(46);
        String file2 = dotPos2 == -1 ? pattern2 : pattern2.substring(0, dotPos2);
        String ext2 = dotPos2 == -1 ? "" : pattern2.substring(dotPos2);
        boolean ext1All = ext1.equals(".*") || ext1.isEmpty();
        boolean bl2 = ext2All = ext2.equals(".*") || ext2.isEmpty();
        if (!ext1All && !ext2All) {
            void var2_2;
            throw new IllegalArgumentException("Cannot combine patterns: " + pattern1 + " vs " + (String)var2_2);
        }
        String ext = ext1All ? ext2 : var3_4;
        return file2 + (String)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String concat(String path1, String path2) {
        void var2_2;
        void var1_1;
        void var3_3;
        boolean path1EndsWithSeparator = path1.endsWith(this.pathSeparator);
        boolean path2StartsWithSeparator = path2.startsWith(this.pathSeparator);
        if (path1EndsWithSeparator && path2StartsWithSeparator) {
            return path1 + path2.substring(1);
        }
        if (var3_3 != false || path2StartsWithSeparator) {
            return path1 + path2;
        }
        return (String)var1_1 + this.pathSeparator + (String)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Comparator<String> getPatternComparator(String path) {
        void var1_1;
        return new AntPatternComparator((String)var1_1);
    }

    private static class PathSeparatorPatternCache {
        private final String endsOnWildCard;
        private final String endsOnDoubleWildCard;

        /*
         * WARNING - void declaration
         */
        public PathSeparatorPatternCache(String pathSeparator) {
            void var1_1;
            this.endsOnWildCard = pathSeparator + "*";
            this.endsOnDoubleWildCard = (String)var1_1 + "**";
        }

        public String getEndsOnWildCard() {
            return this.endsOnWildCard;
        }

        public String getEndsOnDoubleWildCard() {
            return this.endsOnDoubleWildCard;
        }
    }

    protected static class AntPatternComparator
    implements Comparator<String> {
        private final String path;

        /*
         * WARNING - void declaration
         */
        public AntPatternComparator(String path) {
            void var1_1;
            this.path = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(String pattern1, String pattern2) {
            void var3_5;
            void var2_4;
            void var1_2;
            PatternInfo info1 = new PatternInfo(pattern1);
            PatternInfo info2 = new PatternInfo(pattern2);
            if (info1.isLeastSpecific() && info2.isLeastSpecific()) {
                return 0;
            }
            if (info1.isLeastSpecific()) {
                return 1;
            }
            if (info2.isLeastSpecific()) {
                return -1;
            }
            boolean pattern1EqualsPath = pattern1.equals(this.path);
            boolean pattern2EqualsPath = pattern2.equals(this.path);
            if (pattern1EqualsPath && pattern2EqualsPath) {
                return 0;
            }
            if (var1_2 != false) {
                return -1;
            }
            if (var2_4 != false) {
                return 1;
            }
            if (info1.isPrefixPattern() && info2.isPrefixPattern()) {
                return info2.getLength() - info1.getLength();
            }
            if (info1.isPrefixPattern() && info2.getDoubleWildcards() == 0) {
                return 1;
            }
            if (info2.isPrefixPattern() && info1.getDoubleWildcards() == 0) {
                return -1;
            }
            if (info1.getTotalCount() != info2.getTotalCount()) {
                return info1.getTotalCount() - info2.getTotalCount();
            }
            if (info1.getLength() != info2.getLength()) {
                return info2.getLength() - info1.getLength();
            }
            if (info1.getSingleWildcards() < info2.getSingleWildcards()) {
                return -1;
            }
            if (info2.getSingleWildcards() < info1.getSingleWildcards()) {
                return 1;
            }
            if (info1.getUriVars() < info2.getUriVars()) {
                return -1;
            }
            if (info2.getUriVars() < var3_5.getUriVars()) {
                return 1;
            }
            return 0;
        }

        private static class PatternInfo {
            private final String pattern;
            private int uriVars;
            private int singleWildcards;
            private int doubleWildcards;
            private boolean catchAllPattern;
            private boolean prefixPattern;
            private Integer length;

            /*
             * WARNING - void declaration
             */
            public PatternInfo(String pattern) {
                void var1_1;
                this.pattern = var1_1;
                if (this.pattern != null) {
                    this.initCounters();
                    this.catchAllPattern = this.pattern.equals("/**");
                    boolean bl = this.prefixPattern = !this.catchAllPattern && this.pattern.endsWith("/**");
                }
                if (this.uriVars == 0) {
                    this.length = this.pattern != null ? this.pattern.length() : 0;
                }
            }

            protected void initCounters() {
                int pos = 0;
                if (this.pattern != null) {
                    while (pos < this.pattern.length()) {
                        if (this.pattern.charAt(pos) == '{') {
                            ++this.uriVars;
                            ++pos;
                            continue;
                        }
                        if (this.pattern.charAt(pos) == '*') {
                            if (pos + 1 < this.pattern.length() && this.pattern.charAt(pos + 1) == '*') {
                                ++this.doubleWildcards;
                                pos += 2;
                                continue;
                            }
                            if (pos > 0 && !this.pattern.substring(pos - 1).equals(".*")) {
                                ++this.singleWildcards;
                                ++pos;
                                continue;
                            }
                            ++pos;
                            continue;
                        }
                        ++pos;
                    }
                }
            }

            public int getUriVars() {
                return this.uriVars;
            }

            public int getSingleWildcards() {
                return this.singleWildcards;
            }

            public int getDoubleWildcards() {
                return this.doubleWildcards;
            }

            public boolean isLeastSpecific() {
                return this.pattern == null || this.catchAllPattern;
            }

            public boolean isPrefixPattern() {
                return this.prefixPattern;
            }

            public int getTotalCount() {
                return this.uriVars + this.singleWildcards + 2 * this.doubleWildcards;
            }

            public int getLength() {
                if (this.length == null) {
                    this.length = this.pattern != null ? VARIABLE_PATTERN.matcher(this.pattern).replaceAll("#").length() : 0;
                }
                return this.length;
            }
        }
    }

    protected static class AntPathStringMatcher {
        private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{((?:\\{[^/]+?}|[^/{}]|\\\\[{}])+?)}");
        private static final String DEFAULT_VARIABLE_PATTERN = "((?s).*)";
        private final String rawPattern;
        private final boolean caseSensitive;
        private final boolean exactMatch;
        private final Pattern pattern;
        private final List<String> variableNames = new ArrayList<String>();

        /*
         * WARNING - void declaration
         */
        public AntPathStringMatcher(String pattern, boolean caseSensitive) {
            Pattern pattern2;
            AntPathStringMatcher antPathStringMatcher;
            int n;
            this.rawPattern = pattern;
            this.caseSensitive = caseSensitive;
            StringBuilder patternBuilder = new StringBuilder();
            Matcher matcher = GLOB_PATTERN.matcher(pattern);
            int end = 0;
            while (matcher.find()) {
                patternBuilder.append(this.quote(pattern, end, matcher.start()));
                String match = matcher.group();
                if ("?".equals(match)) {
                    patternBuilder.append('.');
                } else if ("*".equals(match)) {
                    patternBuilder.append(".*");
                } else if (match.startsWith("{") && match.endsWith("}")) {
                    int colonIdx = match.indexOf(58);
                    if (colonIdx == -1) {
                        patternBuilder.append(DEFAULT_VARIABLE_PATTERN);
                        this.variableNames.add(matcher.group(1));
                    } else {
                        String variablePattern = match.substring(colonIdx + 1, match.length() - 1);
                        patternBuilder.append('(');
                        patternBuilder.append(variablePattern);
                        patternBuilder.append(')');
                        String variableName = match.substring(1, colonIdx);
                        this.variableNames.add(variableName);
                    }
                }
                n = matcher.end();
            }
            if (n == 0) {
                this.exactMatch = true;
                antPathStringMatcher = this;
                pattern2 = null;
            } else {
                void var2_3;
                void var1_1;
                this.exactMatch = false;
                patternBuilder.append(this.quote(pattern, n, var1_1.length()));
                AntPathStringMatcher antPathStringMatcher2 = this;
                antPathStringMatcher = antPathStringMatcher2;
                pattern2 = antPathStringMatcher2.caseSensitive ? Pattern.compile(patternBuilder.toString()) : Pattern.compile(var2_3.toString(), 2);
            }
            antPathStringMatcher.pattern = pattern2;
        }

        /*
         * WARNING - void declaration
         */
        private String quote(String s, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (start == end) {
                return "";
            }
            return Pattern.quote(var1_1.substring((int)var2_2, (int)var3_3));
        }

        public boolean matchStrings(String str, Map<String, String> uriTemplateVariables) {
            Matcher matcher;
            if (this.exactMatch) {
                if (this.caseSensitive) {
                    return this.rawPattern.equals(str);
                }
                return this.rawPattern.equalsIgnoreCase(str);
            }
            if (this.pattern != null && (matcher = this.pattern.matcher(str)).matches()) {
                if (uriTemplateVariables != null) {
                    if (this.variableNames.size() != matcher.groupCount()) {
                        throw new IllegalArgumentException("The number of capturing groups in the pattern segment " + this.pattern + " does not match the number of URI template variables it defines, which can occur if capturing groups are used in a URI template regex. Use non-capturing groups instead.");
                    }
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        String name = this.variableNames.get(i - 1);
                        if (name.startsWith("*")) {
                            throw new IllegalArgumentException("Capturing patterns (" + name + ") are not supported by the AntPathMatcher. Use the PathPatternParser instead.");
                        }
                        String value = matcher.group(i);
                        uriTemplateVariables.put(name, value);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

