/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.swing.clipboard;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.swing.clipboard.ClipboardListener;
import cn.hutool.core.swing.clipboard.ClipboardMonitor;
import cn.hutool.core.swing.clipboard.ImageSelection;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ClipboardUtil {
    public static Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static void set(Transferable contents) {
        ClipboardUtil.set(contents, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void set(Transferable contents, ClipboardOwner owner) {
        void var1_1;
        Transferable transferable;
        ClipboardUtil.getClipboard().setContents(transferable, (ClipboardOwner)var1_1);
    }

    public static Object get(DataFlavor flavor) {
        DataFlavor dataFlavor;
        return ClipboardUtil.get(ClipboardUtil.getClipboard().getContents(null), dataFlavor);
    }

    /*
     * WARNING - void declaration
     */
    public static Object get(Transferable content, DataFlavor flavor) {
        if (content != null && content.isDataFlavorSupported(flavor)) {
            try {
                void var1_2;
                return content.getTransferData((DataFlavor)var1_2);
            }
            catch (UnsupportedFlavorException | IOException e) {
                void var0_1;
                throw new UtilException((Throwable)var0_1);
            }
        }
        return null;
    }

    public static void setStr(String text) {
        String string;
        ClipboardUtil.set(new StringSelection(string));
    }

    public static String getStr() {
        return (String)ClipboardUtil.get(DataFlavor.stringFlavor);
    }

    public static String getStr(Transferable content) {
        return (String)ClipboardUtil.get(content, DataFlavor.stringFlavor);
    }

    public static void setImage(Image image) {
        Image image2;
        ClipboardUtil.set(new ImageSelection(image2), null);
    }

    public static Image getImage() {
        return (Image)ClipboardUtil.get(DataFlavor.imageFlavor);
    }

    public static Image getImage(Transferable content) {
        return (Image)ClipboardUtil.get(content, DataFlavor.imageFlavor);
    }

    public static void listen(ClipboardListener listener) {
        ClipboardUtil.listen(listener, true);
    }

    /*
     * WARNING - void declaration
     */
    public static void listen(ClipboardListener listener, boolean sync) {
        void var1_1;
        ClipboardListener clipboardListener;
        ClipboardUtil.listen(10, 100L, clipboardListener, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void listen(int tryCount, long delay, ClipboardListener listener, boolean sync) {
        void var3_2;
        void var1_1;
        int n;
        ClipboardMonitor.INSTANCE.setTryCount(n).setDelay((long)var1_1).addListener((ClipboardListener)var3_2).listen(sync);
    }
}

