/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.swing.clipboard;

import cn.hutool.core.swing.clipboard.ClipboardListener;
import cn.hutool.core.swing.clipboard.ClipboardUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ObjectUtil;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Set;

public enum ClipboardMonitor implements ClipboardOwner,
Closeable,
Runnable
{
    INSTANCE;

    public static final int DEFAULT_TRY_COUNT = 10;
    public static final long DEFAULT_DELAY = 100L;
    private int tryCount;
    private long delay;
    private final Clipboard clipboard;
    private final Set<ClipboardListener> listenerSet = new LinkedHashSet<ClipboardListener>();
    private boolean isRunning;

    private ClipboardMonitor() {
        this(10, 100L);
    }

    /*
     * WARNING - void declaration
     */
    private ClipboardMonitor(int tryCount, long delay) {
        this((int)var3_3, delay, ClipboardUtil.getClipboard());
        void var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private ClipboardMonitor(int tryCount, long delay, Clipboard clipboard) {
        void var3_3;
        this.tryCount = var3_3;
        this.delay = delay;
        this.clipboard = clipboard;
    }

    /*
     * WARNING - void declaration
     */
    public final ClipboardMonitor setTryCount(int tryCount) {
        void var1_1;
        this.tryCount = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ClipboardMonitor setDelay(long delay) {
        void var1_1;
        this.delay = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ClipboardMonitor addListener(ClipboardListener listener) {
        void var1_1;
        this.listenerSet.add((ClipboardListener)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ClipboardMonitor removeListener(ClipboardListener listener) {
        void var1_1;
        this.listenerSet.remove(var1_1);
        return this;
    }

    public final ClipboardMonitor clearListener() {
        this.listenerSet.clear();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void lostOwnership(Clipboard clipboard, Transferable contents) {
        Transferable newContents;
        try {
            newContents = this.tryGetContent(clipboard);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        Transferable transferable = null;
        for (ClipboardListener listener : this.listenerSet) {
            try {
                transferable = listener.onChange(clipboard, ObjectUtil.defaultIfNull(transferable, newContents));
            }
            catch (Throwable throwable) {}
        }
        if (this.isRunning) {
            void var2_2;
            void var3_3;
            void var1_1;
            var1_1.setContents((Transferable)ObjectUtil.defaultIfNull(transferable, ObjectUtil.defaultIfNull(var3_3, var2_2)), this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void run() {
        if (!this.isRunning) {
            void var1_1;
            Clipboard clipboard = this.clipboard;
            clipboard.setContents(var1_1.getContents(null), this);
            this.isRunning = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void listen(boolean sync) {
        void var1_1;
        this.run();
        if (var1_1 != false) {
            ThreadUtil.sync(this);
        }
    }

    @Override
    public final void close() {
        this.isRunning = false;
    }

    private Transferable tryGetContent(Clipboard clipboard) throws InterruptedException {
        Transferable newContents = null;
        for (int i = 0; i < this.tryCount; ++i) {
            if (this.delay > 0L && i > 0) {
                Thread.sleep(this.delay);
            }
            try {
                newContents = clipboard.getContents(null);
            }
            catch (IllegalStateException illegalStateException) {}
            if (newContents == null) continue;
            return newContents;
        }
        return null;
    }
}

