/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.stream;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.stream.CollectorUtil;
import cn.hutool.core.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtil {
    @SafeVarargs
    public static <T> Stream<T> of(T ... array) {
        T[] TArray;
        Assert.notNull(array, "Array must be not null!", new Object[0]);
        return Stream.of(TArray);
    }

    public static <T> Stream<T> of(Iterable<T> iterable) {
        return StreamUtil.of(iterable, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Stream<T> of(Iterable<T> iterable, boolean parallel) {
        void var1_1;
        Iterable<T> iterable2;
        Assert.notNull(iterable, "Iterable must be not null!", new Object[0]);
        if (iterable instanceof Collection) {
            if (parallel) {
                return ((Collection)iterable).parallelStream();
            }
            return ((Collection)iterable).stream();
        }
        return StreamSupport.stream(iterable2.spliterator(), (boolean)var1_1);
    }

    public static <T> Stream<T> of(Iterator<T> iterator) {
        return StreamUtil.of(iterator, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Stream<T> of(Iterator<T> iterator, boolean parallel) {
        void var1_1;
        Iterator<T> iterator2;
        Assert.notNull(iterator, "iterator must not be null!", new Object[0]);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator2, 0), (boolean)var1_1);
    }

    public static Stream<String> of(File file) {
        return StreamUtil.of(file, CharsetUtil.CHARSET_UTF_8);
    }

    public static Stream<String> of(Path path) {
        return StreamUtil.of(path, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static Stream<String> of(File file, Charset charset) {
        void var1_1;
        File file2;
        Assert.notNull(file, "File must be not null!", new Object[0]);
        return StreamUtil.of(file2.toPath(), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Stream<String> of(Path path, Charset charset) {
        try {
            void var1_2;
            return Files.lines(path, (Charset)var1_2);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Stream<T> of(T seed, UnaryOperator<T> elementCreator, int limit) {
        void var2_2;
        void var1_1;
        return Stream.iterate(seed, var1_1).limit((long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String join(Stream<T> stream, CharSequence delimiter) {
        void var1_1;
        return stream.collect(CollectorUtil.joining((CharSequence)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> String join(Stream<T> stream, CharSequence delimiter, Function<T, ? extends CharSequence> toStringFunc) {
        void var2_2;
        void var1_1;
        return stream.collect(CollectorUtil.joining((CharSequence)var1_1, var2_2));
    }
}

