/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net.url;

import cn.hutool.core.codec.PercentCodec;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.TableMap;
import cn.hutool.core.net.FormUrlencoded;
import cn.hutool.core.net.RFC3986;
import cn.hutool.core.net.URLDecoder;
import cn.hutool.core.util.StrUtil;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;

public class UrlQuery {
    private final TableMap<CharSequence, CharSequence> query;
    private final boolean isFormUrlEncoded;
    private boolean isStrict;

    public static UrlQuery of(Map<? extends CharSequence, ?> queryMap) {
        Map<? extends CharSequence, ?> map;
        return new UrlQuery(map);
    }

    /*
     * WARNING - void declaration
     */
    public static UrlQuery of(Map<? extends CharSequence, ?> queryMap, boolean isFormUrlEncoded) {
        void var1_1;
        Map<? extends CharSequence, ?> map;
        return new UrlQuery(map, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static UrlQuery of(String queryStr, Charset charset) {
        void var1_1;
        return UrlQuery.of(queryStr, (Charset)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static UrlQuery of(String queryStr, Charset charset, boolean autoRemovePath) {
        void var2_2;
        void var1_1;
        return UrlQuery.of(queryStr, (Charset)var1_1, (boolean)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static UrlQuery of(String queryStr, Charset charset, boolean autoRemovePath, boolean isFormUrlEncoded) {
        void var2_2;
        void var1_1;
        String string;
        void var3_3;
        return new UrlQuery((boolean)var3_3).parse(string, (Charset)var1_1, (boolean)var2_2);
    }

    public UrlQuery() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    public UrlQuery(boolean isFormUrlEncoded) {
        this(null, (boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public UrlQuery(Map<? extends CharSequence, ?> queryMap) {
        this((Map<? extends CharSequence, ?>)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public UrlQuery(Map<? extends CharSequence, ?> queryMap, boolean isFormUrlEncoded) {
        void var2_2;
        if (MapUtil.isNotEmpty(queryMap)) {
            void var1_1;
            this.query = new TableMap(queryMap.size());
            this.addAll((Map<? extends CharSequence, ?>)var1_1);
        } else {
            this.query = new TableMap(16);
        }
        this.isFormUrlEncoded = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public UrlQuery setStrict(boolean strict) {
        void var1_1;
        this.isStrict = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public UrlQuery add(CharSequence key, Object value) {
        void var2_2;
        void var1_1;
        this.query.put((CharSequence)var1_1, UrlQuery.toStr(var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public UrlQuery addAll(Map<? extends CharSequence, ?> queryMap) {
        if (MapUtil.isNotEmpty(queryMap)) {
            void var1_1;
            var1_1.forEach(this::add);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public UrlQuery parse(String queryStr, Charset charset) {
        void var2_2;
        void var1_1;
        return this.parse((String)var1_1, (Charset)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public UrlQuery parse(String queryStr, Charset charset, boolean autoRemovePath) {
        void var2_2;
        void var1_1;
        void var3_3;
        int pathEndPos;
        if (StrUtil.isBlank(queryStr)) {
            return this;
        }
        if (autoRemovePath && (pathEndPos = queryStr.indexOf(63)) >= 0 && StrUtil.isBlank(queryStr = StrUtil.subSuf(queryStr, (int)(var3_3 + true)))) {
            return this;
        }
        return this.doParse((String)var1_1, (Charset)var2_2);
    }

    public Map<CharSequence, CharSequence> getQueryMap() {
        return MapUtil.unmodifiable(this.query);
    }

    /*
     * WARNING - void declaration
     */
    public CharSequence get(CharSequence key) {
        void var1_1;
        if (MapUtil.isEmpty(this.query)) {
            return null;
        }
        return this.query.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String build(Charset charset) {
        void var1_1;
        return this.build((Charset)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public String build(Charset charset, boolean encodePercent) {
        void var2_2;
        void var1_1;
        if (this.isFormUrlEncoded) {
            PercentCodec percentCodec = FormUrlencoded.ALL;
            return this.build(percentCodec, percentCodec, charset, encodePercent);
        }
        if (this.isStrict) {
            return this.build(RFC3986.QUERY_PARAM_NAME_STRICT, RFC3986.QUERY_PARAM_VALUE_STRICT, charset, encodePercent);
        }
        return this.build(RFC3986.QUERY_PARAM_NAME, RFC3986.QUERY_PARAM_VALUE, (Charset)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String build(PercentCodec keyCoder, PercentCodec valueCoder, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.build((PercentCodec)var1_1, (PercentCodec)var2_2, (Charset)var3_3, true);
    }

    public String build(PercentCodec keyCoder, PercentCodec valueCoder, Charset charset, boolean encodePercent) {
        char[] cArray;
        if (MapUtil.isEmpty(this.query)) {
            return "";
        }
        if (encodePercent) {
            cArray = null;
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = 37;
        }
        char[] safeChars = cArray;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<CharSequence, CharSequence> entry : this.query) {
            CharSequence name = entry.getKey();
            if (name == null) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(keyCoder.encode(name, charset, safeChars));
            CharSequence value = entry.getValue();
            if (value == null) continue;
            sb.append("=").append(valueCoder.encode(value, charset, safeChars));
        }
        return sb.toString();
    }

    public String toString() {
        return this.build(null);
    }

    /*
     * Unable to fully structure code
     */
    private UrlQuery doParse(String queryStr, Charset charset) {
        len = queryStr.length();
        name = null;
        pos = 0;
        block4: for (i = 0; i < len; ++i) {
            var7_7 = queryStr.charAt(i);
            switch (var7_7) {
                case '=': {
                    if (name != null) continue block4;
                    name = queryStr.substring(pos, i);
                    ** GOTO lbl16
                }
                case '&': {
                    this.addParam(name, queryStr.substring(pos, i), charset);
                    name = null;
                    if (i + 4 < len && "amp;".equals(queryStr.substring(i + 1, i + 5))) {
                        i += 4;
                    }
lbl16:
                    // 4 sources

                    pos = i + 1;
                }
            }
        }
        this.addParam(name, var1_1.substring(pos, i), (Charset)var2_2);
        return this;
    }

    private static String toStr(Object value) {
        Object object;
        Object result;
        result = value instanceof Iterable ? CollUtil.join((Iterable)value, (CharSequence)",") : (result instanceof Iterator ? IterUtil.join((Iterator)result, ",") : Convert.toStr(result));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private void addParam(String key, String value, Charset charset) {
        if (key != null) {
            void var1_1;
            String actualKey = URLDecoder.decode(key, charset, this.isFormUrlEncoded);
            this.query.put((CharSequence)var1_1, StrUtil.nullToEmpty(URLDecoder.decode(value, charset, this.isFormUrlEncoded)));
            return;
        }
        if (value != null) {
            void var3_3;
            void var2_2;
            this.query.put(URLDecoder.decode((String)var2_2, (Charset)var3_3, this.isFormUrlEncoded), null);
        }
    }
}

