/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net.url;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.RFC3986;
import cn.hutool.core.net.URLDecoder;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;

public class UrlPath {
    private List<String> segments;
    private boolean withEngTag;

    /*
     * WARNING - void declaration
     */
    public static UrlPath of(CharSequence pathStr, Charset charset) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        UrlPath urlPath = new UrlPath();
        urlPath.parse(charSequence, (Charset)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public UrlPath setWithEndTag(boolean withEngTag) {
        void var1_1;
        this.withEngTag = var1_1;
        return this;
    }

    public List<String> getSegments() {
        return ObjectUtil.defaultIfNull(this.segments, ListUtil.empty());
    }

    /*
     * WARNING - void declaration
     */
    public String getSegment(int index) {
        void var1_1;
        if (this.segments == null || index >= this.segments.size()) {
            return null;
        }
        return this.segments.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public UrlPath add(CharSequence segment) {
        void var1_1;
        this.addInternal(UrlPath.fixPath((CharSequence)var1_1), false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public UrlPath addBefore(CharSequence segment) {
        void var1_1;
        this.addInternal(UrlPath.fixPath((CharSequence)var1_1), true);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public UrlPath parse(CharSequence path, Charset charset) {
        if (StrUtil.isNotEmpty(path)) {
            if (StrUtil.endWith(path, '/')) {
                this.withEngTag = true;
            }
            if (StrUtil.isNotEmpty(path = UrlPath.fixPath(path))) {
                Object object;
                object = StrUtil.split((CharSequence)object, '/');
                object = object.iterator();
                while (object.hasNext()) {
                    void var3_3;
                    String seg = (String)object.next();
                    this.addInternal(URLDecoder.decodeForPath((String)var3_3, charset), false);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public String build(Charset charset) {
        void var1_1;
        return this.build((Charset)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public String build(Charset charset, boolean encodePercent) {
        void var3_4;
        char[] cArray;
        if (CollUtil.isEmpty(this.segments)) {
            if (this.withEngTag) {
                return "/";
            }
            return "";
        }
        if (encodePercent) {
            cArray = null;
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = 37;
        }
        char[] safeChars = cArray;
        StringBuilder builder = new StringBuilder();
        for (String segment : this.segments) {
            if (builder.length() == 0) {
                builder.append('/').append(RFC3986.SEGMENT_NZ_NC.encode(segment, charset, safeChars));
                continue;
            }
            builder.append('/').append(RFC3986.SEGMENT.encode(segment, charset, safeChars));
        }
        if (this.withEngTag) {
            if (StrUtil.isEmpty(builder)) {
                builder.append('/');
            } else if (!StrUtil.endWith((CharSequence)builder, '/')) {
                builder.append('/');
            }
        }
        return var3_4.toString();
    }

    public String toString() {
        return this.build(null);
    }

    /*
     * WARNING - void declaration
     */
    private void addInternal(CharSequence segment, boolean before) {
        void var1_1;
        void var2_2;
        if (this.segments == null) {
            this.segments = new LinkedList<String>();
        }
        String seg = StrUtil.str(segment);
        if (var2_2 != false) {
            this.segments.add(0, seg);
            return;
        }
        this.segments.add((String)var1_1);
    }

    private static String fixPath(CharSequence path) {
        CharSequence charSequence;
        Assert.notNull(path, "Path segment must be not null!", new Object[0]);
        if ("/".contentEquals(path)) {
            return "";
        }
        charSequence = StrUtil.trim(charSequence);
        charSequence = StrUtil.removePrefix(charSequence, "/");
        charSequence = StrUtil.removeSuffix(charSequence, "/");
        charSequence = StrUtil.trim(charSequence);
        return charSequence;
    }
}

