/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net.url;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.RFC3986;
import cn.hutool.core.net.url.UrlPath;
import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;

public final class UrlBuilder
implements Builder<String> {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_SCHEME = "http";
    private String scheme;
    private String host;
    private int port = -1;
    private UrlPath path;
    private UrlQuery query;
    private String fragment;
    private Charset charset;
    private boolean needEncodePercent;

    /*
     * WARNING - void declaration
     */
    public static UrlBuilder of(URI uri, Charset charset) {
        void var1_1;
        URI uRI;
        return UrlBuilder.of(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getRawQuery(), uRI.getFragment(), (Charset)var1_1);
    }

    public static UrlBuilder ofHttpWithoutEncode(String httpUrl) {
        return UrlBuilder.ofHttp(httpUrl, null);
    }

    public static UrlBuilder ofHttp(String httpUrl) {
        return UrlBuilder.ofHttp(httpUrl, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static UrlBuilder ofHttp(String httpUrl, Charset charset) {
        void var1_1;
        String string;
        Assert.notBlank(httpUrl, "Http url must be not blank!", new Object[0]);
        httpUrl = StrUtil.trimStart(httpUrl);
        if (!StrUtil.startWithAnyIgnoreCase(httpUrl, "http://", "https://")) {
            httpUrl = "http://" + httpUrl;
        }
        return UrlBuilder.of(string, (Charset)var1_1);
    }

    public static UrlBuilder of(String url) {
        return UrlBuilder.of(url, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static UrlBuilder of(String url, Charset charset) {
        void var1_1;
        String string;
        Assert.notBlank(url, "Url must be not blank!", new Object[0]);
        return UrlBuilder.of(URLUtil.url(StrUtil.trim(string)), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static UrlBuilder of(URL url, Charset charset) {
        void var1_1;
        URL uRL;
        return UrlBuilder.of(url.getProtocol(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), uRL.getRef(), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static UrlBuilder of(String scheme, String host, int port, String path, String query, String fragment, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        return UrlBuilder.of(scheme, (String)var1_1, (int)var2_2, UrlPath.of((CharSequence)var3_3, charset), UrlQuery.of(query, charset, false), fragment, charset);
    }

    /*
     * WARNING - void declaration
     */
    public static UrlBuilder of(String scheme, String host, int port, UrlPath path, UrlQuery query, String fragment, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return new UrlBuilder(string, (String)var1_1, (int)var2_2, (UrlPath)var3_3, query, fragment, charset);
    }

    @Deprecated
    public static UrlBuilder create() {
        return new UrlBuilder();
    }

    public static UrlBuilder of() {
        return new UrlBuilder();
    }

    public UrlBuilder() {
        this.charset = CharsetUtil.CHARSET_UTF_8;
    }

    /*
     * WARNING - void declaration
     */
    public UrlBuilder(String scheme, String host, int port, UrlPath path, UrlQuery query, String fragment, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.charset = charset;
        this.scheme = var1_1;
        this.host = var2_2;
        this.port = var3_3;
        this.path = path;
        this.query = query;
        this.setFragment(fragment);
        this.needEncodePercent = charset != null;
    }

    public final String getScheme() {
        return this.scheme;
    }

    public final String getSchemeWithDefault() {
        return StrUtil.emptyToDefault(this.scheme, DEFAULT_SCHEME);
    }

    /*
     * WARNING - void declaration
     */
    public final UrlBuilder setScheme(String scheme) {
        void var1_1;
        this.scheme = var1_1;
        return this;
    }

    public final String getHost() {
        return this.host;
    }

    /*
     * WARNING - void declaration
     */
    public final UrlBuilder setHost(String host) {
        void var1_1;
        this.host = var1_1;
        return this;
    }

    public final int getPort() {
        return this.port;
    }

    /*
     * WARNING - void declaration
     */
    public final int getPortWithDefault() {
        int port = this.getPort();
        if (port > 0) {
            void var1_1;
            return (int)var1_1;
        }
        URL uRL = this.toURL();
        return uRL.getDefaultPort();
    }

    /*
     * WARNING - void declaration
     */
    public final UrlBuilder setPort(int port) {
        void var1_1;
        this.port = var1_1;
        return this;
    }

    public final String getAuthority() {
        if (this.port < 0) {
            return this.host;
        }
        return this.host + ":" + this.port;
    }

    public final UrlPath getPath() {
        return this.path;
    }

    public final String getPathStr() {
        if (this.path == null) {
            return "/";
        }
        return this.path.build(this.charset, this.needEncodePercent);
    }

    /*
     * WARNING - void declaration
     */
    public final UrlBuilder setWithEndTag(boolean withEngTag) {
        void var1_1;
        if (this.path == null) {
            this.path = new UrlPath();
        }
        this.path.setWithEndTag((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final UrlBuilder setPath(UrlPath path) {
        void var1_1;
        this.path = var1_1;
        return this;
    }

    public final UrlBuilder addPath(CharSequence path) {
        UrlPath.of(path, this.charset).getSegments().forEach(this::addPathSegment);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final UrlBuilder addPathSegment(CharSequence segment) {
        void var1_1;
        if (StrUtil.isEmpty(segment)) {
            return this;
        }
        if (this.path == null) {
            this.path = new UrlPath();
        }
        this.path.add((CharSequence)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final UrlBuilder appendPath(CharSequence path) {
        void var1_1;
        return this.addPath((CharSequence)var1_1);
    }

    public final UrlQuery getQuery() {
        return this.query;
    }

    public final String getQueryStr() {
        if (this.query == null) {
            return null;
        }
        return this.query.build(this.charset, this.needEncodePercent);
    }

    /*
     * WARNING - void declaration
     */
    public final UrlBuilder setQuery(UrlQuery query) {
        void var1_1;
        this.query = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final UrlBuilder addQuery(String key, Object value) {
        void var2_2;
        void var1_1;
        if (StrUtil.isEmpty(key)) {
            return this;
        }
        if (this.query == null) {
            this.query = new UrlQuery();
        }
        this.query.add((CharSequence)var1_1, var2_2);
        return this;
    }

    public final String getFragment() {
        return this.fragment;
    }

    /*
     * WARNING - void declaration
     */
    public final String getFragmentEncoded() {
        void var1_1;
        char[] cArray;
        if (this.needEncodePercent) {
            cArray = null;
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = 37;
        }
        char[] safeChars = cArray;
        return RFC3986.FRAGMENT.encode(this.fragment, this.charset, (char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final UrlBuilder setFragment(String fragment) {
        void var1_1;
        if (StrUtil.isEmpty(fragment)) {
            this.fragment = null;
        }
        this.fragment = StrUtil.removePrefix((CharSequence)var1_1, "#");
        return this;
    }

    public final Charset getCharset() {
        return this.charset;
    }

    /*
     * WARNING - void declaration
     */
    public final UrlBuilder setCharset(Charset charset) {
        void var1_1;
        this.charset = var1_1;
        return this;
    }

    @Override
    public final String build() {
        return this.toURL().toString();
    }

    public final URL toURL() {
        return this.toURL(null);
    }

    /*
     * WARNING - void declaration
     */
    public final URL toURL(URLStreamHandler handler) {
        StringBuilder fileBuilder = new StringBuilder();
        fileBuilder.append(this.getPathStr());
        String query = this.getQueryStr();
        if (StrUtil.isNotBlank(query)) {
            void var3_3;
            fileBuilder.append('?').append((String)var3_3);
        }
        if (StrUtil.isNotBlank(this.fragment)) {
            fileBuilder.append('#').append(this.getFragmentEncoded());
        }
        try {
            void var1_1;
            void var2_2;
            return new URL(this.getSchemeWithDefault(), this.host, this.port, var2_2.toString(), (URLStreamHandler)var1_1);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public final URI toURI() {
        try {
            return this.toURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public final String toString() {
        return this.build();
    }
}

