/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net.multipart;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.net.multipart.MultipartRequestInputStream;
import cn.hutool.core.net.multipart.UploadFileHeader;
import cn.hutool.core.net.multipart.UploadSetting;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;

public class UploadFile {
    private static final String TMP_FILE_PREFIX = "hutool-";
    private static final String TMP_FILE_SUFFIX = ".upload.tmp";
    private final UploadFileHeader header;
    private final UploadSetting setting;
    private long size = -1L;
    private byte[] data;
    private File tempFile;

    /*
     * WARNING - void declaration
     */
    public UploadFile(UploadFileHeader header, UploadSetting setting) {
        void var2_2;
        void var1_1;
        this.header = var1_1;
        this.setting = var2_2;
    }

    public void delete() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        if (this.data != null) {
            this.data = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public File write(String destPath) throws IOException {
        if (this.data != null || this.tempFile != null) {
            void var1_1;
            return this.write(FileUtil.file((String)var1_1));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public File write(File destination) throws IOException {
        void var1_1;
        this.assertValid();
        if (destination.isDirectory()) {
            destination = new File(destination, this.header.getFileName());
        }
        if (this.data != null) {
            FileUtil.writeBytes(this.data, destination);
            this.data = null;
        } else {
            if (this.tempFile == null) {
                throw new NullPointerException("Temp file is null !");
            }
            if (!this.tempFile.exists()) {
                throw new NoSuchFileException("Temp file: [" + this.tempFile.getAbsolutePath() + "] not exist!");
            }
            FileUtil.move(this.tempFile, destination, true);
        }
        return var1_1;
    }

    public byte[] getFileContent() throws IOException {
        this.assertValid();
        if (this.data != null) {
            return this.data;
        }
        if (this.tempFile != null) {
            return FileUtil.readBytes(this.tempFile);
        }
        return null;
    }

    public InputStream getFileInputStream() throws IOException {
        this.assertValid();
        if (this.data != null) {
            return IoUtil.toBuffered(IoUtil.toStream(this.data));
        }
        if (this.tempFile != null) {
            return IoUtil.toBuffered(IoUtil.toStream(this.tempFile));
        }
        return null;
    }

    public UploadFileHeader getHeader() {
        return this.header;
    }

    public String getFileName() {
        if (this.header == null) {
            return null;
        }
        return this.header.getFileName();
    }

    public long size() {
        return this.size;
    }

    public boolean isUploaded() {
        return this.size > 0L;
    }

    public boolean isInMemory() {
        return this.data != null;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean processStream(MultipartRequestInputStream input) throws IOException {
        BufferedOutputStream out;
        block8: {
            void var1_1;
            long maxFileSize;
            block7: {
                if (!this.isAllowedExtension()) {
                    this.size = input.skipToBoundary();
                    return false;
                }
                this.size = 0L;
                int memoryThreshold = this.setting.memoryThreshold;
                if (memoryThreshold > 0) {
                    void var2_3;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(memoryThreshold);
                    long written = input.copy(baos, memoryThreshold);
                    this.data = baos.toByteArray();
                    if (written <= (long)var2_3) {
                        this.size = this.data.length;
                        return true;
                    }
                }
                this.tempFile = FileUtil.createTempFile(TMP_FILE_PREFIX, TMP_FILE_SUFFIX, FileUtil.touch(this.setting.tmpUploadPath), false);
                out = FileUtil.getOutputStream(this.tempFile);
                if (this.data != null) {
                    this.size = this.data.length;
                    out.write(this.data);
                    this.data = null;
                }
                maxFileSize = this.setting.maxFileSize;
                try {
                    if (maxFileSize != -1L) break block7;
                    this.size += input.copy(out);
                }
                catch (Throwable throwable) {
                    void var3_4;
                    IoUtil.close((Closeable)var3_4);
                    throw throwable;
                }
                IoUtil.close(out);
                return true;
            }
            this.size += input.copy(out, maxFileSize - this.size + 1L);
            if (this.size <= maxFileSize) break block8;
            this.tempFile.delete();
            this.tempFile = null;
            var1_1.skipToBoundary();
            IoUtil.close(out);
            return false;
        }
        IoUtil.close(out);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isAllowedExtension() {
        void var2_2;
        String[] exts = this.setting.fileExts;
        boolean isAllow = this.setting.isAllowFileExts;
        if (exts == null || exts.length == 0) {
            return isAllow;
        }
        String fileNameExt = FileUtil.extName(this.getFileName());
        String[] stringArray = this.setting.fileExts;
        int n = this.setting.fileExts.length;
        for (int i = 0; i < n; ++i) {
            String fileExtension = stringArray[i];
            if (!fileNameExt.equalsIgnoreCase(fileExtension)) continue;
            return isAllow;
        }
        return var2_2 == false;
    }

    private void assertValid() throws IOException {
        if (!this.isUploaded()) {
            throw new IOException(StrUtil.format("File [{}] upload fail", this.getFileName()));
        }
    }
}

