/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net.multipart;

import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.net.multipart.UploadFileHeader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class MultipartRequestInputStream
extends BufferedInputStream {
    protected byte[] boundary;
    protected UploadFileHeader lastHeader;

    /*
     * WARNING - void declaration
     */
    public MultipartRequestInputStream(InputStream in) {
        super((InputStream)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public byte readByte() throws IOException {
        void var1_1;
        int i = super.read();
        if (i == -1) {
            throw new IOException("End of HTTP request stream reached");
        }
        return (byte)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void skipBytes(long i) throws IOException {
        void var1_1;
        long l = super.skip(i);
        if (l != var1_1) {
            throw new IOException("Unable to skip data in HTTP request");
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readBoundary() throws IOException {
        void var1_1;
        byte b;
        ByteArrayOutputStream boundaryOutput = new ByteArrayOutputStream(1024);
        while ((b = this.readByte()) <= 32) {
        }
        do {
            boundaryOutput.write(b);
        } while ((b = this.readByte()) != 13);
        if (boundaryOutput.size() == 0) {
            throw new IOException("Problems with parsing request: invalid boundary");
        }
        this.skipBytes(1L);
        this.boundary = new byte[boundaryOutput.size() + 2];
        System.arraycopy(var1_1.toByteArray(), 0, this.boundary, 2, this.boundary.length - 2);
        this.boundary[0] = 13;
        this.boundary[1] = 10;
        return this.boundary;
    }

    public UploadFileHeader getLastHeader() {
        return this.lastHeader;
    }

    /*
     * WARNING - void declaration
     */
    public UploadFileHeader readDataHeader(Charset encoding) throws IOException {
        void var1_1;
        String dataHeader = this.readDataHeaderString(encoding);
        this.lastHeader = dataHeader != null ? new UploadFileHeader((String)var1_1) : null;
        return this.lastHeader;
    }

    /*
     * WARNING - void declaration
     */
    protected String readDataHeaderString(Charset charset) throws IOException {
        void var1_1;
        void var2_2;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        while (true) {
            void var3_3;
            byte b;
            if ((b = this.readByte()) != 13) {
                data.write(b);
                continue;
            }
            this.mark(4);
            this.skipBytes(1L);
            int i = this.read();
            if (i == -1) {
                return null;
            }
            if (i == 13) break;
            this.reset();
            data.write((int)var3_3);
        }
        this.reset();
        this.skipBytes(3L);
        if (charset == null) {
            return data.toString();
        }
        return var2_2.toString(var1_1.name());
    }

    /*
     * WARNING - void declaration
     */
    public String readString(Charset charset) throws IOException {
        void var1_1;
        void var2_2;
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        this.copy(out);
        return var2_2.toString((Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public long copy(OutputStream out) throws IOException {
        void var2_2;
        byte b;
        long count = 0L;
        while (!this.isBoundary(b = this.readByte())) {
            out.write(b);
            ++count;
        }
        return (long)var2_2;
    }

    public long copy(OutputStream out, long limit) throws IOException {
        byte b;
        long count = 0L;
        while (!this.isBoundary(b = this.readByte())) {
            out.write(b);
            if (++count <= limit) continue;
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    public long skipToBoundary() throws IOException {
        void var1_1;
        void var3_2;
        long count = 0L;
        do {
            byte b = this.readByte();
            ++count;
        } while (!this.isBoundary((byte)var3_2));
        return (long)var1_1;
    }

    public boolean isBoundary(byte b) throws IOException {
        int boundaryLen = this.boundary.length;
        this.mark(boundaryLen + 1);
        int bpos = 0;
        while (b == this.boundary[bpos]) {
            b = this.readByte();
            if (++bpos != boundaryLen) continue;
            return true;
        }
        this.reset();
        return false;
    }
}

