/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net.multipart;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.multi.ListValueMap;
import cn.hutool.core.net.multipart.MultipartRequestInputStream;
import cn.hutool.core.net.multipart.UploadFile;
import cn.hutool.core.net.multipart.UploadFileHeader;
import cn.hutool.core.net.multipart.UploadSetting;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultipartFormData {
    private final ListValueMap<String, String> requestParameters = new ListValueMap();
    private final ListValueMap<String, UploadFile> requestFiles = new ListValueMap();
    private final UploadSetting setting;
    private boolean loaded;

    public MultipartFormData() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    public MultipartFormData(UploadSetting uploadSetting) {
        void var1_1;
        this.setting = uploadSetting == null ? new UploadSetting() : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void parseRequestStream(InputStream inputStream, Charset charset) throws IOException {
        UploadFileHeader header;
        this.setLoaded();
        MultipartRequestInputStream input = new MultipartRequestInputStream(inputStream);
        input.readBoundary();
        while ((header = input.readDataHeader(charset)) != null) {
            if (header.isFile) {
                UploadFile newFile;
                String string = header.fileName;
                if (string.length() > 0 && header.contentType.contains("application/x-macbinary")) {
                    input.skipBytes(128L);
                }
                if ((newFile = new UploadFile(header, this.setting)).processStream(input)) {
                    this.putFile(header.formFieldName, newFile);
                }
            } else {
                void var3_3;
                this.putParameter(var3_3.formFieldName, input.readString(charset));
            }
            input.skipBytes(1L);
            input.mark(1);
            int nextByte = input.read();
            if (nextByte == -1 || nextByte == 45) {
                input.reset();
                return;
            }
            input.reset();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getParam(String paramName) {
        List<String> values = this.getListParam(paramName);
        if (CollUtil.isNotEmpty(values)) {
            void var1_1;
            return (String)var1_1.get(0);
        }
        return null;
    }

    public Set<String> getParamNames() {
        return this.requestParameters.keySet();
    }

    /*
     * WARNING - void declaration
     */
    public String[] getArrayParam(String paramName) {
        List<String> listParam = this.getListParam(paramName);
        if (listParam != null) {
            void var1_1;
            return var1_1.toArray(new String[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getListParam(String paramName) {
        void var1_1;
        return (List)this.requestParameters.get(var1_1);
    }

    public Map<String, String[]> getParamMap() {
        return Convert.toMap(String.class, String[].class, this.getParamListMap());
    }

    public ListValueMap<String, String> getParamListMap() {
        return this.requestParameters;
    }

    /*
     * WARNING - void declaration
     */
    public UploadFile getFile(String paramName) {
        UploadFile[] values = this.getFiles(paramName);
        if (values != null && values.length > 0) {
            void var1_1;
            return var1_1[0];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public UploadFile[] getFiles(String paramName) {
        List<UploadFile> fileList = this.getFileList(paramName);
        if (fileList != null) {
            void var1_1;
            return var1_1.toArray(new UploadFile[0]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<UploadFile> getFileList(String paramName) {
        void var1_1;
        return (List)this.requestFiles.get(var1_1);
    }

    public Set<String> getFileParamNames() {
        return this.requestFiles.keySet();
    }

    public Map<String, UploadFile[]> getFileMap() {
        return Convert.toMap(String.class, UploadFile[].class, this.getFileListValueMap());
    }

    public ListValueMap<String, UploadFile> getFileListValueMap() {
        return this.requestFiles;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    /*
     * WARNING - void declaration
     */
    private void putFile(String name, UploadFile uploadFile) {
        void var2_2;
        void var1_1;
        this.requestFiles.putValue((String)var1_1, (UploadFile)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void putParameter(String name, String value) {
        void var2_2;
        void var1_1;
        this.requestParameters.putValue((String)var1_1, (String)var2_2);
    }

    private void setLoaded() throws IOException {
        if (this.loaded) {
            throw new IOException("Multi-part request already parsed.");
        }
        this.loaded = true;
    }
}

