/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.BitSet;

@Deprecated
public class URLEncoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final URLEncoder DEFAULT = URLEncoder.createDefault();
    public static final URLEncoder PATH_SEGMENT = URLEncoder.createPathSegment();
    public static final URLEncoder FRAGMENT = URLEncoder.createFragment();
    public static final URLEncoder QUERY = URLEncoder.createQuery();
    public static final URLEncoder ALL = URLEncoder.createAll();
    private final BitSet safeCharacters;
    private boolean encodeSpaceAsPlus = false;

    /*
     * WARNING - void declaration
     */
    public static URLEncoder createDefault() {
        void var0;
        URLEncoder encoder = new URLEncoder();
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        encoder.addSafeCharacter('~');
        URLEncoder.addSubDelims(encoder);
        encoder.addSafeCharacter(':');
        encoder.addSafeCharacter('@');
        encoder.addSafeCharacter('/');
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static URLEncoder createPathSegment() {
        void var0;
        URLEncoder encoder = new URLEncoder();
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        encoder.addSafeCharacter('~');
        URLEncoder.addSubDelims(encoder);
        encoder.addSafeCharacter('@');
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static URLEncoder createFragment() {
        void var0;
        URLEncoder encoder = new URLEncoder();
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        encoder.addSafeCharacter('~');
        URLEncoder.addSubDelims(encoder);
        encoder.addSafeCharacter(':');
        encoder.addSafeCharacter('@');
        encoder.addSafeCharacter('/');
        encoder.addSafeCharacter('?');
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static URLEncoder createQuery() {
        void var0;
        URLEncoder encoder = new URLEncoder();
        encoder.setEncodeSpaceAsPlus(true);
        encoder.addSafeCharacter('*');
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        encoder.addSafeCharacter('=');
        encoder.addSafeCharacter('&');
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static URLEncoder createAll() {
        void var0;
        URLEncoder encoder = new URLEncoder();
        encoder.addSafeCharacter('*');
        encoder.addSafeCharacter('-');
        encoder.addSafeCharacter('.');
        encoder.addSafeCharacter('_');
        return var0;
    }

    public URLEncoder() {
        this(new BitSet(256));
        this.addAlpha();
        this.addDigit();
    }

    /*
     * WARNING - void declaration
     */
    private URLEncoder(BitSet safeCharacters) {
        void var1_1;
        this.safeCharacters = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addSafeCharacter(char c) {
        void var1_1;
        this.safeCharacters.set((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeSafeCharacter(char c) {
        void var1_1;
        this.safeCharacters.clear((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setEncodeSpaceAsPlus(boolean encodeSpaceAsPlus) {
        void var1_1;
        this.encodeSpaceAsPlus = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String encode(String path, Charset charset) {
        void var3_3;
        if (charset == null || StrUtil.isEmpty(path)) {
            return path;
        }
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, charset);
        for (int i = 0; i < path.length(); ++i) {
            block7: {
                char c = path.charAt(i);
                if (this.safeCharacters.get(c)) {
                    rewrittenPath.append(c);
                    continue;
                }
                if (this.encodeSpaceAsPlus && c == ' ') {
                    rewrittenPath.append('+');
                    continue;
                }
                try {
                    writer.write(c);
                    writer.flush();
                }
                catch (IOException iOException) {
                    break block7;
                }
                byte[] byArray = buf.toByteArray();
                byte[] byArray2 = byArray;
                byArray2 = byArray;
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    byte toEncode = byArray2[j];
                    rewrittenPath.append('%');
                    HexUtil.appendHex(rewrittenPath, toEncode, false);
                }
            }
            buf.reset();
        }
        return var3_3.toString();
    }

    private void addAlpha() {
        char i;
        for (i = 'a'; i <= 'z'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
    }

    private void addDigit() {
        for (char i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
    }

    private static void addSubDelims(URLEncoder encoder) {
        URLEncoder uRLEncoder;
        encoder.addSafeCharacter('!');
        encoder.addSafeCharacter('$');
        encoder.addSafeCharacter('&');
        encoder.addSafeCharacter('\'');
        encoder.addSafeCharacter('(');
        encoder.addSafeCharacter(')');
        encoder.addSafeCharacter('*');
        encoder.addSafeCharacter('+');
        encoder.addSafeCharacter(',');
        encoder.addSafeCharacter(';');
        uRLEncoder.addSafeCharacter('=');
    }
}

