/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.CharsetUtil;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;

public class URLDecoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte ESCAPE_CHAR = 37;

    /*
     * WARNING - void declaration
     */
    public static String decodeForPath(String str, Charset charset) {
        void var1_1;
        return URLDecoder.decode(str, (Charset)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String decode(String str, Charset charset) {
        void var1_1;
        return URLDecoder.decode(str, (Charset)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String decode(String str, Charset charset, boolean isPlusToSpace) {
        if (str == null || charset == null) {
            return str;
        }
        int length = str.length();
        if (length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(length / 3);
        int begin = 0;
        for (int i = 0; i < length; ++i) {
            int c = str.charAt(i);
            if (37 == c || CharUtil.isHexChar((char)c)) continue;
            if (i > begin) {
                result.append(URLDecoder.decodeSub(str, begin, i, charset, isPlusToSpace));
            }
            if (43 == c && isPlusToSpace) {
                c = 32;
            }
            result.append((char)c);
            begin = i + 1;
        }
        if (begin < length) {
            void var2_2;
            void var1_1;
            void var3_3;
            String string;
            result.append(URLDecoder.decodeSub(string, begin, (int)var3_3, (Charset)var1_1, (boolean)var2_2));
        }
        return result.toString();
    }

    public static byte[] decode(byte[] bytes) {
        return URLDecoder.decode(bytes, true);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decode(byte[] bytes, boolean isPlusToSpace) {
        void var2_2;
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            void var3_4;
            int b = bytes[i];
            if (b == 43) {
                buffer.write(isPlusToSpace ? 32 : b);
                continue;
            }
            if (b == 37) {
                int l;
                int u;
                if (i + 1 < bytes.length && (u = CharUtil.digit16(bytes[i + 1])) >= 0 && i + 2 < bytes.length && (l = CharUtil.digit16(bytes[i + 2])) >= 0) {
                    buffer.write((char)((u << 4) + l));
                    i += 2;
                    continue;
                }
                buffer.write(b);
                continue;
            }
            buffer.write((int)var3_4);
        }
        return var2_2.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    private static String decodeSub(String str, int begin, int end, Charset charset, boolean isPlusToSpace) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return new String(URLDecoder.decode(string.substring((int)var1_1, (int)var2_2).getBytes(CharsetUtil.CHARSET_ISO_8859_1), isPlusToSpace), (Charset)var3_3);
    }
}

