/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.net.DefaultTrustManager;
import cn.hutool.core.net.SSLProtocols;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class SSLContextBuilder
implements Builder<SSLContext>,
SSLProtocols {
    private static final long serialVersionUID = 1L;
    private String protocol = "TLS";
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers = new TrustManager[]{DefaultTrustManager.INSTANCE};
    private SecureRandom secureRandom = new SecureRandom();

    public static SSLContextBuilder create() {
        return new SSLContextBuilder();
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder setProtocol(String protocol) {
        if (StrUtil.isNotBlank(protocol)) {
            void var1_1;
            this.protocol = var1_1;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder setTrustManagers(TrustManager ... trustManagers) {
        if (ArrayUtil.isNotEmpty(trustManagers)) {
            void var1_1;
            this.trustManagers = var1_1;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder setKeyManagers(KeyManager ... keyManagers) {
        if (ArrayUtil.isNotEmpty(keyManagers)) {
            void var1_1;
            this.keyManagers = var1_1;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder setSecureRandom(SecureRandom secureRandom) {
        if (secureRandom != null) {
            void var1_1;
            this.secureRandom = var1_1;
        }
        return this;
    }

    @Override
    public SSLContext build() {
        return this.buildQuietly();
    }

    /*
     * WARNING - void declaration
     */
    public SSLContext buildChecked() throws NoSuchAlgorithmException, KeyManagementException {
        void var1_1;
        SSLContext sslContext = SSLContext.getInstance(this.protocol);
        sslContext.init(this.keyManagers, this.trustManagers, this.secureRandom);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContext buildQuietly() throws IORuntimeException {
        try {
            return this.buildChecked();
        }
        catch (GeneralSecurityException e) {
            void var1_1;
            throw new IORuntimeException((Throwable)var1_1);
        }
    }
}

