/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.EnumerationIter;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.net.Ipv4Util;
import cn.hutool.core.net.UserPassAuthenticator;
import cn.hutool.core.util.JNDIUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.DatagramSocket;
import java.net.HttpCookie;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;

public class NetUtil {
    public static final String LOCAL_IP = "127.0.0.1";
    public static String localhostName;
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;

    public static String longToIpv4(long longIP) {
        return Ipv4Util.longToIpv4(longIP);
    }

    public static long ipv4ToLong(String strIP) {
        return Ipv4Util.ipv4ToLong(strIP);
    }

    @Deprecated
    public static BigInteger ipv6ToBitInteger(String ipv6Str) {
        return NetUtil.ipv6ToBigInteger(ipv6Str);
    }

    public static BigInteger ipv6ToBigInteger(String ipv6Str) {
        try {
            InetAddress address = InetAddress.getByName(ipv6Str);
            if (address instanceof Inet6Address) {
                InetAddress inetAddress;
                return new BigInteger(1, inetAddress.getAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return null;
    }

    public static String bigIntegerToIPv6(BigInteger bigInteger) {
        try {
            return InetAddress.getByAddress(bigInteger.toByteArray()).toString().substring(1);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isUsableLocalPort(int port2) {
        Throwable throwable;
        if (!NetUtil.isValidPort(port2)) {
            return false;
        }
        try {
            ServerSocket ss2 = new ServerSocket(port2);
            throwable = null;
            try {
                ss2.setReuseAddress(true);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable port2 = throwable2;
                    throwable = throwable2;
                    throw port2;
                }
                catch (Throwable port2) {
                    if (throwable != null) {
                        try {
                            ss2.close();
                        }
                        catch (Throwable ss2) {
                            throwable.addSuppressed(ss2);
                        }
                    } else {
                        ss2.close();
                    }
                    throw port2;
                }
            }
            ss2.close();
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            int n;
            DatagramSocket ds2 = new DatagramSocket(n);
            throwable = null;
            try {
                ds2.setReuseAddress(true);
                ds2.close();
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable3;
                    throwable = throwable3;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable != null) {
                        try {
                            ds2.close();
                        }
                        catch (Throwable ds2) {
                            throwable.addSuppressed(ds2);
                        }
                    } else {
                        void var1_5;
                        var1_5.close();
                    }
                    throw throwable5;
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static boolean isValidPort(int port) {
        int n;
        return port >= 0 && n <= 65535;
    }

    public static int getUsableLocalPort() {
        return NetUtil.getUsableLocalPort(1024);
    }

    public static int getUsableLocalPort(int minPort) {
        return NetUtil.getUsableLocalPort(minPort, 65535);
    }

    /*
     * WARNING - void declaration
     */
    public static int getUsableLocalPort(int minPort, int maxPort) {
        int n;
        void var1_1;
        int maxPortExclude = maxPort + 1;
        for (int i = minPort; i < maxPortExclude; ++i) {
            void var3_4;
            int randomPort = RandomUtil.randomInt(minPort, maxPortExclude);
            if (!NetUtil.isUsableLocalPort(randomPort)) continue;
            return (int)var3_4;
        }
        throw new UtilException("Could not find an available port in the range [{}, {}] after {} attempts", minPort, maxPort, (int)(var1_1 - n));
    }

    /*
     * WARNING - void declaration
     */
    public static TreeSet<Integer> getUsableLocalPorts(int numRequested, int minPort, int maxPort) {
        void var3_3;
        TreeSet<Integer> availablePorts = new TreeSet<Integer>();
        int attemptCount = 0;
        while (++attemptCount <= numRequested + 100 && availablePorts.size() < numRequested) {
            availablePorts.add(NetUtil.getUsableLocalPort(minPort, maxPort));
        }
        if (availablePorts.size() != numRequested) {
            void var2_2;
            void var1_1;
            int n;
            throw new UtilException("Could not find {} available  ports in the range [{}, {}]", n, (int)var1_1, (int)var2_2);
        }
        return var3_3;
    }

    public static boolean isInnerIP(String ipAddress) {
        return Ipv4Util.isInnerIP(ipAddress);
    }

    /*
     * WARNING - void declaration
     */
    public static String toAbsoluteUrl(String absoluteBasePath, String relativePath) {
        try {
            URL absoluteUrl = new URL(absoluteBasePath);
            return new URL(absoluteUrl, relativePath).toString();
        }
        catch (Exception e) {
            String string;
            void var1_1;
            void var2_3;
            throw new UtilException((Throwable)var2_3, "To absolute url [{}] base [{}] error!", var1_1, string);
        }
    }

    public static String hideIpPart(String ip) {
        String string;
        return StrUtil.builder(ip.length()).append(ip, 0, string.lastIndexOf(".") + 1).append("*").toString();
    }

    public static String hideIpPart(long ip) {
        return NetUtil.hideIpPart(NetUtil.longToIpv4(ip));
    }

    /*
     * WARNING - void declaration
     */
    public static InetSocketAddress buildInetSocketAddress(String host, int defaultPort) {
        void var0_1;
        void var2_4;
        int port2;
        String destHost;
        int index;
        if (StrUtil.isBlank(host)) {
            host = LOCAL_IP;
        }
        if ((index = host.indexOf(":")) != -1) {
            void var3_3;
            destHost = host.substring(0, index);
            port2 = Integer.parseInt(host.substring((int)(var3_3 + true)));
        } else {
            void var1_2;
            String port;
            destHost = port;
            port2 = var1_2;
        }
        return new InetSocketAddress((String)var2_4, (int)var0_1);
    }

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            String string;
            return string;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static NetworkInterface getNetworkInterface(String name) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            return null;
        }
        while (networkInterfaces.hasMoreElements()) {
            void var2_2;
            NetworkInterface netInterface = networkInterfaces.nextElement();
            if (netInterface == null || !name.equals(netInterface.getName())) continue;
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<NetworkInterface> getNetworkInterfaces() {
        void var0;
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            return null;
        }
        return CollUtil.addAll(new ArrayList(), var0);
    }

    public static LinkedHashSet<String> localIpv4s() {
        LinkedHashSet<InetAddress> linkedHashSet = NetUtil.localAddressList(t -> t instanceof Inet4Address);
        return NetUtil.toIpList(linkedHashSet);
    }

    public static LinkedHashSet<String> localIpv6s() {
        LinkedHashSet<InetAddress> linkedHashSet = NetUtil.localAddressList(t -> t instanceof Inet6Address);
        return NetUtil.toIpList(linkedHashSet);
    }

    /*
     * WARNING - void declaration
     */
    public static LinkedHashSet<String> toIpList(Set<InetAddress> addressList) {
        void var1_1;
        Iterator<InetAddress> iterator;
        LinkedHashSet<String> ipSet = new LinkedHashSet<String>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            InetAddress address = (InetAddress)iterator.next();
            ipSet.add(var2_2.getHostAddress());
        }
        return var1_1;
    }

    public static LinkedHashSet<String> localIps() {
        LinkedHashSet<InetAddress> linkedHashSet = NetUtil.localAddressList(null);
        return NetUtil.toIpList(linkedHashSet);
    }

    public static LinkedHashSet<InetAddress> localAddressList(Filter<InetAddress> addressFilter) {
        Filter<InetAddress> filter;
        return NetUtil.localAddressList(null, filter);
    }

    /*
     * WARNING - void declaration
     */
    public static LinkedHashSet<InetAddress> localAddressList(Filter<NetworkInterface> networkInterfaceFilter, Filter<InetAddress> addressFilter) {
        void var3_4;
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new UtilException(e);
        }
        if (networkInterfaces == null) {
            throw new UtilException("Get network interface error!");
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (networkInterfaceFilter != null && !networkInterfaceFilter.accept(networkInterface)) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || addressFilter != null && !addressFilter.accept(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static String getLocalhostStr() {
        InetAddress localhost = NetUtil.getLocalhost();
        if (localhost != null) {
            void var0;
            return var0.getHostAddress();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static InetAddress getLocalhost() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(address -> {
            InetAddress inetAddress;
            return false == address.isLoopbackAddress() && inetAddress instanceof Inet4Address;
        });
        if (CollUtil.isNotEmpty(localAddressList)) {
            Iterator iterator;
            Object address2 = null;
            iterator = ((HashSet)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                void var2_2;
                InetAddress inetAddress = (InetAddress)iterator.next();
                if (!inetAddress.isSiteLocalAddress()) {
                    return inetAddress;
                }
                if (address2 != null) continue;
                address2 = var2_2;
            }
            if (address2 != null) {
                void var1_1;
                return var1_1;
            }
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static String getLocalMacAddress() {
        return NetUtil.getMacAddress(NetUtil.getLocalhost());
    }

    public static String getMacAddress(InetAddress inetAddress) {
        return NetUtil.getMacAddress(inetAddress, "-");
    }

    /*
     * WARNING - void declaration
     */
    public static String getMacAddress(InetAddress inetAddress, String separator) {
        if (inetAddress == null) {
            return null;
        }
        Object mac = NetUtil.getHardwareAddress(inetAddress);
        if (mac != null) {
            void var2_2;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ((Object)mac).length; ++i) {
                void var3_4;
                String s;
                if (i != 0) {
                    sb.append(separator);
                }
                sb.append((String)((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? "0" + s : var3_4));
            }
            return var2_2.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getHardwareAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            if (networkInterface != null) {
                return networkInterface.getHardwareAddress();
            }
        }
        catch (SocketException e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1);
        }
        return null;
    }

    public static byte[] getLocalHardwareAddress() {
        return NetUtil.getHardwareAddress(NetUtil.getLocalhost());
    }

    /*
     * WARNING - void declaration
     */
    public static String getLocalHostName() {
        if (StrUtil.isNotBlank(localhostName)) {
            return localhostName;
        }
        InetAddress localhost = NetUtil.getLocalhost();
        if (localhost != null) {
            void var1_1;
            String name = localhost.getHostName();
            if (StrUtil.isEmpty(name)) {
                void var0;
                name = var0.getHostAddress();
            }
            localhostName = var1_1;
        }
        return localhostName;
    }

    /*
     * WARNING - void declaration
     */
    public static InetSocketAddress createAddress(String host, int port) {
        void var1_1;
        String string;
        if (StrUtil.isBlank(host)) {
            return new InetSocketAddress(port);
        }
        return new InetSocketAddress(string, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void netCat(String host, int port, boolean isBlock, ByteBuffer data) throws IORuntimeException {
        try {
            SocketChannel channel2;
            block12: {
                block11: {
                    void var1_3;
                    channel2 = SocketChannel.open(NetUtil.createAddress(host, (int)var1_3));
                    Throwable throwable = null;
                    try {
                        void var3_8;
                        void var2_5;
                        channel2.configureBlocking((boolean)var2_5);
                        channel2.write((ByteBuffer)var3_8);
                        if (channel2 == null) break block11;
                    }
                    catch (Throwable throwable2) {
                        try {
                            Throwable throwable3 = throwable2;
                            throwable = throwable2;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (channel2 != null) {
                                if (throwable != null) {
                                    try {
                                        channel2.close();
                                    }
                                    catch (Throwable channel2) {
                                        throwable.addSuppressed(channel2);
                                    }
                                } else {
                                    channel2.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    break block12;
                }
                return;
            }
            channel2.close();
        }
        catch (IOException e) {
            void var0_2;
            throw new IORuntimeException((Throwable)var0_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void netCat(String host, int port, byte[] data) throws IORuntimeException {
        OutputStream out = null;
        try {
            Throwable throwable;
            void var1_4;
            Socket socket2 = new Socket(host, (int)var1_4);
            Throwable throwable2 = null;
            try {
                out = socket2.getOutputStream();
                out.write((byte[])throwable);
                out.flush();
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throwable2 = throwable3;
                    throw throwable;
                }
                catch (Throwable throwable4) {
                    if (throwable2 != null) {
                        try {
                            socket2.close();
                        }
                        catch (Throwable socket2) {
                            throwable2.addSuppressed(socket2);
                        }
                    } else {
                        socket2.close();
                    }
                    throw throwable4;
                }
            }
            socket2.close();
        }
        catch (IOException e) {
            try {
                void var0_2;
                throw new IORuntimeException((Throwable)var0_2);
            }
            catch (Throwable throwable) {
                void var3_8;
                IoUtil.close((Closeable)var3_8);
                throw throwable;
            }
        }
        IoUtil.close(out);
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isInRange(String ip, String cidr) {
        void var3_3;
        String string;
        void var2_2;
        void var1_1;
        int maskSplitMarkIndex = cidr.lastIndexOf("/");
        if (maskSplitMarkIndex < 0) {
            throw new IllegalArgumentException("Invalid cidr: " + cidr);
        }
        long mask = -1L << 32 - Integer.parseInt(cidr.substring(maskSplitMarkIndex + 1));
        long cidrIpAddr = NetUtil.ipv4ToLong(var1_1.substring(0, (int)var2_2));
        return (NetUtil.ipv4ToLong(string) & mask) == (cidrIpAddr & var3_3);
    }

    public static String idnToASCII(String unicode) {
        return IDN.toASCII(unicode);
    }

    /*
     * WARNING - void declaration
     */
    public static String getMultistageReverseProxyIp(String ip) {
        String string;
        if (ip != null && StrUtil.indexOf(ip, ',') > 0) {
            Object object = StrUtil.splitTrim((CharSequence)ip, ',');
            object = object.iterator();
            while (object.hasNext()) {
                void var2_2;
                String subIp = (String)object.next();
                if (NetUtil.isUnknown(subIp)) continue;
                ip = var2_2;
                break;
            }
        }
        return string;
    }

    public static boolean isUnknown(String checkString) {
        String string;
        return StrUtil.isBlank(checkString) || "unknown".equalsIgnoreCase(string);
    }

    public static boolean ping(String ip) {
        return NetUtil.ping(ip, 200);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean ping(String ip, int timeout) {
        try {
            void var1_1;
            return InetAddress.getByName(ip).isReachable((int)var1_1);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static List<HttpCookie> parseCookies(String cookieStr) {
        String string;
        if (StrUtil.isBlank(cookieStr)) {
            return Collections.emptyList();
        }
        return HttpCookie.parse(string);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isOpen(InetSocketAddress address, int timeout) {
        Serializable serializable;
        Socket sc = new Socket();
        Throwable throwable = null;
        try {
            void var1_2;
            sc.connect((SocketAddress)serializable, (int)var1_2);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    serializable = throwable2;
                    throwable = throwable2;
                    throw serializable;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            sc.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        void var2_4;
                        var2_4.close();
                    }
                    throw throwable3;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        sc.close();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static void setGlobalAuthenticator(String user, char[] pass) {
        void var1_1;
        String string;
        NetUtil.setGlobalAuthenticator(new UserPassAuthenticator(string, (char[])var1_1));
    }

    public static void setGlobalAuthenticator(Authenticator authenticator) {
        Authenticator.setDefault(authenticator);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getDnsInfo(String hostName, String ... attrNames) {
        void var1_1;
        Iterator iterator;
        hostName = StrUtil.addPrefixIfNot(hostName, "dns:");
        Iterator attributes = JNDIUtil.getAttributes(hostName, attrNames);
        ArrayList<String> infos = new ArrayList<String>();
        for (Attribute attribute : new EnumerationIter<Attribute>(iterator.getAll())) {
            try {
                infos.add((String)attribute.get());
            }
            catch (NamingException namingException) {}
        }
        return var1_1;
    }
}

