/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.net.MaskBit;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;

public class Ipv4Util {
    public static final String LOCAL_IP = "127.0.0.1";
    public static final String IP_SPLIT_MARK = "-";
    public static final String IP_MASK_SPLIT_MARK = "/";
    public static final int IP_MASK_MAX = 32;

    /*
     * WARNING - void declaration
     */
    public static String formatIpBlock(String ip, String mask) {
        void var1_1;
        String string;
        return string + IP_MASK_SPLIT_MARK + Ipv4Util.getMaskBitByMask((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> list(String ipRange, boolean isAll) {
        String[] stringArray;
        String[] range;
        if (ipRange.contains(IP_SPLIT_MARK)) {
            range = StrUtil.splitToArray((CharSequence)ipRange, IP_SPLIT_MARK);
            return Ipv4Util.list(range[0], range[1]);
        }
        if (range.contains(IP_MASK_SPLIT_MARK)) {
            void var1_1;
            String[] param = StrUtil.splitToArray((CharSequence)range, IP_MASK_SPLIT_MARK);
            return Ipv4Util.list(param[0], Integer.parseInt(stringArray[1]), (boolean)var1_1);
        }
        return ListUtil.toList(new String[]{stringArray});
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> list(String ip, int maskBit, boolean isAll) {
        String string;
        void var3_4;
        void var1_1;
        void var2_2;
        if (maskBit == 32) {
            ArrayList<String> list = new ArrayList<String>();
            if (isAll) {
                list.add(ip);
            }
            return list;
        }
        String startIp = Ipv4Util.getBeginIpStr(ip, maskBit);
        String endIp = Ipv4Util.getEndIpStr(ip, maskBit);
        if (var2_2 != false) {
            return Ipv4Util.list(startIp, endIp);
        }
        int lastDotIndex = startIp.lastIndexOf(46) + 1;
        startIp = StrUtil.subPre(startIp, lastDotIndex) + (Integer.parseInt(Objects.requireNonNull(StrUtil.subSuf(startIp, lastDotIndex))) + 1);
        lastDotIndex = endIp.lastIndexOf(46) + 1;
        endIp = StrUtil.subPre(endIp, lastDotIndex) + (Integer.parseInt(Objects.requireNonNull(StrUtil.subSuf(endIp, (int)var1_1))) - 1);
        return Ipv4Util.list((String)var3_4, string);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> list(String ipFrom, String ipTo) {
        void var2_3;
        void var10_9;
        int count = Ipv4Util.countByIpRange(ipFrom, ipTo);
        Object from = Convert.convert(int[].class, (Object)StrUtil.splitToArray((CharSequence)ipFrom, '.'));
        int[] to = Convert.convert(int[].class, (Object)StrUtil.splitToArray((CharSequence)ipTo, '.'));
        ArrayList<String> ips = new ArrayList<String>(count);
        boolean aIsStart = true;
        boolean bIsStart = true;
        boolean cIsStart = true;
        int aEnd = to[0];
        Object object = from[0];
        while (var10_9 <= aEnd) {
            int b;
            boolean aIsEnd = var10_9 == aEnd;
            int bEnd = aIsEnd ? to[1] : 255;
            Object object2 = b = (Object)(aIsStart ? from[1] : 0);
            while (b <= bEnd) {
                int c;
                boolean bIsEnd = aIsEnd && b == bEnd;
                int cEnd = bIsEnd ? to[2] : 255;
                Object object3 = c = (Object)(bIsStart ? from[2] : 0);
                while (c <= cEnd) {
                    int d;
                    bIsStart = bIsEnd && c == cEnd;
                    int dEnd = bIsStart ? to[3] : 255;
                    Object object4 = d = (Object)(cIsStart ? from[3] : 0);
                    while (d <= dEnd) {
                        ips.add((int)var10_9 + "." + b + "." + c + "." + d);
                        ++d;
                    }
                    boolean bl = false;
                    ++c;
                }
                boolean bl = false;
                ++b;
            }
            boolean bl = false;
            ++var10_9;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static String longToIpv4(long longIP) {
        void var2_1;
        long l;
        StringBuilder sb = StrUtil.builder();
        sb.append(longIP >> 24 & 0xFFL);
        sb.append('.');
        sb.append(longIP >> 16 & 0xFFL);
        sb.append('.');
        sb.append(longIP >> 8 & 0xFFL);
        sb.append('.');
        sb.append(l & 0xFFL);
        return var2_1.toString();
    }

    public static long ipv4ToLong(String strIP) {
        Matcher matcher = PatternPool.IPV4.matcher(strIP);
        if (matcher.matches()) {
            Matcher matcher2;
            return Ipv4Util.matchAddress(matcher2);
        }
        throw new IllegalArgumentException("Invalid IPv4 address!");
    }

    /*
     * WARNING - void declaration
     */
    public static long ipv4ToLong(String strIP, long defaultValue) {
        void var1_1;
        if (Validator.isIpv4(strIP)) {
            String string;
            return Ipv4Util.ipv4ToLong(string);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String getBeginIpStr(String ip, int maskBit) {
        void var1_1;
        return Ipv4Util.longToIpv4(Ipv4Util.getBeginIpLong(ip, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static Long getBeginIpLong(String ip, int maskBit) {
        void var1_1;
        return Ipv4Util.ipv4ToLong(ip) & Ipv4Util.ipv4ToLong(Ipv4Util.getMaskByMaskBit((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String getEndIpStr(String ip, int maskBit) {
        void var1_1;
        return Ipv4Util.longToIpv4(Ipv4Util.getEndIpLong(ip, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int getMaskBitByMask(String mask) {
        void var1_1;
        Integer maskBit = MaskBit.getMaskBit(mask);
        if (maskBit == null) {
            String string;
            throw new IllegalArgumentException("Invalid netmask " + string);
        }
        return var1_1.intValue();
    }

    /*
     * WARNING - void declaration
     */
    public static int countByMaskBit(int maskBit, boolean isAll) {
        int n;
        void var1_1;
        if (!(isAll || maskBit > 0 && maskBit < 32)) {
            return 0;
        }
        int count = (int)Math.pow(2.0, 32 - maskBit);
        if (var1_1 != false) {
            return count;
        }
        return n - 2;
    }

    public static String getMaskByMaskBit(int maskBit) {
        return MaskBit.get(maskBit);
    }

    /*
     * WARNING - void declaration
     */
    public static String getMaskByIpRange(String fromIp, String toIp) {
        void var2_3;
        long toIpLong = Ipv4Util.ipv4ToLong(toIp);
        long l = Ipv4Util.ipv4ToLong(fromIp);
        Assert.isTrue(l < toIpLong, "to IP must be greater than from IP!", new Object[0]);
        String[] fromIpSplit = StrUtil.splitToArray((CharSequence)fromIp, '.');
        String[] toIpSplit = StrUtil.splitToArray((CharSequence)toIp, '.');
        StringBuilder mask = new StringBuilder();
        for (int i = 0; i < toIpSplit.length; ++i) {
            mask.append(255 - Integer.parseInt(toIpSplit[i]) + Integer.parseInt(fromIpSplit[i])).append('.');
        }
        return mask.substring(0, var2_3.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static int countByIpRange(String fromIp, String toIp) {
        void var2_3;
        long toIpLong = Ipv4Util.ipv4ToLong(toIp);
        long l = Ipv4Util.ipv4ToLong(fromIp);
        if (l > toIpLong) {
            throw new IllegalArgumentException("to IP must be greater than from IP!");
        }
        int count = 1;
        Object fromIpSplit = StrUtil.split((CharSequence)fromIp, '.').stream().mapToInt(Integer::parseInt).toArray();
        int[] toIpSplit = StrUtil.split((CharSequence)toIp, '.').stream().mapToInt(Integer::parseInt).toArray();
        for (int i = ((Object)fromIpSplit).length - 1; i >= 0; --i) {
            count = (int)((double)count + (double)(toIpSplit[i] - fromIpSplit[i]) * Math.pow(256.0, ((Object)fromIpSplit).length - i - 1));
        }
        return (int)var2_3;
    }

    public static boolean isMaskValid(String mask) {
        return MaskBit.getMaskBit(mask) != null;
    }

    public static boolean isMaskBitValid(int maskBit) {
        return MaskBit.get(maskBit) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isInnerIP(String ipAddress) {
        String string;
        void var2_2;
        long ipNum = Ipv4Util.ipv4ToLong(ipAddress);
        long aBegin = Ipv4Util.ipv4ToLong("10.0.0.0");
        long aEnd = Ipv4Util.ipv4ToLong("10.255.255.255");
        long bBegin = Ipv4Util.ipv4ToLong("172.16.0.0");
        long bEnd = Ipv4Util.ipv4ToLong("172.31.255.255");
        long cBegin = Ipv4Util.ipv4ToLong("192.168.0.0");
        long cEnd = Ipv4Util.ipv4ToLong("192.168.255.255");
        boolean bl = Ipv4Util.isInner(ipNum, aBegin, aEnd) || Ipv4Util.isInner(ipNum, bBegin, bEnd) || Ipv4Util.isInner((long)var2_2, cBegin, cEnd) || LOCAL_IP.equals(string);
        return bl;
    }

    public static boolean matches(String wildcard, String ipAddress) {
        String[] ipSegments;
        if (!ReUtil.isMatch(PatternPool.IPV4, (CharSequence)ipAddress)) {
            return false;
        }
        String[] wildcardSegments = wildcard.split("\\.");
        if (wildcardSegments.length != (ipSegments = ipAddress.split("\\.")).length) {
            return false;
        }
        for (int i = 0; i < wildcardSegments.length; ++i) {
            if ("*".equals(wildcardSegments[i]) || wildcardSegments[i].equals(ipSegments[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static Long getEndIpLong(String ip, int maskBit) {
        void var1_1;
        return Ipv4Util.getBeginIpLong(ip, maskBit) + (0xFFFFFFFFL & (Ipv4Util.ipv4ToLong(Ipv4Util.getMaskByMaskBit((int)var1_1)) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    /*
     * WARNING - void declaration
     */
    private static long matchAddress(Matcher matcher) {
        void var1_1;
        long addr = 0L;
        for (int i = 1; i <= 4; ++i) {
            addr |= Long.parseLong(matcher.group(i)) << 8 * (4 - i);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isInner(long userIp, long begin, long end) {
        long l;
        void var2_2;
        return userIp >= var2_2 && l <= end;
    }
}

