/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.math;

import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Currency;

public class Money
implements Serializable,
Comparable<Money> {
    private static final long serialVersionUID = -1004117971993390293L;
    public static final String DEFAULT_CURRENCY_CODE = "CNY";
    public static final RoundingMode DEFAULT_ROUNDING_MODE = RoundingMode.HALF_EVEN;
    private static final int[] CENT_FACTORS = new int[]{1, 10, 100, 1000};
    private long cent;
    private final Currency currency;

    public Money() {
        this(0.0);
    }

    /*
     * WARNING - void declaration
     */
    public Money(long yuan, int cent) {
        this((long)var1_1, (int)var3_2, Currency.getInstance(DEFAULT_CURRENCY_CODE));
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Money(long yuan, int cent, Currency currency) {
        void var3_2;
        void var1_1;
        this.currency = currency;
        if (0L == yuan) {
            this.cent = cent;
            return;
        }
        this.cent = var1_1 * (long)this.getCentFactor() + (long)(var3_2 % this.getCentFactor());
    }

    /*
     * WARNING - void declaration
     */
    public Money(String amount) {
        this((String)var1_1, Currency.getInstance(DEFAULT_CURRENCY_CODE));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Money(String amount, Currency currency) {
        this(new BigDecimal((String)var1_1), (Currency)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Money(String amount, Currency currency, RoundingMode roundingMode) {
        this(new BigDecimal((String)var1_1), (Currency)var2_2, (RoundingMode)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Money(double amount) {
        this((double)var1_1, Currency.getInstance(DEFAULT_CURRENCY_CODE));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Money(double amount, Currency currency) {
        void var1_1;
        void var3_2;
        this.currency = var3_2;
        this.cent = Math.round((double)(var1_1 * (double)this.getCentFactor()));
    }

    /*
     * WARNING - void declaration
     */
    public Money(BigDecimal amount) {
        this((BigDecimal)var1_1, Currency.getInstance(DEFAULT_CURRENCY_CODE));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Money(BigDecimal amount, RoundingMode roundingMode) {
        this((BigDecimal)var1_1, Currency.getInstance(DEFAULT_CURRENCY_CODE), (RoundingMode)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Money(BigDecimal amount, Currency currency) {
        this((BigDecimal)var1_1, (Currency)var2_2, DEFAULT_ROUNDING_MODE);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Money(BigDecimal amount, Currency currency, RoundingMode roundingMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.currency = currency;
        this.cent = this.rounding(var1_1.movePointRight(var2_2.getDefaultFractionDigits()), (RoundingMode)var3_3);
    }

    public BigDecimal getAmount() {
        return BigDecimal.valueOf(this.cent, this.currency.getDefaultFractionDigits());
    }

    /*
     * WARNING - void declaration
     */
    public void setAmount(BigDecimal amount) {
        if (amount != null) {
            void var1_1;
            this.cent = this.rounding(var1_1.movePointRight(2), DEFAULT_ROUNDING_MODE);
        }
    }

    public long getCent() {
        return this.cent;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public int getCentFactor() {
        return CENT_FACTORS[this.currency.getDefaultFractionDigits()];
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        return other instanceof Money && this.equals((Money)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Money other) {
        void var1_1;
        return this.currency.equals(other.currency) && this.cent == var1_1.cent;
    }

    public int hashCode() {
        return (int)(this.cent ^ this.cent >>> 32);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Money other) {
        void var1_1;
        this.assertSameCurrencyAs(other);
        return Long.compare(this.cent, var1_1.cent);
    }

    /*
     * WARNING - void declaration
     */
    public boolean greaterThan(Money other) {
        void var1_1;
        return this.compareTo((Money)var1_1) > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Money add(Money other) {
        void var1_1;
        this.assertSameCurrencyAs(other);
        Money money = this;
        return money.newMoneyWithSameCurrency(money.cent + var1_1.cent);
    }

    /*
     * WARNING - void declaration
     */
    public Money addTo(Money other) {
        void var1_1;
        this.assertSameCurrencyAs(other);
        this.cent += var1_1.cent;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Money subtract(Money other) {
        void var1_1;
        this.assertSameCurrencyAs(other);
        Money money = this;
        return money.newMoneyWithSameCurrency(money.cent - var1_1.cent);
    }

    /*
     * WARNING - void declaration
     */
    public Money subtractFrom(Money other) {
        void var1_1;
        this.assertSameCurrencyAs(other);
        this.cent -= var1_1.cent;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Money multiply(long val) {
        void var1_1;
        Money money = this;
        return money.newMoneyWithSameCurrency(money.cent * var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Money multiplyBy(long val) {
        void var1_1;
        this.cent *= var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Money multiply(double val) {
        void var1_1;
        Money money = this;
        return money.newMoneyWithSameCurrency(Math.round((double)money.cent * var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Money multiplyBy(double val) {
        void var1_1;
        this.cent = Math.round((double)this.cent * var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Money multiply(BigDecimal val) {
        void var1_1;
        return this.multiply((BigDecimal)var1_1, DEFAULT_ROUNDING_MODE);
    }

    /*
     * WARNING - void declaration
     */
    public Money multiplyBy(BigDecimal val) {
        void var1_1;
        return this.multiplyBy((BigDecimal)var1_1, DEFAULT_ROUNDING_MODE);
    }

    /*
     * WARNING - void declaration
     */
    public Money multiply(BigDecimal val, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        BigDecimal newCent = BigDecimal.valueOf(this.cent).multiply(val);
        Money money = this;
        return money.newMoneyWithSameCurrency(money.rounding((BigDecimal)var1_1, (RoundingMode)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Money multiplyBy(BigDecimal val, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        BigDecimal newCent = BigDecimal.valueOf(this.cent).multiply(val);
        this.cent = this.rounding((BigDecimal)var1_1, (RoundingMode)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Money divide(double val) {
        void var1_1;
        Money money = this;
        return money.newMoneyWithSameCurrency(Math.round((double)money.cent / var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Money divideBy(double val) {
        void var1_1;
        this.cent = Math.round((double)this.cent / var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Money divide(BigDecimal val) {
        void var1_1;
        return this.divide((BigDecimal)var1_1, DEFAULT_ROUNDING_MODE);
    }

    /*
     * WARNING - void declaration
     */
    public Money divide(BigDecimal val, RoundingMode roundingMode) {
        void var1_1;
        void var2_2;
        BigDecimal newCent = BigDecimal.valueOf(this.cent).divide(val, (RoundingMode)var2_2);
        return this.newMoneyWithSameCurrency(var1_1.longValue());
    }

    /*
     * WARNING - void declaration
     */
    public Money divideBy(BigDecimal val) {
        void var1_1;
        return this.divideBy((BigDecimal)var1_1, DEFAULT_ROUNDING_MODE);
    }

    /*
     * WARNING - void declaration
     */
    public Money divideBy(BigDecimal val, RoundingMode roundingMode) {
        void var1_1;
        void var2_2;
        BigDecimal newCent = BigDecimal.valueOf(this.cent).divide(val, (RoundingMode)var2_2);
        this.cent = var1_1.longValue();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Money[] allocate(int targets) {
        void var2_2;
        int i;
        Money[] results = new Money[targets];
        Money money = this;
        Money lowResult = money.newMoneyWithSameCurrency(money.cent / (long)targets);
        Money highResult = this.newMoneyWithSameCurrency(lowResult.cent + 1L);
        int remainder = (int)this.cent % targets;
        for (i = 0; i < remainder; ++i) {
            results[i] = highResult;
        }
        for (i = remainder; i < targets; ++i) {
            results[i] = lowResult;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Money[] allocate(long[] ratios) {
        void var2_2;
        int i;
        Money[] results = new Money[ratios.length];
        long total = 0L;
        long[] lArray = ratios;
        int n = ratios.length;
        for (int j = 0; j < n; ++j) {
            long element = lArray[j];
            total += element;
        }
        long remainder = this.cent;
        for (i = 0; i < results.length; ++i) {
            Money money = this;
            results[i] = money.newMoneyWithSameCurrency(money.cent * ratios[i] / total);
            remainder -= results[i].cent;
        }
        i = 0;
        while ((long)i < remainder) {
            ++results[i].cent;
            ++i;
        }
        return var2_2;
    }

    public String toString() {
        return this.getAmount().toString();
    }

    /*
     * WARNING - void declaration
     */
    protected void assertSameCurrencyAs(Money other) {
        void var1_1;
        if (!this.currency.equals(var1_1.currency)) {
            throw new IllegalArgumentException("Money math currency mismatch.");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected long rounding(BigDecimal val, RoundingMode roundingMode) {
        void var2_2;
        return val.setScale(0, (RoundingMode)var2_2).longValue();
    }

    /*
     * WARNING - void declaration
     */
    protected Money newMoneyWithSameCurrency(long cent) {
        void var3_2;
        void var1_1;
        Money money = new Money(0.0, this.currency);
        new Money(0.0, this.currency).cent = var1_1;
        return var3_2;
    }

    public String dump() {
        return StrUtil.builder().append("cent = ").append(this.cent).append(File.separatorChar).append("currency = ").append(this.currency).toString();
    }

    /*
     * WARNING - void declaration
     */
    public void setCent(long cent) {
        void var1_1;
        this.cent = var1_1;
    }
}

