/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map.multi;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.collection.ComputeIter;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.collection.TransIter;
import cn.hutool.core.map.AbsEntry;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.multi.AbsTable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RowKeyTable<R, C, V>
extends AbsTable<R, C, V> {
    final Map<R, Map<C, V>> raw;
    final Builder<? extends Map<C, V>> columnBuilder;
    private Map<C, Map<R, V>> columnMap;
    private Set<C> columnKeySet;

    public RowKeyTable() {
        this(new HashMap());
    }

    /*
     * WARNING - void declaration
     */
    public RowKeyTable(boolean isLinked) {
        this(MapUtil.newHashMap(isLinked), () -> RowKeyTable.lambda$new$9e12e91d$1((boolean)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RowKeyTable(Map<R, Map<C, V>> raw) {
        this((Map<R, Map<C, V>>)var1_1, (Builder<Map<C, V>>)((Builder<Map>)HashMap::new));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RowKeyTable(Map<R, Map<C, V>> raw, Builder<? extends Map<C, V>> columnMapBuilder) {
        void var2_2;
        void var1_1;
        this.raw = var1_1;
        this.columnBuilder = columnMapBuilder == null ? HashMap::new : var2_2;
    }

    @Override
    public Map<R, Map<C, V>> rowMap() {
        return this.raw;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(R rowKey, C columnKey, V value) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.raw.computeIfAbsent(var1_1, key -> this.columnBuilder.build()).put(var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(R rowKey, C columnKey) {
        void var2_2;
        void var3_3;
        Map map = this.getRow(rowKey);
        if (map == null) {
            return null;
        }
        Object value = map.remove(columnKey);
        if (var3_3.isEmpty()) {
            void var1_1;
            this.raw.remove(var1_1);
        }
        return var2_2;
    }

    @Override
    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    @Override
    public void clear() {
        this.raw.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsColumn(C columnKey) {
        if (columnKey == null) {
            return false;
        }
        for (Map<C, V> map : this.raw.values()) {
            void var3_3;
            if (map == null || !var3_3.containsKey(columnKey)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<C, Map<R, V>> columnMap() {
        void var1_1;
        Map<C, Map<R, V>> result = this.columnMap;
        if (result == null) {
            this.columnMap = new ColumnMap();
            return this.columnMap;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<C> columnKeySet() {
        void var1_1;
        Set<C> result = this.columnKeySet;
        if (result == null) {
            this.columnKeySet = new ColumnKeySet();
            return this.columnKeySet;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<C> columnKeys() {
        void var2_2;
        Iterator iterator;
        Collection<Map<C, V>> values = this.raw.values();
        ArrayList result = new ArrayList(values.size() << 4);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            map.forEach((? super K key, ? super V value) -> {
                void var1_1;
                result.add(var1_1);
            });
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<R, V> getColumn(C columnKey) {
        void var1_1;
        return new Column(var1_1);
    }

    private static /* synthetic */ Map lambda$new$9e12e91d$1(boolean isLinked) {
        return MapUtil.newHashMap(isLinked);
    }

    private class Column
    extends AbstractMap<R, V> {
        final C columnKey;

        /*
         * WARNING - void declaration
         */
        Column(C columnKey) {
            void var2_2;
            this.columnKey = var2_2;
        }

        @Override
        public Set<Map.Entry<R, V>> entrySet() {
            return new EntrySet();
        }

        private class EntrySetIterator
        extends ComputeIter<Map.Entry<R, V>> {
            final Iterator<Map.Entry<R, Map<C, V>>> iterator;

            private EntrySetIterator() {
                this.iterator = RowKeyTable.this.raw.entrySet().iterator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected Map.Entry<R, V> computeNext() {
                while (this.iterator.hasNext()) {
                    void var1_1;
                    Map.Entry entry = this.iterator.next();
                    if (!entry.getValue().containsKey(Column.this.columnKey)) continue;
                    return new AbsEntry<R, V>(this, (Map.Entry)var1_1){
                        final /* synthetic */ Map.Entry val$entry;
                        final /* synthetic */ EntrySetIterator this$2;
                        {
                            void var1_1;
                            this.this$2 = var1_1;
                            this.val$entry = entry;
                        }

                        @Override
                        public R getKey() {
                            return this.val$entry.getKey();
                        }

                        @Override
                        public V getValue() {
                            return ((Map)this.val$entry.getValue()).get(this.this$2.Column.this.columnKey);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public V setValue(V value) {
                            void var1_1;
                            return ((Map)this.val$entry.getValue()).put(this.this$2.Column.this.columnKey, var1_1);
                        }
                    };
                }
                return null;
            }
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<R, V>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<R, V>> iterator() {
                return new EntrySetIterator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int size() {
                void var1_1;
                int size = 0;
                for (Map map : RowKeyTable.this.raw.values()) {
                    if (!map.containsKey(Column.this.columnKey)) continue;
                    ++size;
                }
                return (int)var1_1;
            }
        }
    }

    private class ColumnKeyIterator
    extends ComputeIter<C> {
        final Map<C, V> seen;
        final Iterator<Map<C, V>> mapIterator;
        Iterator<Map.Entry<C, V>> entryIterator;

        private ColumnKeyIterator() {
            this.seen = RowKeyTable.this.columnBuilder.build();
            this.mapIterator = RowKeyTable.this.raw.values().iterator();
            this.entryIterator = IterUtil.empty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected C computeNext() {
            while (true) {
                if (this.entryIterator.hasNext()) {
                    void var1_1;
                    Map.Entry entry = this.entryIterator.next();
                    if (this.seen.containsKey(entry.getKey())) continue;
                    this.seen.put(entry.getKey(), entry.getValue());
                    return var1_1.getKey();
                }
                if (!this.mapIterator.hasNext()) break;
                this.entryIterator = this.mapIterator.next().entrySet().iterator();
            }
            return null;
        }
    }

    private class ColumnKeySet
    extends AbstractSet<C> {
        private ColumnKeySet() {
        }

        @Override
        public Iterator<C> iterator() {
            return new ColumnKeyIterator();
        }

        @Override
        public int size() {
            return IterUtil.size(this.iterator());
        }
    }

    private class ColumnMapEntrySet
    extends AbstractSet<Map.Entry<C, Map<R, V>>> {
        private final Set<C> columnKeySet;

        private ColumnMapEntrySet() {
            this.columnKeySet = RowKeyTable.this.columnKeySet();
        }

        @Override
        public Iterator<Map.Entry<C, Map<R, V>>> iterator() {
            return new TransIter<Object, Map.Entry>(this.columnKeySet.iterator(), c -> {
                void var1_1;
                return MapUtil.entry(c, RowKeyTable.this.getColumn(var1_1));
            });
        }

        @Override
        public int size() {
            return this.columnKeySet.size();
        }
    }

    private class ColumnMap
    extends AbstractMap<C, Map<R, V>> {
        private ColumnMap() {
        }

        @Override
        public Set<Map.Entry<C, Map<R, V>>> entrySet() {
            return new ColumnMapEntrySet();
        }
    }
}

