/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map.multi;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.collection.TransIter;
import cn.hutool.core.map.multi.Table;
import cn.hutool.core.util.ObjectUtil;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbsTable<R, C, V>
implements Table<R, C, V> {
    private Collection<V> values;
    private Set<Table.Cell<R, C, V>> cellSet;

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Table) {
            void var1_1;
            Table that = (Table)obj;
            return this.cellSet().equals(var1_1.cellSet());
        }
        return false;
    }

    public int hashCode() {
        return this.cellSet().hashCode();
    }

    public String toString() {
        return this.rowMap().toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> values() {
        void var1_1;
        Collection<V> result = this.values;
        if (result == null) {
            this.values = new Values();
            return this.values;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        void var1_1;
        Set<Table.Cell<R, C, V>> result = this.cellSet;
        if (result == null) {
            this.cellSet = new CellSet();
            return this.cellSet;
        }
        return var1_1;
    }

    @Override
    public Iterator<Table.Cell<R, C, V>> iterator() {
        return new CellIterator();
    }

    private static class SimpleCell<R, C, V>
    implements Table.Cell<R, C, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final R rowKey;
        private final C columnKey;
        private final V value;

        /*
         * WARNING - void declaration
         */
        SimpleCell(R rowKey, C columnKey, V value) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.rowKey = var1_1;
            this.columnKey = var2_2;
            this.value = var3_3;
        }

        @Override
        public R getRowKey() {
            return this.rowKey;
        }

        @Override
        public C getColumnKey() {
            return this.columnKey;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Table.Cell) {
                void var1_1;
                Table.Cell other = (Table.Cell)obj;
                return ObjectUtil.equal(this.rowKey, other.getRowKey()) && ObjectUtil.equal(this.columnKey, other.getColumnKey()) && ObjectUtil.equal(this.value, var1_1.getValue());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.rowKey, this.columnKey, this.value);
        }

        public String toString() {
            return "(" + this.rowKey + "," + this.columnKey + ")=" + this.value;
        }
    }

    private class CellIterator
    implements Iterator<Table.Cell<R, C, V>> {
        final Iterator<Map.Entry<R, Map<C, V>>> rowIterator;
        Map.Entry<R, Map<C, V>> rowEntry;
        Iterator<Map.Entry<C, V>> columnIterator;

        private CellIterator() {
            this.rowIterator = AbsTable.this.rowMap().entrySet().iterator();
            this.columnIterator = IterUtil.empty();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext() || this.columnIterator.hasNext();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Table.Cell<R, C, V> next() {
            void var1_1;
            if (!this.columnIterator.hasNext()) {
                this.rowEntry = this.rowIterator.next();
                this.columnIterator = this.rowEntry.getValue().entrySet().iterator();
            }
            Map.Entry columnEntry = this.columnIterator.next();
            return new SimpleCell(this.rowEntry.getKey(), columnEntry.getKey(), var1_1.getValue());
        }

        @Override
        public void remove() {
            this.columnIterator.remove();
            if (this.rowEntry.getValue().isEmpty()) {
                this.rowIterator.remove();
            }
        }
    }

    private class CellSet
    extends AbstractSet<Table.Cell<R, C, V>> {
        private CellSet() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            Table.Cell cell;
            Map row;
            if (o instanceof Table.Cell && (row = AbsTable.this.getRow((cell = (Table.Cell)o).getRowKey())) != null) {
                void var1_1;
                void var2_2;
                return ObjectUtil.equals(var2_2.get(cell.getColumnKey()), var1_1.getValue());
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                void var1_1;
                Table.Cell cell = (Table.Cell)o;
                AbsTable.this.remove(cell.getRowKey(), var1_1.getColumnKey());
            }
            return false;
        }

        @Override
        public void clear() {
            AbsTable.this.clear();
        }

        @Override
        public Iterator<Table.Cell<R, C, V>> iterator() {
            return new CellIterator();
        }

        @Override
        public int size() {
            return AbsTable.this.size();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new TransIter<Table.Cell, Object>(AbsTable.this.cellSet().iterator(), Table.Cell::getValue);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return AbsTable.this.containsValue(var1_1);
        }

        @Override
        public void clear() {
            AbsTable.this.clear();
        }

        @Override
        public int size() {
            return AbsTable.this.size();
        }
    }
}

