/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class TableMap<K, V>
implements Serializable,
Iterable<Map.Entry<K, V>>,
Map<K, V> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_CAPACITY = 10;
    private final List<K> keys;
    private final List<V> values;

    public TableMap() {
        this(10);
    }

    /*
     * WARNING - void declaration
     */
    public TableMap(int size) {
        void var1_1;
        this.keys = new ArrayList<K>(size);
        this.values = new ArrayList<V>((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public TableMap(K[] keys, V[] values) {
        void var2_2;
        void var1_1;
        this.keys = CollUtil.toList(var1_1);
        this.values = CollUtil.toList(var2_2);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return CollUtil.isEmpty(this.keys);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.keys.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        return this.values.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object key) {
        int index = this.keys.indexOf(key);
        if (index >= 0) {
            void var1_2;
            return this.values.get((int)var1_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public K getKey(V value) {
        int index = this.values.indexOf(value);
        if (index >= 0) {
            void var1_2;
            return this.keys.get((int)var1_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<V> getValues(K key) {
        void var1_1;
        return CollUtil.getAny(this.values, ListUtil.indexOfAll(this.keys, ele -> {
            Object object;
            return ObjectUtil.equal(ele, object);
        }));
    }

    /*
     * WARNING - void declaration
     */
    public List<K> getKeys(V value) {
        void var1_1;
        return CollUtil.getAny(this.keys, ListUtil.indexOfAll(this.values, ele -> {
            Object object;
            return ObjectUtil.equal(ele, object);
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(K key, V value) {
        void var2_2;
        void var1_1;
        this.keys.add(var1_1);
        this.values.add(var2_2);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object key) {
        void var2_2;
        int index;
        Object lastValue = null;
        while ((index = this.keys.indexOf(key)) >= 0) {
            void var3_3;
            lastValue = this.removeByIndex((int)var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public V removeByIndex(int index) {
        void var1_1;
        this.keys.remove(index);
        return this.values.remove((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            void var2_2;
            this.put(entry.getKey(), var2_2.getValue());
        }
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public Set<K> keySet() {
        return new HashSet<K>(this.keys);
    }

    public List<K> keys() {
        return Collections.unmodifiableList(this.keys);
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableList(this.values);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        void var1_1;
        LinkedHashSet<Map.Entry<K, V>> hashSet = new LinkedHashSet<Map.Entry<K, V>>();
        for (int i = 0; i < this.size(); ++i) {
            hashSet.add(MapUtil.entry(this.keys.get(i), this.values.get(i)));
        }
        return var1_1;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new Iterator<Map.Entry<K, V>>(this){
            private final Iterator<K> keysIter;
            private final Iterator<V> valuesIter;
            final /* synthetic */ TableMap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.keysIter = this.this$0.keys.iterator();
                this.valuesIter = this.this$0.values.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.keysIter.hasNext() && this.valuesIter.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                return MapUtil.entry(this.keysIter.next(), this.valuesIter.next());
            }

            @Override
            public void remove() {
                this.keysIter.remove();
                this.valuesIter.remove();
            }
        };
    }

    public String toString() {
        return "TableMap{keys=" + this.keys + ", values=" + this.values + '}';
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (int i = 0; i < this.size(); ++i) {
            action.accept(this.keys.get(i), this.values.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object key, Object value) {
        void var3_3;
        boolean removed = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!ObjUtil.equals(key, this.keys.get(i)) || !ObjUtil.equals(value, this.values.get(i))) continue;
            this.removeByIndex(i);
            removed = true;
            --i;
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        for (int i = 0; i < this.size(); ++i) {
            void var3_3;
            V newValue = function.apply(this.keys.get(i), this.values.get(i));
            this.values.set(i, var3_3);
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        for (int i = 0; i < this.size(); ++i) {
            if (!ObjUtil.equals(key, this.keys.get(i)) || !ObjUtil.equals(oldValue, this.values.get(i))) continue;
            this.values.set(i, newValue);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V replace(K key, V value) {
        void var3_3;
        Object lastValue = null;
        for (int i = 0; i < this.size(); ++i) {
            if (!ObjUtil.equals(key, this.keys.get(i))) continue;
            lastValue = this.values.set(i, value);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        void var3_3;
        if (remappingFunction == null) {
            return null;
        }
        Object lastValue = null;
        for (int i = 0; i < this.size(); ++i) {
            if (!ObjUtil.equals(key, this.keys.get(i))) continue;
            V newValue = remappingFunction.apply(key, this.values.get(i));
            if (newValue != null) {
                lastValue = this.values.set(i, newValue);
                continue;
            }
            this.removeByIndex(i);
            --i;
        }
        return var3_3;
    }
}

