/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReferenceUtil;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReferenceConcurrentMap<K, V>
implements Serializable,
Iterable<Map.Entry<K, V>>,
ConcurrentMap<K, V> {
    final ConcurrentMap<Reference<K>, V> raw;
    private final ReferenceQueue<K> lastQueue;
    private final ReferenceUtil.ReferenceType keyType;
    private BiConsumer<Reference<? extends K>, V> purgeListener;

    /*
     * WARNING - void declaration
     */
    public ReferenceConcurrentMap(ConcurrentMap<Reference<K>, V> raw, ReferenceUtil.ReferenceType referenceType) {
        void var2_2;
        void var1_1;
        this.raw = var1_1;
        this.keyType = var2_2;
        this.lastQueue = new ReferenceQueue();
    }

    /*
     * WARNING - void declaration
     */
    public void setPurgeListener(BiConsumer<Reference<? extends K>, V> purgeListener) {
        void var1_1;
        this.purgeListener = var1_1;
    }

    @Override
    public int size() {
        this.purgeStaleKeys();
        return this.raw.size();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object key) {
        void var1_1;
        this.purgeStaleKeys();
        return this.raw.get(this.ofKey(var1_1, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        this.purgeStaleKeys();
        return this.raw.containsKey(this.ofKey(var1_1, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        this.purgeStaleKeys();
        return this.raw.containsValue(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(K key, V value) {
        void var2_2;
        void var1_1;
        this.purgeStaleKeys();
        return this.raw.put(this.ofKey(var1_1, this.lastQueue), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V putIfAbsent(K key, V value) {
        void var2_2;
        void var1_1;
        this.purgeStaleKeys();
        return this.raw.putIfAbsent(this.ofKey(var1_1, this.lastQueue), var2_2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V replace(K key, V value) {
        void var2_2;
        void var1_1;
        this.purgeStaleKeys();
        return this.raw.replace(this.ofKey(var1_1, this.lastQueue), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.purgeStaleKeys();
        return this.raw.replace(this.ofKey(var1_1, this.lastQueue), var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        void var1_1;
        this.purgeStaleKeys();
        this.raw.replaceAll((arg_0, arg_1) -> ReferenceConcurrentMap.lambda$replaceAll$0((BiFunction)var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        void var1_1;
        void var2_2;
        this.purgeStaleKeys();
        return (V)this.raw.computeIfAbsent(this.ofKey(key, this.lastQueue), arg_0 -> ReferenceConcurrentMap.lambda$computeIfAbsent$1((Function)var2_2, var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        void var1_1;
        void var2_2;
        this.purgeStaleKeys();
        return (V)this.raw.computeIfPresent(this.ofKey(key, this.lastQueue), (arg_0, arg_1) -> ReferenceConcurrentMap.lambda$computeIfPresent$2((BiFunction)var2_2, var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public V computeIfAbsent(K key, Func0<? extends V> supplier) {
        void var2_2;
        void var1_1;
        return (V)this.computeIfAbsent(var1_1, arg_0 -> ReferenceConcurrentMap.lambda$computeIfAbsent$3((Func0)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object key) {
        void var1_1;
        this.purgeStaleKeys();
        return this.raw.remove(this.ofKey(var1_1, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object key, Object value) {
        void var2_2;
        void var1_1;
        this.purgeStaleKeys();
        return this.raw.remove(this.ofKey(var1_1, null), var2_2);
    }

    @Override
    public void clear() {
        this.raw.clear();
        while (this.lastQueue.poll() != null) {
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<K> keySet() {
        void var1_1;
        this.purgeStaleKeys();
        Collection<Object> trans = CollUtil.trans(this.raw.keySet(), reference -> {
            Reference reference2;
            if (reference == null) {
                return null;
            }
            return reference2.get();
        });
        return new HashSet(var1_1);
    }

    @Override
    public Collection<V> values() {
        this.purgeStaleKeys();
        return this.raw.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.purgeStaleKeys();
        return this.raw.entrySet().stream().map(entry -> {
            Map.Entry entry2;
            return new AbstractMap.SimpleImmutableEntry(((Reference)entry.getKey()).get(), entry2.getValue());
        }).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        void var1_1;
        this.purgeStaleKeys();
        this.raw.forEach((arg_0, arg_1) -> ReferenceConcurrentMap.lambda$forEach$6((BiConsumer)var1_1, arg_0, arg_1));
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySet().iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        void var1_1;
        void var2_2;
        this.purgeStaleKeys();
        return (V)this.raw.compute(this.ofKey(key, this.lastQueue), (arg_0, arg_1) -> ReferenceConcurrentMap.lambda$compute$7((BiFunction)var2_2, var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.purgeStaleKeys();
        return this.raw.merge((Reference<Reference<void>>)this.ofKey(var1_1, this.lastQueue), var2_2, (BiFunction<void, void, void>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void purgeStaleKeys() {
        Reference<K> reference;
        while ((reference = this.lastQueue.poll()) != null) {
            void var2_2;
            void var1_1;
            Object value = this.raw.remove(reference);
            if (this.purgeListener == null) continue;
            this.purgeListener.accept((Reference<K>)var1_1, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Reference<K> ofKey(K key, ReferenceQueue<? super K> queue) {
        switch (this.keyType) {
            case WEAK: {
                return new WeakKey<K>(key, queue);
            }
            case SOFT: {
                void var2_2;
                void var1_1;
                return new SoftKey<void>(var1_1, (ReferenceQueue<void>)var2_2);
            }
        }
        throw new IllegalArgumentException("Unsupported key type: " + (Object)((Object)this.keyType));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$compute$7(BiFunction remappingFunction, Object key, Reference kWeakKey, Object value) {
        void var3_3;
        void var1_1;
        return remappingFunction.apply(var1_1, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$forEach$6(BiConsumer action, Reference key, Object value) {
        void var2_2;
        void var1_1;
        action.accept(var1_1.get(), var2_2);
    }

    private static /* synthetic */ Object lambda$computeIfAbsent$3(Func0 supplier, Object keyParam) {
        return supplier.callWithRuntimeException();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$computeIfPresent$2(BiFunction remappingFunction, Object key, Reference kWeakKey, Object value) {
        void var3_3;
        void var1_1;
        return remappingFunction.apply(var1_1, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$computeIfAbsent$1(Function mappingFunction, Object key, Reference kWeakKey) {
        void var1_1;
        return mappingFunction.apply(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$replaceAll$0(BiFunction function, Reference kWeakKey, Object value) {
        void var2_2;
        void var1_1;
        return function.apply(var1_1.get(), var2_2);
    }

    private static class SoftKey<K>
    extends SoftReference<K> {
        private final int hashCode;

        /*
         * WARNING - void declaration
         */
        SoftKey(K key, ReferenceQueue<? super K> queue) {
            super(key, var2_2);
            void var1_1;
            void var2_2;
            this.hashCode = var1_1.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof SoftKey) {
                void var1_1;
                return ObjectUtil.equals(((SoftKey)var1_1).get(), this.get());
            }
            return false;
        }
    }

    private static class WeakKey<K>
    extends WeakReference<K> {
        private final int hashCode;

        /*
         * WARNING - void declaration
         */
        WeakKey(K key, ReferenceQueue<? super K> queue) {
            super(key, var2_2);
            void var1_1;
            void var2_2;
            this.hashCode = var1_1.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof WeakKey) {
                void var1_1;
                return ObjectUtil.equals(((WeakKey)var1_1).get(), this.get());
            }
            return false;
        }
    }
}

