/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.map.CamelCaseLinkedMap;
import cn.hutool.core.map.CamelCaseMap;
import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.map.MapProxy;
import cn.hutool.core.map.MapWrapper;
import cn.hutool.core.stream.CollectorUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.JdkUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MapUtil {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        Map<?, ?> map2;
        return map == null || map2.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        Map<?, ?> map2;
        return map != null && false == map2.isEmpty();
    }

    public static <K, V> Map<K, V> emptyIfNull(Map<K, V> set) {
        Map<K, V> map;
        if (set == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Map<K, V>, K, V> T defaultIfEmpty(T map, T defaultMap) {
        T t;
        if (MapUtil.isEmpty(map)) {
            void var1_1;
            return var1_1;
        }
        return t;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isLinked) {
        int n;
        void var1_1;
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        if (var1_1 != false) {
            return new LinkedHashMap(initialCapacity);
        }
        return new HashMap(n);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtil.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isLinked) {
        boolean bl;
        return MapUtil.newHashMap(16, bl);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        Comparator<? super K> comparator2;
        return new TreeMap(comparator2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map, Comparator<? super K> comparator) {
        void var1_1;
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        if (!MapUtil.isEmpty(map)) {
            Map<K, V> map2;
            treeMap.putAll(map2);
        }
        return var1_1;
    }

    public static <K, V> Map<K, V> newIdentityMap(int size) {
        int n;
        return new IdentityHashMap(n);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap(16);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int size) {
        int n;
        int initCapacity;
        initCapacity = size <= 0 ? 16 : initCapacity;
        return new ConcurrentHashMap(n);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<K, V> map) {
        Map<K, V> map2;
        if (MapUtil.isEmpty(map)) {
            return new ConcurrentHashMap(16);
        }
        return new ConcurrentHashMap<K, V>(map2);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        if (mapType == null || mapType.isAssignableFrom(AbstractMap.class)) {
            return new HashMap();
        }
        try {
            Class<?> clazz;
            return (Map)ReflectUtil.newInstance(clazz, new Object[0]);
        }
        catch (UtilException utilException) {
            return new HashMap();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> HashMap<K, V> of(K key, V value) {
        void var1_1;
        return MapUtil.of(key, var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> HashMap<K, V> of(K key, V value, boolean isOrder) {
        void var2_3;
        void var1_1;
        K k;
        HashMap<K, void> map = MapUtil.newHashMap(isOrder);
        map.put(k, var1_1);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @Deprecated
    public static <K, V> Map<K, V> of(Pair<K, V> ... pairs) {
        void var1_1;
        Pair<K, V>[] pairArray;
        HashMap<K, V> map = new HashMap<K, V>();
        for (Pair<K, V> pair : pairArray) {
            map.put(pair.getKey(), pair.getValue());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <K, V> Map<K, V> ofEntries(Map.Entry<K, V> ... entries) {
        void var1_1;
        Map.Entry<K, V>[] entryArray;
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> pair : entryArray) {
            map.put(pair.getKey(), pair.getValue());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static HashMap<Object, Object> of(Object[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            void var3_3;
            Object value;
            Object key;
            Iterator iter;
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry instanceof Object[]) {
                if ((entry = (Object[])entry).length <= 1) continue;
                map.put(entry[0], entry[1]);
                continue;
            }
            if (entry instanceof Iterable) {
                iter = ((Iterable)entry).iterator();
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            if (value instanceof Iterator) {
                iter = (Iterator)value;
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, var3_3);
                continue;
            }
            throw new IllegalArgumentException(StrUtil.format("Array element {}, '{}', is not type of Map.Entry or Array or Iterable or Iterator", i, var3_3));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList222) {
        void var1_6;
        HashMap<void, ArrayList<Object>> resultMap = new HashMap<void, ArrayList<Object>>();
        if (CollUtil.isEmpty(mapList222)) {
            return resultMap;
        }
        for (Map mapList222 : mapList222) {
            Set mapList222 = mapList222.entrySet();
            for (Map.Entry entry : mapList222) {
                void var3_8;
                Object key = entry.getKey();
                ArrayList<Object> valueList = (ArrayList<Object>)resultMap.get(key);
                if (valueList == null) {
                    void var0_5;
                    valueList = CollUtil.newArrayList(entry.getValue());
                    resultMap.put(var0_5, valueList);
                    continue;
                }
                var3_8.add(entry.getValue());
            }
        }
        return var1_6;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        void var1_1;
        void var2_3;
        ArrayList<Map<K, V>> resultList = new ArrayList<Map<K, V>>();
        if (MapUtil.isEmpty(listMap)) {
            return resultList;
        }
        int index = 0;
        do {
            boolean isEnd = true;
            HashMap map = new HashMap();
            for (Map.Entry<K, Iterable<V>> entry : listMap.entrySet()) {
                ArrayList<V> vList = CollUtil.newArrayList(entry.getValue());
                int vListSize = vList.size();
                if (index >= vListSize) continue;
                map.put(entry.getKey(), vList.get(index));
                if (index == vListSize - 1) continue;
                isEnd = false;
            }
            if (!map.isEmpty()) {
                resultList.add(map);
            }
            ++index;
        } while (var2_3 == false);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, List<V>> grouping(Iterable<Map.Entry<K, V>> entries) {
        void var1_1;
        Iterator<Map.Entry<K, V>> iterator;
        HashMap<Object, List> map = new HashMap<Object, List>();
        if (CollUtil.isEmpty(entries)) {
            return map;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Map.Entry pair = (Map.Entry)iterator.next();
            List list = map.computeIfAbsent(pair.getKey(), k -> new ArrayList());
            list.add(var2_2.getValue());
        }
        return var1_1;
    }

    public static <K, V> Map<K, V> toCamelCaseMap(Map<K, V> map) {
        Map<K, V> map2;
        if (map instanceof LinkedHashMap) {
            return new CamelCaseLinkedMap<K, V>(map);
        }
        return new CamelCaseMap<K, V>(map2);
    }

    /*
     * WARNING - void declaration
     */
    public static Object[][] toObjectArray(Map<?, ?> map) {
        void var1_1;
        Object object;
        if (map == null) {
            return null;
        }
        Object[][] result = new Object[map.size()][2];
        if (map.isEmpty()) {
            return result;
        }
        int index = 0;
        for (Map.Entry entry : object.entrySet()) {
            result[index][0] = entry.getKey();
            result[index][1] = entry.getValue();
            ++index;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, String ... otherParams) {
        void var3_3;
        void var2_2;
        void var1_1;
        return MapUtil.join(map, (String)var1_1, (String)var2_2, false, (String[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static String sortJoin(Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        void var3_3;
        void var2_2;
        void var1_1;
        return MapUtil.join(MapUtil.sort(params), (String)var1_1, (String)var2_2, (boolean)var3_3, otherParams);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> String joinIgnoreNull(Map<K, V> map, String separator, String keyValueSeparator, String ... otherParams) {
        void var3_3;
        void var2_2;
        void var1_1;
        return MapUtil.join(map, (String)var1_1, (String)var2_2, true, (String[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        String[] stringArray;
        StringBuilder strBuilder = StrUtil.builder();
        boolean isFirst = true;
        if (MapUtil.isNotEmpty(map)) {
            for (Map.Entry entry : stringArray.entrySet()) {
                if (isIgnoreNull && (entry.getKey() == null || entry.getValue() == null)) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    strBuilder.append(separator);
                }
                strBuilder.append(Convert.toStr(entry.getKey())).append(keyValueSeparator).append(Convert.toStr(entry.getValue()));
            }
        }
        if (ArrayUtil.isNotEmpty(otherParams)) {
            stringArray = otherParams;
            int n = otherParams.length;
            for (int i = 0; i < n; ++i) {
                void var2_3;
                String otherParam = stringArray[i];
                strBuilder.append((String)var2_3);
            }
        }
        return strBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> edit(Map<K, V> map, Editor<Map.Entry<K, V>> editor) {
        void var2_2;
        if (map == null || editor == null) {
            return map;
        }
        HashMap map2 = (HashMap)ReflectUtil.newInstanceIfPossible(map.getClass());
        if (map2 == null) {
            map2 = new HashMap(map.size(), 1.0f);
        }
        if (MapUtil.isEmpty(map)) {
            return map2;
        }
        if (!map2.isEmpty()) {
            map2.clear();
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Map.Entry<K, V> entry2;
            Map.Entry<K, V> modified = (Map.Entry)editor.edit(entry);
            if (modified == null) continue;
            map2.put(modified.getKey(), entry2.getValue());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> filter(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        void var1_1;
        Map<K, V> map2;
        if (map == null || filter == null) {
            return map;
        }
        return MapUtil.edit(map2, arg_0 -> MapUtil.lambda$filter$1((Filter)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V, R> Map<K, R> map(Map<K, V> map, BiFunction<K, V, R> biFunction) {
        void var1_1;
        Map<K, V> map2;
        if (map == null || biFunction == null) {
            return MapUtil.newHashMap();
        }
        return map2.entrySet().stream().collect(CollectorUtil.toMap(Map.Entry::getKey, arg_0 -> MapUtil.lambda$map$2((BiFunction)var1_1, arg_0), (l, r) -> l));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> filter(Map<K, V> map, K ... keys) {
        void var2_2;
        void var1_1;
        if (map == null || keys == null) {
            return map;
        }
        HashMap<void, V> map2 = (HashMap<void, V>)ReflectUtil.newInstanceIfPossible(map.getClass());
        if (map2 == null) {
            map2 = new HashMap<void, V>(map.size(), 1.0f);
        }
        if (MapUtil.isEmpty(map)) {
            return map2;
        }
        if (!map2.isEmpty()) {
            map2.clear();
        }
        for (void key : var1_1) {
            if (!map.containsKey(key)) continue;
            map2.put(key, map.get(key));
        }
        return var2_2;
    }

    public static <T> Map<T, T> reverse(Map<T, T> map) {
        return MapUtil.edit(map, t -> {
            Map.Entry entry;
            return new Map.Entry<T, T>(){

                @Override
                public final T getKey() {
                    return entry.getValue();
                }

                @Override
                public final T getValue() {
                    return entry.getKey();
                }

                @Override
                public final T setValue(T value) {
                    throw new UnsupportedOperationException("Unsupported setValue method !");
                }
            };
        });
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<V, K> inverse(Map<K, V> map) {
        void var1_1;
        Map<Object, Object> map2;
        Map result = MapUtil.createMap(map.getClass());
        map2.forEach((key, value) -> {
            void var1_1;
            void var2_2;
            result.put(var2_2, var1_1);
        });
        return var1_1;
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map) {
        return MapUtil.sort(map, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        void var1_1;
        Map<K, V> map2;
        if (map == null) {
            return null;
        }
        if (map instanceof TreeMap) {
            TreeMap result = (TreeMap)map;
            if (comparator == null || comparator.equals(result.comparator())) {
                void var2_2;
                return var2_2;
            }
        }
        return MapUtil.newTreeMap(map2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, boolean isDesc) {
        void var2_2;
        void var3_3;
        Map<K, V> map2;
        void var1_1;
        LinkedHashMap result = new LinkedHashMap();
        Comparator entryComparator = Map.Entry.comparingByValue();
        if (var1_1 != false) {
            entryComparator = entryComparator.reversed();
        }
        map2.entrySet().stream().sorted(var3_3).forEachOrdered(e -> {
            void var1_1;
            Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), var1_1.getValue());
        });
        return var2_2;
    }

    public static MapProxy createProxy(Map<?, ?> map) {
        return MapProxy.create(map);
    }

    public static <K, V> MapWrapper<K, V> wrap(Map<K, V> map) {
        Map<K, V> map2;
        return new MapWrapper<K, V>(map2);
    }

    public static <K, V> Map<K, V> unmodifiable(Map<K, V> map) {
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> MapBuilder<K, V> builder() {
        return MapUtil.builder(new HashMap());
    }

    public static <K, V> MapBuilder<K, V> builder(Map<K, V> map) {
        Map<K, V> map2;
        return new MapBuilder<K, V>(map2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> MapBuilder<K, V> builder(K k, V v) {
        void var1_1;
        K k2;
        return MapUtil.builder(new HashMap()).put(k2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> getAny(Map<K, V> map, K ... keys) {
        void var1_1;
        return MapUtil.filter(map, arg_0 -> MapUtil.lambda$getAny$7((Object[])var1_1, arg_0));
    }

    public static <K, V> Map<K, V> removeAny(Map<K, V> map, K ... keys) {
        Map<K, V> map2;
        K[] KArray = keys;
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            K key = KArray[i];
            map.remove(key);
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    public static String getStr(Map<?, ?> map, Object key) {
        void var1_1;
        return MapUtil.get(map, (Object)var1_1, String.class);
    }

    /*
     * WARNING - void declaration
     */
    public static String getStr(Map<?, ?> map, Object key, String defaultValue) {
        void var2_2;
        void var1_1;
        return (String)MapUtil.get(map, (Object)var1_1, String.class, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Integer getInt(Map<?, ?> map, Object key) {
        void var1_1;
        return MapUtil.get(map, (Object)var1_1, Integer.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Integer getInt(Map<?, ?> map, Object key, Integer defaultValue) {
        void var2_2;
        void var1_1;
        return (Integer)MapUtil.get(map, (Object)var1_1, Integer.class, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Double getDouble(Map<?, ?> map, Object key) {
        void var1_1;
        return MapUtil.get(map, (Object)var1_1, Double.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Double getDouble(Map<?, ?> map, Object key, Double defaultValue) {
        void var2_2;
        void var1_1;
        return (Double)MapUtil.get(map, (Object)var1_1, Double.class, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Float getFloat(Map<?, ?> map, Object key) {
        void var1_1;
        return MapUtil.get(map, (Object)var1_1, Float.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Float getFloat(Map<?, ?> map, Object key, Float defaultValue) {
        void var2_2;
        void var1_1;
        return (Float)MapUtil.get(map, (Object)var1_1, Float.class, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Short getShort(Map<?, ?> map, Object key) {
        void var1_1;
        return MapUtil.get(map, (Object)var1_1, Short.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Short getShort(Map<?, ?> map, Object key, Short defaultValue) {
        void var2_2;
        void var1_1;
        return (Short)MapUtil.get(map, (Object)var1_1, Short.class, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean getBool(Map<?, ?> map, Object key) {
        void var1_1;
        return MapUtil.get(map, (Object)var1_1, Boolean.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean getBool(Map<?, ?> map, Object key, Boolean defaultValue) {
        void var2_2;
        void var1_1;
        return (Boolean)MapUtil.get(map, (Object)var1_1, Boolean.class, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Character getChar(Map<?, ?> map, Object key) {
        void var1_1;
        return MapUtil.get(map, (Object)var1_1, Character.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Character getChar(Map<?, ?> map, Object key, Character defaultValue) {
        void var2_2;
        void var1_1;
        return (Character)MapUtil.get(map, (Object)var1_1, Character.class, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Long getLong(Map<?, ?> map, Object key) {
        void var1_1;
        return MapUtil.get(map, (Object)var1_1, Long.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Long getLong(Map<?, ?> map, Object key, Long defaultValue) {
        void var2_2;
        void var1_1;
        return (Long)MapUtil.get(map, (Object)var1_1, Long.class, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Date getDate(Map<?, ?> map, Object key) {
        void var1_1;
        return MapUtil.get(map, (Object)var1_1, Date.class);
    }

    /*
     * WARNING - void declaration
     */
    public static Date getDate(Map<?, ?> map, Object key, Date defaultValue) {
        void var2_2;
        void var1_1;
        return (Date)MapUtil.get(map, (Object)var1_1, Date.class, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(Map<?, ?> map, Object key, Class<T> type) {
        void var2_2;
        void var1_1;
        return MapUtil.get(map, (Object)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(Map<?, ?> map, Object key, Class<T> type, T defaultValue) {
        void var3_3;
        void var1_1;
        Map<?, ?> map2;
        void var2_2;
        if (map == null) {
            return defaultValue;
        }
        return Convert.convert(var2_2, map2.get(var1_1), var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getQuietly(Map<?, ?> map, Object key, Class<T> type, T defaultValue) {
        void var3_3;
        void var1_1;
        Map<?, ?> map2;
        void var2_2;
        if (map == null) {
            return defaultValue;
        }
        return Convert.convertQuietly((Type)var2_2, map2.get(var1_1), var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(Map<?, ?> map, Object key, TypeReference<T> type) {
        void var2_2;
        void var1_1;
        return MapUtil.get(map, (Object)var1_1, var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(Map<?, ?> map, Object key, TypeReference<T> type, T defaultValue) {
        void var3_3;
        void var1_1;
        Map<?, ?> map2;
        void var2_2;
        if (map == null) {
            return defaultValue;
        }
        return Convert.convert((Type)var2_2, map2.get(var1_1), var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getQuietly(Map<?, ?> map, Object key, TypeReference<T> type, T defaultValue) {
        void var3_3;
        void var1_1;
        Map<?, ?> map2;
        void var2_2;
        if (map == null) {
            return defaultValue;
        }
        return Convert.convertQuietly((Type)var2_2, map2.get(var1_1), var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> renameKey(Map<K, V> map, K oldKey, K newKey) {
        Map<K, V> map2;
        if (MapUtil.isNotEmpty(map) && map.containsKey(oldKey)) {
            void var1_1;
            void var2_2;
            if (map.containsKey(newKey)) {
                throw new IllegalArgumentException(StrUtil.format("The key '{}' exist !", newKey));
            }
            map.put(var2_2, map.remove(var1_1));
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> removeNullValue(Map<K, V> map) {
        Map<K, V> map2;
        if (MapUtil.isEmpty(map)) {
            return map;
        }
        Iterator<Map.Entry<K, V>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            void var2_2;
            Map.Entry<K, V> entry = iter.next();
            if (null != var2_2.getValue()) continue;
            iter.remove();
        }
        return map2;
    }

    public static <K, V> Map<K, V> empty() {
        return Collections.emptyMap();
    }

    public static <K, V, T extends Map<K, V>> T empty(Class<?> mapClass) {
        Class<?> clazz;
        if (mapClass == null) {
            return (T)Collections.emptyMap();
        }
        if (NavigableMap.class == mapClass) {
            return (T)Collections.emptyNavigableMap();
        }
        if (SortedMap.class == mapClass) {
            return (T)Collections.emptySortedMap();
        }
        if (Map.class == mapClass) {
            return (T)Collections.emptyMap();
        }
        throw new IllegalArgumentException(StrUtil.format("[{}] is not support to get empty!", clazz));
    }

    /*
     * WARNING - void declaration
     */
    public static void clear(Map<?, ?> ... maps) {
        Map<?, ?>[] mapArray = maps;
        int n = maps.length;
        for (int i = 0; i < n; ++i) {
            void var3_3;
            Map<?, ?> map = mapArray[i];
            if (!MapUtil.isNotEmpty(map)) continue;
            var3_3.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterator<K> keys) {
        void var2_2;
        ArrayList<V> values = new ArrayList<V>();
        while (keys.hasNext()) {
            values.add(map.get(keys.next()));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        void var1_1;
        return MapUtil.entry(key, var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map.Entry<K, V> entry(K key, V value, boolean isImmutable) {
        void var1_1;
        K k;
        if (isImmutable) {
            return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
        }
        return new AbstractMap.SimpleEntry<K, void>(k, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        void var2_2;
        void var1_1;
        Map<void, V> map2;
        if (JdkUtil.IS_JDK8) {
            return MapUtil.computeIfAbsentForJdk8(map, key, mappingFunction);
        }
        return map2.computeIfAbsent(var1_1, (Function<void, V>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> V computeIfAbsentForJdk8(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        void var3_3;
        void var2_2;
        void var1_1;
        Map<K, V> res;
        Object value = map.get(key);
        if (value == null && (res = map.putIfAbsent(var1_1, value = var2_2.apply(key))) != null) {
            Map<K, V> map2;
            return (V)map2;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> List<Map<K, V>> partition(Map<K, V> map, int size) {
        void var2_2;
        Assert.notNull(map);
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be greater than 0");
        }
        ArrayList<void> list = new ArrayList<void>();
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void var3_3;
            HashMap subMap = new HashMap(size);
            for (int i = 0; i < size && iterator.hasNext(); ++i) {
                Map.Entry entry = (Map.Entry)iterator.next();
                subMap.put(entry.getKey(), entry.getValue());
            }
            list.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getAny$7(Object[] keys, Map.Entry entry) {
        void var1_1;
        return ArrayUtil.contains(keys, var1_1.getKey());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$map$2(BiFunction biFunction, Map.Entry m) {
        void var1_1;
        return biFunction.apply(m.getKey(), var1_1.getValue());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Map.Entry lambda$filter$1(Filter filter, Map.Entry t) {
        if (filter.accept(t)) {
            void var1_1;
            return var1_1;
        }
        return null;
    }
}

