/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.ForestMap;
import cn.hutool.core.map.TreeEntry;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class LinkedForestMap<K, V>
implements ForestMap<K, V> {
    private final Map<K, TreeEntryNode<K, V>> nodes;
    private final boolean allowOverrideParent;

    /*
     * WARNING - void declaration
     */
    public LinkedForestMap(boolean allowOverrideParent) {
        void var1_1;
        this.allowOverrideParent = var1_1;
        this.nodes = new LinkedHashMap<K, TreeEntryNode<K, V>>();
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.nodes.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        return this.nodes.containsValue(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TreeEntry<K, V> get(Object key) {
        void var1_1;
        return this.nodes.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TreeEntry<K, V> remove(Object key) {
        void var1_1;
        TreeEntryNode<K, V> target = this.nodes.remove(key);
        if (ObjectUtil.isNull(target)) {
            return null;
        }
        if (target.hasParent()) {
            void var2_2;
            void var3_3;
            TreeEntry parent = target.getDeclaredParent();
            Map<K, TreeEntry<K, V>> targetChildren = target.getChildren();
            ((TreeEntryNode)parent).removeDeclaredChild(target.getKey());
            target.clear();
            var3_3.forEach((arg_0, arg_1) -> LinkedForestMap.lambda$remove$0((TreeEntryNode)var2_2, arg_0, arg_1));
        }
        return var1_1;
    }

    @Override
    public void clear() {
        this.nodes.values().forEach(TreeEntryNode::clear);
        this.nodes.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.nodes.keySet();
    }

    @Override
    public Collection<TreeEntry<K, V>> values() {
        return new ArrayList<TreeEntry<K, V>>(this.nodes.values());
    }

    @Override
    public Set<Map.Entry<K, TreeEntry<K, V>>> entrySet() {
        return this.nodes.entrySet().stream().map(this::wrap).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    private Map.Entry<K, TreeEntry<K, V>> wrap(Map.Entry<K, TreeEntryNode<K, V>> nodeEntry) {
        void var1_1;
        return new EntryNodeWrapper((TreeEntry)var1_1.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TreeEntryNode<K, V> putNode(K key, V value) {
        void var3_3;
        void var2_2;
        void var1_1;
        TreeEntryNode<Object, Object> target = this.nodes.get(key);
        if (ObjectUtil.isNotNull(target)) {
            V oldVal = target.getValue();
            target.setValue(value);
            return target.copy(var1_1);
        }
        target = new TreeEntryNode<void, void>(null, var1_1, var2_2);
        this.nodes.put(var1_1, (TreeEntryNode<void, void>)var3_3);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putLinkedNodes(K parentKey, V parentValue, K childKey, V childValue) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.linkNodes(var1_1, var3_3, (parent, child) -> {
            void var1_1;
            void var3_3;
            Object object;
            parent.setValue(object);
            var3_3.setValue(var1_1);
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putLinkedNodes(K parentKey, K childKey, V childValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.linkNodes(var1_1, var2_2, (parent, child) -> {
            Object object;
            child.setValue(object);
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void linkNodes(K parentKey, K childKey, BiConsumer<TreeEntry<K, V>, TreeEntry<K, V>> consumer) {
        void var3_3;
        consumer = ObjectUtil.defaultIfNull(consumer, (parent, child) -> {});
        TreeEntryNode parentNode = this.nodes.computeIfAbsent(parentKey, t -> {
            Object object;
            return new TreeEntryNode(null, object);
        });
        TreeEntryNode<K, V> childNode = this.nodes.get(childKey);
        if (ObjectUtil.isNull(childNode)) {
            void var2_2;
            childNode = new TreeEntryNode(parentNode, childKey);
            consumer.accept(parentNode, childNode);
            this.nodes.put(var2_2, childNode);
            return;
        }
        if (ObjectUtil.equals(parentNode, childNode.getDeclaredParent())) {
            consumer.accept(parentNode, childNode);
            return;
        }
        if (!childNode.hasParent()) {
            parentNode.addChild(childNode);
        } else if (this.allowOverrideParent) {
            ((TreeEntryNode)childNode.getDeclaredParent()).removeDeclaredChild(childNode.getKey());
            parentNode.addChild(childNode);
        } else {
            void var1_1;
            throw new IllegalArgumentException(StrUtil.format("[{}] has been used as child of [{}], can not be overwrite as child of [{}]", childNode.getKey(), ((TreeEntryNode)childNode.getDeclaredParent()).getKey(), var1_1));
        }
        var3_3.accept(parentNode, childNode);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unlinkNode(K parentKey, K childKey) {
        void var2_2;
        TreeEntryNode<K, V> childNode = this.nodes.get(var2_2);
        if (ObjectUtil.isNull(childNode)) {
            return;
        }
        if (childNode.hasParent()) {
            void var1_1;
            ((TreeEntryNode)childNode.getDeclaredParent()).removeDeclaredChild(var1_1.getKey());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$remove$0(TreeEntryNode parent, Object k, TreeEntry c) {
        void var2_2;
        parent.addChild((TreeEntryNode)var2_2);
    }

    public static class EntryNodeWrapper<K, V, N extends TreeEntry<K, V>>
    implements Map.Entry<K, TreeEntry<K, V>> {
        private final N entryNode;

        /*
         * WARNING - void declaration
         */
        EntryNodeWrapper(N entryNode) {
            void var1_1;
            this.entryNode = var1_1;
        }

        @Override
        public K getKey() {
            return this.entryNode.getKey();
        }

        @Override
        public TreeEntry<K, V> getValue() {
            return this.entryNode;
        }

        @Override
        public TreeEntry<K, V> setValue(TreeEntry<K, V> value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class TreeEntryNode<K, V>
    implements TreeEntry<K, V> {
        private TreeEntryNode<K, V> root;
        private TreeEntryNode<K, V> parent;
        private int weight;
        private final Map<K, TreeEntryNode<K, V>> children;
        private final K key;
        private V value;

        /*
         * WARNING - void declaration
         */
        public TreeEntryNode(TreeEntryNode<K, V> parent, K key) {
            this((TreeEntryNode<void, Object>)var1_1, var2_2, null);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public TreeEntryNode(TreeEntryNode<K, V> parent, K key, V value) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.parent = parent;
            this.key = var2_2;
            this.value = var3_3;
            this.children = new LinkedHashMap<K, TreeEntryNode<K, V>>();
            if (ObjectUtil.isNull(parent)) {
                this.root = this;
                this.weight = 0;
                return;
            }
            parent.addChild(this);
            this.weight = parent.weight + 1;
            this.root = var1_1.root;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V setValue(V value) {
            void var2_2;
            void var1_1;
            V oldVal = this.getValue();
            this.value = var1_1;
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        TreeEntryNode<K, V> traverseParentNodes(boolean includeCurrent, Consumer<TreeEntryNode<K, V>> consumer, Predicate<TreeEntryNode<K, V>> breakTraverse) {
            void var1_2;
            TreeEntryNode<K, V> curr;
            breakTraverse = ObjectUtil.defaultIfNull(breakTraverse, a -> n -> false);
            TreeEntryNode<K, V> treeEntryNode = curr = includeCurrent ? this : this.parent;
            while (ObjectUtil.isNotNull(treeEntryNode)) {
                consumer.accept(curr);
                if (breakTraverse.test(curr)) break;
                treeEntryNode = curr.parent;
            }
            return var1_2;
        }

        public boolean isRoot() {
            return this.getRoot() == this;
        }

        @Override
        public TreeEntryNode<K, V> getRoot() {
            if (ObjectUtil.isNotNull(this.root)) {
                return this.root;
            }
            this.root = this.traverseParentNodes(true, p -> {}, p -> !p.hasParent());
            return this.root;
        }

        @Override
        public TreeEntryNode<K, V> getDeclaredParent() {
            return this.parent;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public TreeEntryNode<K, V> getParent(K key) {
            void var1_1;
            return this.traverseParentNodes(false, p -> {}, p -> {
                Object object;
                return p.equalsKey(object);
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEachChild(boolean includeSelf, Consumer<TreeEntry<K, V>> nodeConsumer) {
            void var2_2;
            void var1_1;
            this.traverseChildNodes((boolean)var1_1, (arg_0, arg_1) -> TreeEntryNode.lambda$forEachChild$6((Consumer)var2_2, arg_0, arg_1), null);
        }

        /*
         * WARNING - void declaration
         */
        public boolean equalsKey(K key) {
            void var1_1;
            return ObjectUtil.equal(this.getKey(), var1_1);
        }

        TreeEntryNode<K, V> traverseChildNodes(boolean includeCurrent, BiConsumer<Integer, TreeEntryNode<K, V>> consumer, BiPredicate<Integer, TreeEntryNode<K, V>> breakTraverse) {
            TreeEntryNode treeEntryNode;
            breakTraverse = ObjectUtil.defaultIfNull(breakTraverse, (i, n) -> false);
            LinkedList<List> keyNodeDeque = CollUtil.newLinkedList(CollUtil.newArrayList(this));
            boolean needProcess = includeCurrent;
            int index = includeCurrent ? 0 : 1;
            Object lastNode = null;
            while (!keyNodeDeque.isEmpty()) {
                List curr = (List)keyNodeDeque.removeFirst();
                ArrayList next = new ArrayList();
                for (TreeEntryNode node : curr) {
                    if (needProcess) {
                        consumer.accept(index, node);
                        if (breakTraverse.test(index, node)) {
                            return node;
                        }
                    } else {
                        needProcess = true;
                    }
                    CollUtil.addAll(next, node.children.values());
                }
                if (!next.isEmpty()) {
                    keyNodeDeque.addLast(next);
                }
                treeEntryNode = (TreeEntryNode)CollUtil.getLast(next);
                ++index;
            }
            return treeEntryNode;
        }

        /*
         * WARNING - void declaration
         */
        void addChild(TreeEntryNode<K, V> child) {
            void var1_1;
            if (this.containsChild(child.key)) {
                return;
            }
            this.traverseParentNodes(true, s -> {
                void var2_2;
                void var1_1;
                Assert.notEquals(s.key, var1_1.key, "circular reference between [{}] and [{}]!", var2_2.key, this.key);
            }, null);
            child.parent = this;
            child.traverseChildNodes(true, (i, c) -> {
                void var1_1;
                c.root = this.getRoot();
                var2_2.weight = var1_1.intValue() + this.getWeight() + 1;
            }, null);
            this.children.put(child.key, (TreeEntryNode<K, void>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        void removeDeclaredChild(K key) {
            void var2_2;
            void var1_1;
            TreeEntryNode<K, V> child = this.children.get(key);
            if (ObjectUtil.isNull(child)) {
                return;
            }
            this.children.remove(var1_1);
            child.parent = null;
            child.traverseChildNodes(true, (arg_0, arg_1) -> TreeEntryNode.lambda$removeDeclaredChild$10((TreeEntryNode)var2_2, arg_0, arg_1), null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public TreeEntryNode<K, V> getChild(K key) {
            void var1_1;
            return this.traverseChildNodes(false, (i, c) -> {}, (i, c) -> {
                Object object;
                return c.equalsKey(object);
            });
        }

        @Override
        public Map<K, TreeEntry<K, V>> getDeclaredChildren() {
            return new LinkedHashMap<K, TreeEntryNode<K, V>>(this.children);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map<K, TreeEntry<K, V>> getChildren() {
            void var1_1;
            LinkedHashMap childrenMap = new LinkedHashMap();
            this.traverseChildNodes(false, (i, c) -> {
                void var2_2;
                TreeEntry cfr_ignored_0 = (TreeEntry)childrenMap.put(c.getKey(), var2_2);
            }, null);
            return var1_1;
        }

        void clear() {
            this.root = null;
            this.children.clear();
            this.parent = null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            void var1_1;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass().equals(o.getClass()) || ClassUtil.isAssignable(this.getClass(), o.getClass())) {
                return false;
            }
            TreeEntry treeEntry = (TreeEntry)o;
            return ObjectUtil.equals(this.getKey(), var1_1.getKey());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getKey());
        }

        /*
         * WARNING - void declaration
         */
        TreeEntryNode<K, V> copy(V value) {
            void var1_1;
            TreeEntryNode<K, V> copiedNode = new TreeEntryNode<K, V>(this.parent, this.key, ObjectUtil.defaultIfNull(value, this.value));
            copiedNode.children.putAll(this.children);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ void lambda$removeDeclaredChild$10(TreeEntryNode child, Integer i, TreeEntryNode c) {
            void var1_1;
            TreeEntryNode treeEntryNode;
            c.root = treeEntryNode;
            var2_2.weight = var1_1.intValue();
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ void lambda$forEachChild$6(Consumer nodeConsumer, Integer index, TreeEntryNode child) {
            void var2_2;
            nodeConsumer.accept(var2_2);
        }
    }
}

