/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Opt;
import cn.hutool.core.map.TreeEntry;
import cn.hutool.core.util.ObjectUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

public interface ForestMap<K, V>
extends Map<K, TreeEntry<K, V>> {
    /*
     * WARNING - void declaration
     */
    @Override
    default public TreeEntry<K, V> put(K key, TreeEntry<K, V> node) {
        void var2_2;
        void var1_1;
        return this.putNode(var1_1, var2_2.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public void putAll(Map<? extends K, ? extends TreeEntry<K, V>> treeEntryMap) {
        void var1_1;
        if (CollUtil.isEmpty(treeEntryMap)) {
            return;
        }
        var1_1.forEach((k, v) -> {
            void var2_2;
            if (v.hasParent()) {
                void var1_1;
                TreeEntry parent = v.getDeclaredParent();
                this.putLinkedNodes(parent.getKey(), var1_1.getValue(), v.getKey(), v.getValue());
                return;
            }
            this.putNode(v.getKey(), var2_2.getValue());
        });
    }

    @Override
    public TreeEntry<K, V> remove(Object var1);

    @Override
    public void clear();

    /*
     * WARNING - void declaration
     */
    default public <C extends Collection<V>> void putAllNode(C values, Function<V, K> keyGenerator, Function<V, K> parentKeyGenerator, boolean ignoreNullNode) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (CollUtil.isEmpty(values)) {
            return;
        }
        var1_1.forEach(arg_0 -> this.lambda$putAllNode$1((Function)var2_2, (Function)var3_3, ignoreNullNode, arg_0));
    }

    public TreeEntry<K, V> putNode(K var1, V var2);

    /*
     * WARNING - void declaration
     */
    default public void putLinkedNodes(K parentKey, V parentValue, K childKey, V childValue) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.putNode(parentKey, var2_2);
        this.putNode(childKey, childValue);
        this.linkNodes(var1_1, var3_3);
    }

    public void putLinkedNodes(K var1, K var2, V var3);

    /*
     * WARNING - void declaration
     */
    default public void linkNodes(K parentKey, K childKey) {
        void var2_2;
        void var1_1;
        this.linkNodes(var1_1, var2_2, null);
    }

    public void linkNodes(K var1, K var2, BiConsumer<TreeEntry<K, V>, TreeEntry<K, V>> var3);

    public void unlinkNode(K var1, K var2);

    /*
     * WARNING - void declaration
     */
    default public Set<TreeEntry<K, V>> getTreeNodes(K key) {
        void var2_2;
        void var1_1;
        TreeEntry target = (TreeEntry)this.get(key);
        if (ObjectUtil.isNull(target)) {
            return Collections.emptySet();
        }
        LinkedHashSet<TreeEntry> results = CollUtil.newLinkedHashSet(target.getRoot());
        CollUtil.addAll(results, var1_1.getRoot().getChildren().values());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    default public TreeEntry<K, V> getRootNode(K key) {
        void var1_1;
        return Opt.ofNullable(this.get(var1_1)).map(TreeEntry::getRoot).orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    default public TreeEntry<K, V> getDeclaredParentNode(K key) {
        void var1_1;
        return Opt.ofNullable(this.get(var1_1)).map(TreeEntry::getDeclaredParent).orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    default public TreeEntry<K, V> getParentNode(K key, K parentKey) {
        void var2_2;
        void var1_1;
        return Opt.ofNullable(this.get(var1_1)).map(t -> {
            Object object;
            return t.getParent(object);
        }).orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    default public boolean containsParentNode(K key, K parentKey) {
        void var2_2;
        void var1_1;
        return Opt.ofNullable(this.get(var1_1)).map(m -> {
            Object object;
            return m.containsParent(object);
        }).orElse(Boolean.FALSE);
    }

    /*
     * WARNING - void declaration
     */
    default public V getNodeValue(K key) {
        void var1_1;
        return (V)Opt.ofNullable(this.get(var1_1)).map(Map.Entry::getValue).get();
    }

    /*
     * WARNING - void declaration
     */
    default public boolean containsChildNode(K parentKey, K childKey) {
        void var2_2;
        void var1_1;
        return Opt.ofNullable(this.get(var1_1)).map(m -> {
            Object object;
            return m.containsChild(object);
        }).orElse(Boolean.FALSE);
    }

    /*
     * WARNING - void declaration
     */
    default public Collection<TreeEntry<K, V>> getDeclaredChildNodes(K key) {
        void var1_1;
        return Opt.ofNullable(this.get(var1_1)).map(TreeEntry::getDeclaredChildren).map(Map::values).orElseGet(Collections::emptyList);
    }

    /*
     * WARNING - void declaration
     */
    default public Collection<TreeEntry<K, V>> getChildNodes(K key) {
        void var1_1;
        return Opt.ofNullable(this.get(var1_1)).map(TreeEntry::getChildren).map(Map::values).orElseGet(Collections::emptyList);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$putAllNode$1(Function keyGenerator, Function parentKeyGenerator, boolean ignoreNullNode, Object v) {
        void var2_2;
        void var3_3;
        Object key = keyGenerator.apply(v);
        Object parentKey = parentKeyGenerator.apply(v);
        boolean hasKey = ObjectUtil.isNotNull(key);
        boolean hasParentKey = ObjectUtil.isNotNull(parentKey);
        if (var3_3 == false || hasKey && hasParentKey) {
            this.linkNodes(parentKey, key);
            ((TreeEntry)this.get(key)).setValue(v);
            return;
        }
        if (!hasKey && !hasParentKey) {
            return;
        }
        if (hasKey) {
            void var1_1;
            this.putNode(var1_1, v);
            return;
        }
        this.putNode(var2_2, null);
    }
}

