/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.tree;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeBuilder;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.parser.DefaultNodeParser;
import cn.hutool.core.lang.tree.parser.NodeParser;
import cn.hutool.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TreeUtil {
    public static Tree<Integer> buildSingle(List<TreeNode<Integer>> list) {
        return TreeUtil.buildSingle(list, Integer.valueOf(0));
    }

    public static List<Tree<Integer>> build(List<TreeNode<Integer>> list) {
        return TreeUtil.build(list, Integer.valueOf(0));
    }

    /*
     * WARNING - void declaration
     */
    public static <E> Tree<E> buildSingle(List<TreeNode<E>> list, E parentId) {
        void var1_1;
        return TreeUtil.buildSingle(list, var1_1, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    /*
     * WARNING - void declaration
     */
    public static <E> List<Tree<E>> build(List<TreeNode<E>> list, E parentId) {
        void var1_1;
        return TreeUtil.build(list, var1_1, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    /*
     * WARNING - void declaration
     */
    public static <T, E> Tree<E> buildSingle(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        void var2_2;
        void var1_1;
        return TreeUtil.buildSingle(list, var1_1, TreeNodeConfig.DEFAULT_CONFIG, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, E> List<Tree<E>> build(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        void var2_2;
        void var1_1;
        return TreeUtil.build(list, var1_1, TreeNodeConfig.DEFAULT_CONFIG, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, E> List<Tree<E>> build(List<T> list, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        void var3_3;
        void var2_2;
        void var1_1;
        return TreeUtil.buildSingle(list, var1_1, (TreeNodeConfig)var2_2, var3_3).getChildren();
    }

    /*
     * WARNING - void declaration
     */
    public static <T, E> Tree<E> buildSingle(List<T> list, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        void var3_3;
        void var1_1;
        List<T> list2;
        void var2_2;
        return TreeBuilder.of(rootId, (TreeNodeConfig)var2_2).append(list2, var1_1, var3_3).build();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> List<Tree<E>> build(Map<E, Tree<E>> map, E rootId) {
        void var1_1;
        return TreeUtil.buildSingle(map, var1_1).getChildren();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> Tree<E> buildSingle(Map<E, Tree<E>> map, E rootId) {
        void var1_1;
        Tree<E> tree = IterUtil.getFirstNoneNull(map.values());
        if (tree != null) {
            Map<E, Tree<E>> map2;
            void var2_2;
            TreeNodeConfig config = tree.getConfig();
            return TreeBuilder.of(rootId, (TreeNodeConfig)var2_2).append(map2).build();
        }
        return TreeUtil.createEmptyNode(var1_1);
    }

    public static <T> Tree<T> getNode(Tree<T> node, T id) {
        if (ObjectUtil.equal(id, node.getId())) {
            return node;
        }
        Tree children = node.getChildren();
        if (children == null) {
            return null;
        }
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            Tree tree;
            children = (Tree)iterator.next();
            Tree childNode = children.getNode(id);
            if (childNode == null) continue;
            return tree;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<CharSequence> getParentsName(Tree<T> node, boolean includeCurrentNode) {
        void var2_3;
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        if (node == null) {
            return result;
        }
        if (includeCurrentNode) {
            result.add(node.getName());
        }
        for (Tree<T> parent = node.getParent(); parent != null; parent = parent.getParent()) {
            void var1_2;
            CharSequence name = parent.getName();
            if (name == null && parent == null) continue;
            result.add((CharSequence)var1_2);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> getParentsId(Tree<T> node, boolean includeCurrentNode) {
        void var2_3;
        ArrayList<T> result = new ArrayList<T>();
        if (node == null) {
            return result;
        }
        if (includeCurrentNode) {
            result.add(node.getId());
        }
        for (Tree<T> parent = node.getParent(); parent != null; parent = parent.getParent()) {
            void var1_2;
            T id = parent.getId();
            if (id == null && parent == null) continue;
            result.add(var1_2);
        }
        return var2_3;
    }

    public static <E> Tree<E> createEmptyNode(E id) {
        E e;
        return new Tree().setId(e);
    }
}

