/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.tree;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.parser.NodeParser;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TreeBuilder<E>
implements Builder<Tree<E>> {
    private static final long serialVersionUID = 1L;
    private final Tree<E> root;
    private final Map<E, Tree<E>> idTreeMap;
    private boolean isBuild;

    public static <T> TreeBuilder<T> of(T rootId) {
        return TreeBuilder.of(rootId, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> TreeBuilder<T> of(T rootId, TreeNodeConfig config) {
        void var1_1;
        T t;
        return new TreeBuilder<T>(t, (TreeNodeConfig)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public TreeBuilder(E rootId, TreeNodeConfig config) {
        void var1_1;
        void var2_2;
        this.root = new Tree((TreeNodeConfig)var2_2);
        this.root.setId((Object)var1_1);
        this.idTreeMap = new LinkedHashMap<E, Tree<E>>();
    }

    /*
     * WARNING - void declaration
     */
    public TreeBuilder<E> setId(E id) {
        void var1_1;
        this.root.setId((Object)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TreeBuilder<E> setParentId(E parentId) {
        void var1_1;
        this.root.setParentId((Object)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TreeBuilder<E> setName(CharSequence name) {
        void var1_1;
        this.root.setName((CharSequence)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TreeBuilder<E> setWeight(Comparable<?> weight) {
        void var1_1;
        this.root.setWeight((Comparable)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TreeBuilder<E> putExtra(String key, Object value) {
        void var2_2;
        void var1_1;
        Assert.notEmpty(key, "Key must be not empty !", new Object[0]);
        this.root.put(var1_1, var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TreeBuilder<E> append(Map<E, Tree<E>> map) {
        void var1_1;
        this.checkBuilt();
        this.idTreeMap.putAll((Map<E, Tree<E>>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TreeBuilder<E> append(Iterable<Tree<E>> trees) {
        Iterator iterator;
        this.checkBuilt();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Tree tree = (Tree)iterator.next();
            this.idTreeMap.put((E)tree.getId(), (Tree<E>)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public <T> TreeBuilder<E> append(List<T> list, NodeParser<T, E> nodeParser) {
        void var2_2;
        void var1_1;
        return this.append((List<T>)var1_1, null, (NodeParser<T, E>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public <T> TreeBuilder<E> append(List<T> list, E rootId, NodeParser<T, E> nodeParser) {
        this.checkBuilt();
        TreeNodeConfig config = this.root.getConfig();
        LinkedHashMap map = new LinkedHashMap(list.size(), 1.0f);
        for (T t : list) {
            void var1_1;
            Tree node = new Tree(config);
            nodeParser.parse(t, node);
            if (rootId != null && !rootId.getClass().equals(node.getId().getClass())) {
                throw new IllegalArgumentException("rootId type is node.getId().getClass()!");
            }
            map.put(node.getId(), var1_1);
        }
        return this.append(map);
    }

    public TreeBuilder<E> reset() {
        this.idTreeMap.clear();
        this.root.setChildren(null);
        this.isBuild = false;
        return this;
    }

    @Override
    public Tree<E> build() {
        this.checkBuilt();
        this.buildFromMap();
        this.cutTree();
        this.isBuild = true;
        this.idTreeMap.clear();
        return this.root;
    }

    public List<Tree<E>> buildList() {
        if (this.isBuild) {
            return this.root.getChildren();
        }
        return ((Tree)this.build()).getChildren();
    }

    /*
     * WARNING - void declaration
     */
    private void buildFromMap() {
        if (MapUtil.isEmpty(this.idTreeMap)) {
            return;
        }
        Map<E, Tree<E>> eTreeMap = MapUtil.sortByValue(this.idTreeMap, false);
        for (Tree<E> node : eTreeMap.values()) {
            void var2_3;
            if (node == null) continue;
            E parentId = node.getParentId();
            if (ObjectUtil.equals(this.root.getId(), parentId)) {
                this.root.addChildren(node);
                continue;
            }
            Tree<E> parentNode = eTreeMap.get(parentId);
            if (parentNode == null) continue;
            var2_3.addChildren(node);
        }
    }

    private void cutTree() {
        TreeNodeConfig treeNodeConfig = this.root.getConfig();
        Integer deep = treeNodeConfig.getDeep();
        if (deep == null || deep < 0) {
            return;
        }
        TreeBuilder treeBuilder = this;
        treeBuilder.cutTree(treeBuilder.root, 0, (Integer)((Object)treeNodeConfig));
    }

    private void cutTree(Tree<E> tree, int currentDepp, int maxDeep) {
        if (tree == null) {
            return;
        }
        if (currentDepp == maxDeep) {
            tree.setChildren(null);
            return;
        }
        List<Tree<E>> children = tree.getChildren();
        if (CollUtil.isNotEmpty(children)) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Tree child = (Tree)iterator.next();
                this.cutTree(child, currentDepp + 1, maxDeep);
            }
        }
    }

    private void checkBuilt() {
        Assert.isFalse(this.isBuild, "Current tree has been built.", new Object[0]);
    }
}

