/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.tree;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.tree.Node;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;

public class Tree<T>
extends LinkedHashMap<String, Object>
implements Node<T> {
    private static final long serialVersionUID = 1L;
    private final TreeNodeConfig treeNodeConfig;
    private Tree<T> parent;

    public Tree() {
        this((TreeNodeConfig)null);
    }

    /*
     * WARNING - void declaration
     */
    public Tree(TreeNodeConfig treeNodeConfig) {
        void var1_1;
        this.treeNodeConfig = ObjectUtil.defaultIfNull(var1_1, TreeNodeConfig.DEFAULT_CONFIG);
    }

    public TreeNodeConfig getConfig() {
        return this.treeNodeConfig;
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public Tree<T> getNode(T id) {
        void var1_1;
        return TreeUtil.getNode(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public List<CharSequence> getParentsName(T id, boolean includeCurrentNode) {
        void var2_2;
        void var1_1;
        return TreeUtil.getParentsName(this.getNode(var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public List<CharSequence> getParentsName(boolean includeCurrentNode) {
        void var1_1;
        return TreeUtil.getParentsName(this, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Tree<T> setParent(Tree<T> parent) {
        this.parent = parent;
        if (parent != null) {
            void var1_1;
            this.setParentId((Object)var1_1.getId());
        }
        return this;
    }

    @Override
    public T getId() {
        Tree tree = this;
        return (T)tree.get(tree.treeNodeConfig.getIdKey());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tree<T> setId(T id) {
        void var1_1;
        Tree tree = this;
        tree.put(tree.treeNodeConfig.getIdKey(), var1_1);
        return this;
    }

    @Override
    public T getParentId() {
        Tree tree = this;
        return (T)tree.get(tree.treeNodeConfig.getParentIdKey());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tree<T> setParentId(T parentId) {
        void var1_1;
        Tree tree = this;
        tree.put(tree.treeNodeConfig.getParentIdKey(), var1_1);
        return this;
    }

    @Override
    public CharSequence getName() {
        Tree tree = this;
        return (CharSequence)tree.get(tree.treeNodeConfig.getNameKey());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tree<T> setName(CharSequence name) {
        void var1_1;
        Tree tree = this;
        tree.put(tree.treeNodeConfig.getNameKey(), var1_1);
        return this;
    }

    @Override
    public Comparable<?> getWeight() {
        Tree tree = this;
        return (Comparable)tree.get(tree.treeNodeConfig.getWeightKey());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tree<T> setWeight(Comparable<?> weight) {
        void var1_1;
        Tree tree = this;
        tree.put(tree.treeNodeConfig.getWeightKey(), var1_1);
        return this;
    }

    public List<Tree<T>> getChildren() {
        Tree tree = this;
        return (List)tree.get(tree.treeNodeConfig.getChildrenKey());
    }

    public boolean hasChild() {
        return CollUtil.isNotEmpty(this.getChildren());
    }

    /*
     * WARNING - void declaration
     */
    public void walk(Consumer<Tree<T>> consumer) {
        consumer.accept(this);
        List<Tree<T>> children = this.getChildren();
        if (CollUtil.isNotEmpty(children)) {
            void var1_1;
            void var2_2;
            var2_2.forEach(arg_0 -> Tree.lambda$walk$0((Consumer)var1_1, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    public Tree<T> filterNew(Filter<Tree<T>> filter) {
        void var1_1;
        return this.cloneTree().filter((Filter<Tree<T>>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Tree<T> filter(Filter<Tree<T>> filter) {
        if (filter.accept(this)) {
            return this;
        }
        Object children = this.getChildren();
        if (CollUtil.isNotEmpty(children)) {
            ArrayList<void> filteredChildren = new ArrayList<void>(children.size());
            Iterator<Tree<T>> iterator = children.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                children = iterator.next();
                Tree<T> filteredChild = ((Tree)children).filter(filter);
                if (filteredChild == null) continue;
                filteredChildren.add(var2_2);
            }
            if (CollUtil.isNotEmpty(filteredChildren)) {
                void var3_3;
                return this.setChildren((List<Tree<T>>)var3_3);
            }
            this.setChildren(null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Tree<T> setChildren(List<Tree<T>> children) {
        void var1_1;
        if (children == null) {
            Tree tree = this;
            tree.remove(tree.treeNodeConfig.getChildrenKey());
        }
        Tree tree = this;
        tree.put(tree.treeNodeConfig.getChildrenKey(), var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public final Tree<T> addChildren(Tree<T> ... children) {
        if (ArrayUtil.isNotEmpty(children)) {
            void var1_1;
            List<Tree<T>> childrenList = this.getChildren();
            if (childrenList == null) {
                childrenList = new ArrayList<Tree<T>>();
                this.setChildren(childrenList);
            }
            for (void child : var1_1) {
                child.setParent(this);
                childrenList.add((Tree<T>)child);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void putExtra(String key, Object value) {
        void var2_2;
        void var1_1;
        Assert.notEmpty(key, "Key must be not empty !", new Object[0]);
        this.put(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringWriter stringWriter = new StringWriter();
        Tree.printTree(this, new PrintWriter(stringWriter), 0);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Tree<T> cloneTree() {
        void var1_1;
        Tree result = ObjectUtil.clone(this);
        result.setChildren(this.cloneChildren());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<Tree<T>> cloneChildren() {
        void var2_2;
        void var1_1;
        List<Tree<T>> children = this.getChildren();
        if (children == null) {
            return null;
        }
        ArrayList newChildren = new ArrayList(children.size());
        var1_1.forEach((? super T t) -> {
            void var1_1;
            newChildren.add(var1_1.cloneTree());
        });
        return var2_2;
    }

    private static void printTree(Tree<?> tree, PrintWriter writer, int intent) {
        writer.println(StrUtil.format("{}{}[{}]", StrUtil.repeat(' ', intent), tree.getName(), tree.getId()));
        writer.flush();
        Iterator children = tree.getChildren();
        if (CollUtil.isNotEmpty(children)) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Tree tree2 = (Tree)iterator.next();
                Tree.printTree(tree2, writer, intent + 2);
            }
        }
    }

    private static /* synthetic */ void lambda$walk$0(Consumer consumer, Tree tree) {
        Consumer consumer2;
        tree.walk(consumer2);
    }
}

