/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.reflect;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.reflect.LookupFactory;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;

public class MethodHandleUtil {
    public static MethodHandles.Lookup lookup(Class<?> callerClass) {
        return LookupFactory.lookup(callerClass);
    }

    /*
     * WARNING - void declaration
     */
    public static MethodHandle findMethod(Class<?> callerClass, String name, MethodType type) {
        void var3_4;
        if (StrUtil.isBlank(name)) {
            return MethodHandleUtil.findConstructor(callerClass, type);
        }
        MethodHandle handle = null;
        MethodHandles.Lookup lookup = MethodHandleUtil.lookup(callerClass);
        try {
            handle = lookup.findVirtual(callerClass, name, type);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {}
        if (handle == null) {
            try {
                handle = lookup.findStatic(callerClass, name, type);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {}
        }
        if (handle == null) {
            try {
                void var2_3;
                void var1_2;
                handle = lookup.findSpecial(callerClass, (String)var1_2, (MethodType)var2_3, callerClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException e) {
                void var0_1;
                throw new UtilException((Throwable)var0_1);
            }
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static MethodHandle findConstructor(Class<?> callerClass, Class<?> ... args) {
        void var1_1;
        return MethodHandleUtil.findConstructor(callerClass, MethodType.methodType(Void.TYPE, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static MethodHandle findConstructor(Class<?> callerClass, MethodType type) {
        MethodHandles.Lookup lookup = MethodHandleUtil.lookup(callerClass);
        try {
            void var1_2;
            void var2_3;
            return var2_3.findConstructor(callerClass, (MethodType)var1_2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (IllegalAccessException e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invokeSpecial(Object obj, String methodName, Object ... args) {
        void var2_2;
        void var3_3;
        Object object;
        Assert.notNull(obj, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = ReflectUtil.getMethodOfObj(obj, methodName, args);
        if (method == null) {
            void var1_1;
            throw new UtilException("No such method: [{}] from [{}]", var1_1, obj.getClass());
        }
        return MethodHandleUtil.invokeSpecial(object, (Method)var3_3, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invoke(Object obj, Method method, Object ... args) {
        void var2_2;
        void var1_1;
        Object object;
        return MethodHandleUtil.invoke(false, object, (Method)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invokeSpecial(Object obj, Method method, Object ... args) {
        void var2_2;
        void var1_1;
        Object object;
        return MethodHandleUtil.invoke(true, object, (Method)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invoke(boolean isSpecial, Object obj, Method method, Object ... args) {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandles.Lookup lookup = MethodHandleUtil.lookup(declaringClass);
        try {
            void var3_5;
            void var2_4;
            MethodHandle handle;
            MethodHandle methodHandle = handle = isSpecial ? lookup.unreflectSpecial(method, declaringClass) : lookup.unreflect((Method)var2_4);
            if (obj != null) {
                void var1_3;
                handle = handle.bindTo(var1_3);
            }
            return (T)handle.invokeWithArguments((Object[])var3_5);
        }
        catch (Throwable e) {
            void var0_2;
            throw new UtilException((Throwable)var0_2);
        }
    }
}

