/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.hash;

import cn.hutool.core.lang.hash.Number128;
import cn.hutool.core.util.ByteUtil;
import java.nio.ByteOrder;
import java.util.Arrays;

public class MetroHash {
    private static final long k0_64 = -691005195L;
    private static final long k1_64 = -1565916357L;
    private static final long k2_64 = 1654206401L;
    private static final long k3_64 = 817650473L;
    private static final long k0_128 = -935685663L;
    private static final long k1_128 = -2042045477L;
    private static final long k2_128 = 2078195771L;
    private static final long k3_128 = 794325157L;

    public static long hash64(byte[] data) {
        return MetroHash.hash64(data, 1337L);
    }

    public static Number128 hash128(byte[] data) {
        return MetroHash.hash128(data, 1337L);
    }

    /*
     * WARNING - void declaration
     */
    public static long hash64(byte[] data, long seed) {
        void var1_1;
        byte[] buffer = data;
        void hash = (var1_1 + 1654206401L) * -691005195L;
        long v0 = hash;
        long v1 = hash;
        long v2 = hash;
        long v3 = hash;
        if (buffer.length >= 32) {
            while (buffer.length >= 32) {
                v0 += MetroHash.littleEndian64(buffer, 0) * -691005195L;
                v0 = MetroHash.rotateLeft64(v0, -29) + v2;
                v1 += MetroHash.littleEndian64(buffer, 8) * -1565916357L;
                v1 = MetroHash.rotateLeft64(v1, -29) + v3;
                v2 += MetroHash.littleEndian64(buffer, 24) * 1654206401L;
                v2 = MetroHash.rotateLeft64(v2, -29) + v0;
                v3 += MetroHash.littleEndian64(buffer, 32) * 817650473L;
                v3 = MetroHash.rotateLeft64(v3, -29) + v1;
                buffer = Arrays.copyOfRange(buffer, 32, buffer.length);
            }
            v2 ^= MetroHash.rotateLeft64((long)((v0 + v3) * -691005195L + v1), -37) * -1565916357L;
            v3 ^= MetroHash.rotateLeft64((long)((v1 + v2) * -1565916357L + v0), -37) * -691005195L;
            long l = v0;
            v0 = l ^ MetroHash.rotateLeft64((l + v2) * -691005195L + v3, -37) * -1565916357L;
            long l2 = v1;
            v1 = l2 ^ MetroHash.rotateLeft64((l2 + v3) * -1565916357L + v2, -37) * -691005195L;
            hash += v0 ^ v1;
        }
        if (buffer.length >= 16) {
            v0 = hash + MetroHash.littleEndian64(buffer, 0) * 1654206401L;
            v0 = MetroHash.rotateLeft64(v0, -29) * 817650473L;
            v1 = hash + MetroHash.littleEndian64(buffer, 8) * 1654206401L;
            v1 = MetroHash.rotateLeft64(v1, -29) * 817650473L;
            long l = v0;
            v0 = l ^ MetroHash.rotateLeft64(l * -691005195L, -21) + v1;
            long l3 = v1;
            v1 = l3 ^ MetroHash.rotateLeft64(l3 * 817650473L, -21) + v0;
            hash += v1;
            buffer = Arrays.copyOfRange(buffer, 16, buffer.length);
        }
        if (buffer.length >= 8) {
            hash += MetroHash.littleEndian64(buffer, 0) * 817650473L;
            buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
            void v4 = hash;
            hash = v4 ^ MetroHash.rotateLeft64((long)v4, -55) * -1565916357L;
        }
        if (buffer.length >= 4) {
            hash += (long)MetroHash.littleEndian32(Arrays.copyOfRange(buffer, 0, 4)) * 817650473L;
            hash ^= MetroHash.rotateLeft64((long)hash, -26) * -1565916357L;
            buffer = Arrays.copyOfRange(buffer, 4, buffer.length);
        }
        if (buffer.length >= 2) {
            hash += (long)MetroHash.littleEndian16(Arrays.copyOfRange(buffer, 0, 2)) * 817650473L;
            buffer = Arrays.copyOfRange(buffer, 2, buffer.length);
            void v5 = hash;
            hash = v5 ^ MetroHash.rotateLeft64((long)v5, -48) * -1565916357L;
        }
        if (buffer.length > 0) {
            byte[] byArray;
            hash += (long)byArray[0] * 817650473L;
            hash ^= MetroHash.rotateLeft64((long)hash, -38) * -1565916357L;
        }
        void v6 = hash;
        hash = v6 ^ MetroHash.rotateLeft64((long)v6, -28);
        void var4_2 = (hash *= -691005195L) ^ MetroHash.rotateLeft64((long)hash, -29);
        return (long)var4_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Number128 hash128(byte[] data, long seed) {
        byte[] buffer = data;
        long v0 = (seed - -935685663L) * 794325157L;
        long v1 = (seed + -2042045477L) * 2078195771L;
        if (buffer.length >= 32) {
            void var1_1;
            long v2 = (seed + -935685663L) * 2078195771L;
            long v3 = (var1_1 - -2042045477L) * 794325157L;
            while (buffer.length >= 32) {
                v0 += MetroHash.littleEndian64(buffer, 0) * -935685663L;
                buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
                v0 = MetroHash.rotateRight(v0, 29) + v2;
                v1 += MetroHash.littleEndian64(buffer, 0) * -2042045477L;
                buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
                v1 = MetroHash.rotateRight(v1, 29) + v3;
                v2 += MetroHash.littleEndian64(buffer, 0) * 2078195771L;
                buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
                v2 = MetroHash.rotateRight(v2, 29) + v0;
                v3 = MetroHash.littleEndian64(buffer, 0) * 794325157L;
                buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
                v3 = MetroHash.rotateRight(v3, 29) + v1;
            }
            v2 ^= MetroHash.rotateRight((v0 + v3) * -935685663L + v1, 21) * -2042045477L;
            v3 ^= MetroHash.rotateRight((v1 + v2) * -2042045477L + v0, 21) * -935685663L;
            long l = v0;
            v0 = l ^ MetroHash.rotateRight((l + v2) * -935685663L + v3, 21) * -2042045477L;
            long l2 = v1;
            v1 = l2 ^ MetroHash.rotateRight((l2 + v3) * -2042045477L + v2, 21) * -935685663L;
        }
        if (buffer.length >= 16) {
            v0 += MetroHash.littleEndian64(buffer, 0) * 2078195771L;
            buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
            v0 = MetroHash.rotateRight(v0, 33) * 794325157L;
            v1 += MetroHash.littleEndian64(buffer, 0) * 2078195771L;
            buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
            v1 = MetroHash.rotateRight(v1, 33) * 794325157L;
            long l = v0;
            v0 = l ^ MetroHash.rotateRight(l * 2078195771L + v1, 45) + -2042045477L;
            long l3 = v1;
            v1 = l3 ^ MetroHash.rotateRight(l3 * 794325157L + v0, 45) + -935685663L;
        }
        if (buffer.length >= 8) {
            v0 += MetroHash.littleEndian64(buffer, 0) * 2078195771L;
            buffer = Arrays.copyOfRange(buffer, 8, buffer.length);
            v0 = MetroHash.rotateRight(v0, 33) * 794325157L;
            v0 ^= MetroHash.rotateRight(v0 * 2078195771L + v1, 27) * -2042045477L;
        }
        if (buffer.length >= 4) {
            v1 += (long)MetroHash.littleEndian32(buffer) * 2078195771L;
            buffer = Arrays.copyOfRange(buffer, 4, buffer.length);
            v1 = MetroHash.rotateRight(v1, 33) * 794325157L;
            v1 ^= MetroHash.rotateRight(v1 * 794325157L + v0, 46) * -935685663L;
        }
        if (buffer.length >= 2) {
            v0 += (long)MetroHash.littleEndian16(buffer) * 2078195771L;
            buffer = Arrays.copyOfRange(buffer, 2, buffer.length);
            v0 = MetroHash.rotateRight(v0, 33) * 794325157L;
            v0 ^= MetroHash.rotateRight(v0 * 2078195771L * v1, 22) * -2042045477L;
        }
        if (buffer.length > 0) {
            byte[] byArray;
            v1 += (long)byArray[0] * 2078195771L;
            v1 = MetroHash.rotateRight(v1, 33) * 794325157L;
            v1 ^= MetroHash.rotateRight(v1 * 794325157L + v0, 58) * -935685663L;
        }
        long l = v0;
        v0 = l + MetroHash.rotateRight(l * -935685663L + v1, 13);
        long l4 = v1;
        v1 = l4 + MetroHash.rotateRight(l4 * -2042045477L + v0, 37);
        long l5 = v0;
        v0 = l5 + MetroHash.rotateRight(l5 * 2078195771L + v1, 13);
        long l6 = v1;
        v1 = l6 + MetroHash.rotateRight(l6 * 794325157L + v0, 37);
        return new Number128(v0, v1);
    }

    /*
     * WARNING - void declaration
     */
    private static long littleEndian64(byte[] b, int start) {
        void var1_1;
        return ByteUtil.bytesToLong(b, (int)var1_1, ByteOrder.LITTLE_ENDIAN);
    }

    private static int littleEndian32(byte[] b) {
        byte[] byArray;
        return b[0] | b[1] << 8 | b[2] << 16 | byArray[3] << 24;
    }

    private static int littleEndian16(byte[] b) {
        return ByteUtil.bytesToShort(b, ByteOrder.LITTLE_ENDIAN);
    }

    /*
     * WARNING - void declaration
     */
    private static long rotateLeft64(long x, int k) {
        void var2_1;
        long l;
        int s = k & 0x3F;
        return x << s | l >> 64 - var2_1;
    }

    /*
     * WARNING - void declaration
     */
    private static long rotateRight(long val, int shift) {
        void var2_1;
        long l;
        return val >> shift | l << 64 - var2_1;
    }
}

