/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.hash;

import cn.hutool.core.lang.hash.Number128;
import cn.hutool.core.util.ByteUtil;
import java.util.Arrays;

public class CityHash {
    private static final long k0 = -4348849565147123417L;
    private static final long k1 = -5435081209227447693L;
    private static final long k2 = -7286425919675154353L;
    private static final long kMul = -7070675565921424023L;
    private static final int c1 = -862048943;
    private static final int c2 = 461845907;

    /*
     * WARNING - void declaration
     */
    public static int hash32(byte[] data) {
        void var3_3;
        int n;
        int g;
        int len = data.length;
        if (len <= 24) {
            if (len <= 12) {
                if (len <= 4) {
                    return CityHash.hash32Len0to4(data);
                }
                return CityHash.hash32Len5to12(data);
            }
            return CityHash.hash32Len13to24(data);
        }
        int h = len;
        int f = g = len * -862048943;
        int a0 = CityHash.rotate32(CityHash.fetch32(data, len - 4) * -862048943, 17) * 461845907;
        int a1 = CityHash.rotate32(CityHash.fetch32(data, len - 8) * -862048943, 17) * 461845907;
        int a2 = CityHash.rotate32(CityHash.fetch32(data, len - 16) * -862048943, 17) * 461845907;
        int a3 = CityHash.rotate32(CityHash.fetch32(data, len - 12) * -862048943, 17) * 461845907;
        int a4 = CityHash.rotate32(CityHash.fetch32(data, len - 20) * -862048943, 17) * 461845907;
        h ^= a0;
        h = CityHash.rotate32(h, 19);
        h = h * 5 + -430675100;
        h ^= a2;
        h = CityHash.rotate32(h, 19);
        h = h * 5 + -430675100;
        g ^= a1;
        g = CityHash.rotate32(g, 19);
        g = g * 5 + -430675100;
        g ^= a3;
        g = CityHash.rotate32(g, 19);
        g = g * 5 + -430675100;
        f += a4;
        f = CityHash.rotate32(f, 19);
        f = f * 5 + -430675100;
        int iters = (len - 1) / 20;
        int pos = 0;
        do {
            a0 = CityHash.rotate32(CityHash.fetch32(data, pos) * -862048943, 17) * 461845907;
            a1 = CityHash.fetch32(data, pos + 4);
            a2 = CityHash.rotate32(CityHash.fetch32(data, pos + 8) * -862048943, 17) * 461845907;
            a3 = CityHash.rotate32(CityHash.fetch32(data, pos + 12) * -862048943, 17) * 461845907;
            a4 = CityHash.fetch32(data, pos + 16);
            h ^= a0;
            h = CityHash.rotate32(h, 18);
            h = h * 5 + -430675100;
            f += a1;
            f = CityHash.rotate32(f, 19);
            f *= -862048943;
            g += a2;
            g = CityHash.rotate32(g, 18);
            g = g * 5 + -430675100;
            h ^= a3 + a1;
            h = CityHash.rotate32(h, 19);
            h = h * 5 + -430675100;
            g ^= a4;
            g = Integer.reverseBytes(g) * 5;
            h += a4 * 5;
            h = Integer.reverseBytes(h);
            int swapValue = f += a0;
            f = g;
            g = h;
            h = swapValue;
            pos += 20;
        } while (--iters != 0);
        g = CityHash.rotate32(g, 11) * -862048943;
        g = CityHash.rotate32(g, 17) * -862048943;
        f = CityHash.rotate32(f, 11) * -862048943;
        f = CityHash.rotate32(f, 17) * -862048943;
        n = CityHash.rotate32((int)(n + var3_3), 19);
        n = n * 5 + -430675100;
        n = CityHash.rotate32(n, 17) * -862048943;
        n = CityHash.rotate32(n + f, 19);
        n = n * 5 + -430675100;
        n = CityHash.rotate32(n, 17) * -862048943;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static long hash64(byte[] data) {
        void var2_2;
        int len = data.length;
        if (len <= 32) {
            if (len <= 16) {
                return CityHash.hashLen0to16(data);
            }
            return CityHash.hashLen17to32(data);
        }
        if (len <= 64) {
            return CityHash.hashLen33to64(data);
        }
        long x = CityHash.fetch64(data, len - 40);
        long y = CityHash.fetch64(data, len - 16) + CityHash.fetch64(data, len - 56);
        long z = CityHash.hashLen16(CityHash.fetch64(data, len - 48) + (long)len, CityHash.fetch64(data, len - 24));
        Number128 v = CityHash.weakHashLen32WithSeeds(data, len - 64, len, z);
        Number128 w = CityHash.weakHashLen32WithSeeds(data, len - 32, y + -5435081209227447693L, x);
        x = x * -5435081209227447693L + CityHash.fetch64(data, 0);
        len = len - 1 & 0xFFFFFFC0;
        int pos = 0;
        do {
            x = CityHash.rotate64(x + y + v.getLowValue() + CityHash.fetch64(data, pos + 8), 37) * -5435081209227447693L;
            y = CityHash.rotate64(y + v.getHighValue() + CityHash.fetch64(data, pos + 48), 42) * -5435081209227447693L;
            z = CityHash.rotate64(z + w.getLowValue(), 33) * -5435081209227447693L;
            v = CityHash.weakHashLen32WithSeeds(data, pos, v.getHighValue() * -5435081209227447693L, (x ^= w.getHighValue()) + w.getLowValue());
            w = CityHash.weakHashLen32WithSeeds(data, pos + 32, z + w.getHighValue(), (y += v.getLowValue() + CityHash.fetch64(data, pos + 40)) + CityHash.fetch64(data, pos + 16));
            long swapValue = x;
            x = z;
            z = swapValue;
            pos += 64;
        } while ((len -= 64) != 0);
        return CityHash.hashLen16(CityHash.hashLen16(v.getLowValue(), w.getLowValue()) + CityHash.shiftMix(y) * -5435081209227447693L + z, CityHash.hashLen16(v.getHighValue(), w.getHighValue()) + var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long hash64(byte[] data, long seed0, long seed1) {
        void var3_2;
        void var1_1;
        return CityHash.hashLen16(CityHash.hash64(data) - var1_1, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long hash64(byte[] data, long seed) {
        void var1_1;
        return CityHash.hash64(data, -7286425919675154353L, (long)var1_1);
    }

    public static Number128 hash128(byte[] data) {
        byte[] byArray;
        int n = data.length;
        if (n >= 16) {
            return CityHash.hash128(data, 16, new Number128(CityHash.fetch64(data, 0), CityHash.fetch64(data, 8) + -4348849565147123417L));
        }
        return CityHash.hash128(byArray, 0, new Number128(-4348849565147123417L, -5435081209227447693L));
    }

    /*
     * WARNING - void declaration
     */
    public static Number128 hash128(byte[] data, Number128 seed) {
        void var1_1;
        return CityHash.hash128(data, 0, (Number128)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static Number128 hash128(byte[] byteArray, int start, Number128 seed) {
        void pos;
        void var2_2;
        int len = byteArray.length - start;
        if (len < 128) {
            return CityHash.cityMurmur(Arrays.copyOfRange(byteArray, start, byteArray.length), seed);
        }
        Number128 v = new Number128(0L, 0L);
        Number128 w = new Number128(0L, 0L);
        long x = seed.getLowValue();
        long y = var2_2.getHighValue();
        long z = (long)len * -5435081209227447693L;
        v.setLowValue(CityHash.rotate64(y ^ 0xB492B66FBE98F273L, 49) * -5435081209227447693L + CityHash.fetch64(byteArray, start));
        Number128 number128 = v;
        number128.setHighValue(CityHash.rotate64(number128.getLowValue(), 42) * -5435081209227447693L + CityHash.fetch64(byteArray, start + 8));
        w.setLowValue(CityHash.rotate64(y + z, 35) * -5435081209227447693L + x);
        w.setHighValue(CityHash.rotate64(x + CityHash.fetch64(byteArray, start + 88), 53) * -5435081209227447693L);
        do {
            x = CityHash.rotate64(x + y + v.getLowValue() + CityHash.fetch64(byteArray, (int)(pos + 8)), 37) * -5435081209227447693L;
            y = CityHash.rotate64(y + v.getHighValue() + CityHash.fetch64(byteArray, (int)(pos + 48)), 42) * -5435081209227447693L;
            y += v.getLowValue() + CityHash.fetch64(byteArray, (int)(pos + 40));
            z = CityHash.rotate64(z + w.getLowValue(), 33) * -5435081209227447693L;
            v = CityHash.weakHashLen32WithSeeds(byteArray, (int)pos, v.getHighValue() * -5435081209227447693L, (x ^= w.getHighValue()) + w.getLowValue());
            w = CityHash.weakHashLen32WithSeeds(byteArray, (int)(pos + 32), z + w.getHighValue(), y + CityHash.fetch64(byteArray, (int)(pos + 16)));
            long swapValue = x;
            x = z;
            z = swapValue;
            x = CityHash.rotate64(x + y + v.getLowValue() + CityHash.fetch64(byteArray, (int)((pos += 64) + 8)), 37) * -5435081209227447693L;
            y = CityHash.rotate64(y + v.getHighValue() + CityHash.fetch64(byteArray, (int)(pos + 48)), 42) * -5435081209227447693L;
            y += v.getLowValue() + CityHash.fetch64(byteArray, (int)(pos + 40));
            z = CityHash.rotate64(z + w.getLowValue(), 33) * -5435081209227447693L;
            v = CityHash.weakHashLen32WithSeeds(byteArray, (int)pos, v.getHighValue() * -5435081209227447693L, (x ^= w.getHighValue()) + w.getLowValue());
            w = CityHash.weakHashLen32WithSeeds(byteArray, (int)(pos + 32), z + w.getHighValue(), y + CityHash.fetch64(byteArray, (int)(pos + 16)));
            swapValue = x;
            x = z;
            z = swapValue;
            pos += 64;
        } while ((len -= 128) >= 128);
        x += CityHash.rotate64(v.getLowValue() + z, 49) * -4348849565147123417L;
        y = y * -4348849565147123417L + CityHash.rotate64(w.getHighValue(), 37);
        z = z * -4348849565147123417L + CityHash.rotate64(w.getLowValue(), 27);
        Number128 number1282 = w;
        number1282.setLowValue(number1282.getLowValue() * 9L);
        Number128 number1283 = v;
        number1283.setLowValue(number1283.getLowValue() * -4348849565147123417L);
        int tail_done = 0;
        while (tail_done < len) {
            y = CityHash.rotate64(x + y, 42) * -4348849565147123417L + v.getHighValue();
            Number128 number1284 = w;
            number1284.setLowValue(number1284.getLowValue() + CityHash.fetch64(byteArray, (int)(pos + len - (tail_done += 32) + 16)));
            x = x * -4348849565147123417L + w.getLowValue();
            Number128 number1285 = w;
            number1285.setHighValue(number1285.getHighValue() + v.getLowValue());
            v = CityHash.weakHashLen32WithSeeds(byteArray, (int)(pos + len - tail_done), v.getLowValue() + (z += w.getHighValue() + CityHash.fetch64(byteArray, (int)(pos + len - tail_done))), v.getHighValue());
            v.setLowValue(v.getLowValue() * -4348849565147123417L);
        }
        x = CityHash.hashLen16(x, v.getLowValue());
        y = CityHash.hashLen16(y + z, w.getLowValue());
        return new Number128(CityHash.hashLen16(x + v.getHighValue(), w.getHighValue()) + y, CityHash.hashLen16(x + w.getHighValue(), y + v.getHighValue()));
    }

    /*
     * WARNING - void declaration
     */
    private static int hash32Len0to4(byte[] byteArray) {
        void var2_2;
        void var3_3;
        void var1_1;
        byte[] byArray;
        int b = 0;
        int c = 9;
        int len = byteArray.length;
        for (byte v : byArray) {
            b = b * -862048943 + v;
            c ^= b;
        }
        return CityHash.fmix(CityHash.mur((int)var1_1, CityHash.mur((int)var3_3, (int)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    private static int hash32Len5to12(byte[] byteArray) {
        void var2_3;
        void var3_4;
        void var1_2;
        byte[] byArray;
        int b;
        int len;
        int a = len = byteArray.length;
        int d = b = len * 5;
        a += CityHash.fetch32(byteArray, 0);
        b += CityHash.fetch32(byteArray, len - 4);
        int n = 9 + CityHash.fetch32(byArray, var1_2 >>> 1 & 4);
        return CityHash.fmix(CityHash.mur(n, CityHash.mur((int)var3_4, CityHash.mur((int)var2_3, d))));
    }

    /*
     * WARNING - void declaration
     */
    private static int hash32Len13to24(byte[] byteArray) {
        void var1_2;
        void var2_3;
        void var3_4;
        void var0_1;
        int len = byteArray.length;
        int a = CityHash.fetch32(byteArray, (len >>> 1) - 4);
        int b = CityHash.fetch32(byteArray, 4);
        int c = CityHash.fetch32(byteArray, len - 8);
        int d = CityHash.fetch32(byteArray, len >>> 1);
        int e = CityHash.fetch32(byteArray, 0);
        int f = CityHash.fetch32(byteArray, len - 4);
        return CityHash.fmix(CityHash.mur((int)var0_1, CityHash.mur(e, CityHash.mur(d, CityHash.mur(c, CityHash.mur((int)var3_4, CityHash.mur((int)var2_3, (int)var1_2)))))));
    }

    /*
     * WARNING - void declaration
     */
    private static long hashLen0to16(byte[] byteArray) {
        int len = byteArray.length;
        if (len >= 8) {
            long mul = -7286425919675154353L + ((long)len << 1);
            long a = CityHash.fetch64(byteArray, 0) + -7286425919675154353L;
            long b = CityHash.fetch64(byteArray, len - 8);
            long c = CityHash.rotate64(b, 37) * mul + a;
            long d = (CityHash.rotate64(a, 25) + b) * mul;
            return CityHash.hashLen16(c, d, mul);
        }
        if (len >= 4) {
            long mul = -7286425919675154353L + (long)(len << 1);
            long a = (long)CityHash.fetch32(byteArray, 0) & 0xFFFFFFFFL;
            return CityHash.hashLen16((long)len + (a << 3), (long)CityHash.fetch32(byteArray, len - 4) & 0xFFFFFFFFL, mul);
        }
        if (len > 0) {
            void var1_1;
            void var3_12;
            void var2_4;
            byte[] byArray;
            int a = byteArray[0] & 0xFF;
            int b = byteArray[len >>> 1] & 0xFF;
            int c = byArray[len - 1] & 0xFF;
            void y = var2_4 + (var3_12 << 8);
            void z = var1_1 + (c << 2);
            return CityHash.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    /*
     * WARNING - void declaration
     */
    private static long hashLen17to32(byte[] byteArray) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        int len = byteArray.length;
        long mul = -7286425919675154353L + ((long)len << 1);
        long a = CityHash.fetch64(byteArray, 0) * -5435081209227447693L;
        long b = CityHash.fetch64(byteArray, 8);
        long c = CityHash.fetch64(byteArray, len - 8) * mul;
        long d = CityHash.fetch64(byArray, (int)(var1_1 - 16)) * -7286425919675154353L;
        return CityHash.hashLen16(CityHash.rotate64(a + b, 43) + CityHash.rotate64(c, 30) + d, a + CityHash.rotate64(b + -7286425919675154353L, 18) + c, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static long hashLen33to64(byte[] byteArray) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        int len = byteArray.length;
        long mul = -7286425919675154353L + ((long)len << 1);
        long a = CityHash.fetch64(byteArray, 0) * -7286425919675154353L;
        long b = CityHash.fetch64(byteArray, 8);
        long c = CityHash.fetch64(byteArray, len - 24);
        long d = CityHash.fetch64(byteArray, len - 32);
        long e = CityHash.fetch64(byteArray, 16) * -7286425919675154353L;
        long f = CityHash.fetch64(byteArray, 24) * 9L;
        long g = CityHash.fetch64(byteArray, len - 8);
        long h = CityHash.fetch64(byArray, (int)(var1_1 - 16)) * mul;
        long u = CityHash.rotate64(a + g, 43) + (CityHash.rotate64(b, 30) + c) * 9L;
        long v = (a + g ^ d) + f + 1L;
        long w = Long.reverseBytes((u + v) * mul) + h;
        long x = CityHash.rotate64(e + f, 42) + c;
        long y = (Long.reverseBytes((v + w) * mul) + g) * mul;
        long z = e + f + c;
        a = Long.reverseBytes((x + z) * mul + y) + b;
        long l = CityHash.shiftMix((z + a) * mul + d + h) * var2_2;
        return l + x;
    }

    /*
     * WARNING - void declaration
     */
    private static long fetch64(byte[] byteArray, int start) {
        void var1_1;
        return ByteUtil.bytesToLong(byteArray, (int)var1_1, ByteUtil.CPU_ENDIAN);
    }

    /*
     * WARNING - void declaration
     */
    private static int fetch32(byte[] byteArray, int start) {
        void var1_1;
        return ByteUtil.bytesToInt(byteArray, (int)var1_1, ByteUtil.CPU_ENDIAN);
    }

    /*
     * WARNING - void declaration
     */
    private static long rotate64(long val, int shift) {
        void var2_1;
        long l;
        if (shift == 0) {
            return val;
        }
        return val >>> shift | l << 64 - var2_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int rotate32(int val, int shift) {
        void var1_1;
        int n;
        if (shift == 0) {
            return val;
        }
        return val >>> shift | n << 32 - var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static long hashLen16(long u, long v, long mul) {
        void var2_2;
        long a = (u ^ v) * mul;
        a ^= a >>> 47;
        void b = (var2_2 ^ a) * mul;
        void var8_4 = b ^ b >>> 47;
        return (long)(var8_4 *= mul);
    }

    /*
     * WARNING - void declaration
     */
    private static long hashLen16(long u, long v) {
        void var2_1;
        long l;
        return CityHash.hash128to64(new Number128(l, (long)var2_1));
    }

    /*
     * WARNING - void declaration
     */
    private static long hash128to64(Number128 number128) {
        long l;
        void var1_1;
        Number128 number1282;
        long a = (number128.getLowValue() ^ number128.getHighValue()) * -7070675565921424023L;
        a ^= a >>> 47;
        long b = (number1282.getHighValue() ^ var1_1) * -7070675565921424023L;
        l = b ^ l >>> 47;
        return l *= -7070675565921424023L;
    }

    private static long shiftMix(long val) {
        long l = val;
        return l ^ l >>> 47;
    }

    private static int fmix(int h) {
        int n;
        int n2 = h;
        h = n2 ^ n2 >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        n = (h *= -1028477387) ^ n >>> 16;
        return n;
    }

    private static int mur(int a, int h) {
        int n;
        int n2;
        a *= -862048943;
        a = CityHash.rotate32(a, 17);
        a *= 461845907;
        n ^= n2;
        n = CityHash.rotate32(n, 19);
        return n * 5 + -430675100;
    }

    /*
     * WARNING - void declaration
     */
    private static Number128 weakHashLen32WithSeeds(long w, long x, long y, long z, long a, long b) {
        void var2_2;
        long l;
        b = CityHash.rotate64(b + (a += l) + z, 21);
        long c = a;
        a += var2_2;
        return new Number128(a + z, (b += CityHash.rotate64(a += y, 44)) + c);
    }

    /*
     * WARNING - void declaration
     */
    private static Number128 weakHashLen32WithSeeds(byte[] byteArray, int start, long a, long b) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        return CityHash.weakHashLen32WithSeeds(CityHash.fetch64(byteArray, start), CityHash.fetch64(byteArray, start + 8), CityHash.fetch64(byteArray, start + 16), CityHash.fetch64(byArray, (int)(var1_1 + 24)), (long)var2_2, b);
    }

    /*
     * WARNING - void declaration
     */
    private static Number128 cityMurmur(byte[] byteArray, Number128 seed) {
        void var3_4;
        long d;
        long c;
        int len = byteArray.length;
        long a = seed.getLowValue();
        long b = seed.getHighValue();
        int l = len - 16;
        if (l <= 0) {
            a = CityHash.shiftMix(a * -5435081209227447693L) * -5435081209227447693L;
            c = b * -5435081209227447693L + CityHash.hashLen0to16(byteArray);
            d = CityHash.shiftMix(a + (len >= 8 ? CityHash.fetch64(byteArray, 0) : c));
        } else {
            c = CityHash.hashLen16(CityHash.fetch64(byteArray, len - 8) + -5435081209227447693L, a);
            d = CityHash.hashLen16(b + (long)len, c + CityHash.fetch64(byteArray, len - 16));
            a += d;
            int pos = 0;
            do {
                a ^= CityHash.shiftMix(CityHash.fetch64(byteArray, pos) * -5435081209227447693L) * -5435081209227447693L;
                b ^= (a *= -5435081209227447693L);
                c ^= CityHash.shiftMix(CityHash.fetch64(byteArray, pos + 8) * -5435081209227447693L) * -5435081209227447693L;
                d ^= (c *= -5435081209227447693L);
                pos += 16;
            } while ((l -= 16) > 0);
        }
        a = CityHash.hashLen16(a, c);
        b = CityHash.hashLen16(d, b);
        return new Number128(a ^ b, CityHash.hashLen16(b, (long)var3_4));
    }
}

