/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.func;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.map.WeakConcurrentMap;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;

public class LambdaUtil {
    private static final WeakConcurrentMap<String, SerializedLambda> cache = new WeakConcurrentMap();

    public static <R> Class<R> getRealClass(Func0<?> func) {
        Serializable serializable;
        Serializable lambda = LambdaUtil.resolve(func);
        LambdaUtil.checkLambdaTypeCanGetClass(((SerializedLambda)lambda).getImplMethodKind());
        return ClassUtil.loadClass(((SerializedLambda)serializable).getImplClass());
    }

    public static <T> SerializedLambda resolve(Func1<T, ?> func) {
        return LambdaUtil._resolve(func);
    }

    public static <R> SerializedLambda resolve(Func0<R> func) {
        return LambdaUtil._resolve(func);
    }

    public static <P> String getMethodName(Func1<P, ?> func) {
        return LambdaUtil.resolve(func).getImplMethodName();
    }

    public static <R> String getMethodName(Func0<R> func) {
        return LambdaUtil.resolve(func).getImplMethodName();
    }

    public static <P, R> Class<P> getRealClass(Func1<P, R> func) {
        String string;
        String lambda = LambdaUtil.resolve(func);
        LambdaUtil.checkLambdaTypeCanGetClass(((SerializedLambda)((Object)lambda)).getImplMethodKind());
        String instantiatedMethodType = ((SerializedLambda)((Object)lambda)).getInstantiatedMethodType();
        return ClassUtil.loadClass(StrUtil.sub(instantiatedMethodType, 2, StrUtil.indexOf(string, ';')));
    }

    public static <T> String getFieldName(Func1<T, ?> func) throws IllegalArgumentException {
        return BeanUtil.getFieldName(LambdaUtil.getMethodName(func));
    }

    public static <T> String getFieldName(Func0<T> func) throws IllegalArgumentException {
        return BeanUtil.getFieldName(LambdaUtil.getMethodName(func));
    }

    private static void checkLambdaTypeCanGetClass(int implMethodKind) {
        int n;
        if (implMethodKind != 5 && n != 6) {
            throw new IllegalArgumentException("\u8be5lambda\u4e0d\u662f\u5408\u9002\u7684\u65b9\u6cd5\u5f15\u7528");
        }
    }

    private static SerializedLambda _resolve(Serializable func) {
        Serializable serializable;
        return cache.computeIfAbsent(func.getClass().getName(), key -> (SerializedLambda)ReflectUtil.invoke((Object)serializable, "writeReplace", new Object[0]));
    }
}

