/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.ansi;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.ansi.Ansi8BitColor;
import cn.hutool.core.lang.ansi.AnsiBackground;
import cn.hutool.core.lang.ansi.AnsiColor;
import cn.hutool.core.lang.ansi.AnsiColors;
import cn.hutool.core.lang.ansi.AnsiElement;
import cn.hutool.core.lang.ansi.ForeOrBack;
import cn.hutool.core.util.StrUtil;
import java.util.Objects;

public class AnsiColorWrapper {
    private final int code;
    private final AnsiColors.BitDepth bitDepth;

    /*
     * WARNING - void declaration
     */
    public AnsiColorWrapper(int code, AnsiColors.BitDepth bitDepth) {
        void var2_2;
        void var1_1;
        if (bitDepth == AnsiColors.BitDepth.FOUR) {
            Assert.isTrue(30 <= code && code <= 37 || 90 <= code && code <= 97, "The value of 4 bit color only supported [30~37],[90~97].", new Object[0]);
        }
        Assert.isTrue(code >= 0 && code <= 255, "The value of 8 bit color only supported [0~255].", new Object[0]);
        this.code = var1_1;
        this.bitDepth = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public AnsiElement toAnsiElement(ForeOrBack foreOrBack) {
        void var1_1;
        if (this.bitDepth == AnsiColors.BitDepth.FOUR) {
            if (foreOrBack == ForeOrBack.FORE) {
                for (Enum enum_ : AnsiColor.values()) {
                    if (((AnsiColor)enum_).getCode() != this.code) continue;
                    return enum_;
                }
                throw new IllegalArgumentException(StrUtil.format("No matched AnsiColor instance,code={}", this.code));
            }
            for (Enum enum_ : AnsiBackground.values()) {
                if (((AnsiBackground)enum_).getCode() != this.code + 10) continue;
                return enum_;
            }
            throw new IllegalArgumentException(StrUtil.format("No matched AnsiBackground instance,code={}", this.code));
        }
        if (var1_1 == ForeOrBack.FORE) {
            return Ansi8BitColor.foreground(this.code);
        }
        return Ansi8BitColor.background(this.code);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnsiColorWrapper that = (AnsiColorWrapper)o;
        return this.code == that.code && this.bitDepth == var1_1.bitDepth;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.bitDepth});
    }
}

