/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.RandomUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;

public class WeightRandom<T>
implements Serializable {
    private static final long serialVersionUID = -8244697995702786499L;
    private final TreeMap<Double, T> weightMap = new TreeMap();

    public static <T> WeightRandom<T> create() {
        return new WeightRandom<T>();
    }

    public WeightRandom() {
    }

    /*
     * WARNING - void declaration
     */
    public WeightRandom(WeightObj<T> weightObj) {
        this();
        if (weightObj != null) {
            void var1_1;
            this.add((WeightObj<T>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public WeightRandom(Iterable<WeightObj<T>> weightObjs) {
        this();
        if (CollUtil.isNotEmpty(weightObjs)) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                WeightObj weightObj = (WeightObj)iterator.next();
                this.add((WeightObj<T>)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public WeightRandom(WeightObj<T>[] weightObjs) {
        this();
        void var1_1;
        for (void weightObj : var1_1) {
            this.add((WeightObj<T>)weightObj);
        }
    }

    /*
     * WARNING - void declaration
     */
    public WeightRandom<T> add(T obj, double weight) {
        void var2_2;
        void var1_1;
        return this.add(new WeightObj<void>(var1_1, (double)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public WeightRandom<T> add(WeightObj<T> weightObj) {
        if (weightObj != null) {
            double weight = weightObj.getWeight();
            if (weightObj.getWeight() > 0.0) {
                void var1_1;
                void var2_2;
                double lastWeight = this.weightMap.size() == 0 ? 0.0 : this.weightMap.lastKey();
                this.weightMap.put((double)(var2_2 + lastWeight), var1_1.getObj());
            }
        }
        return this;
    }

    public WeightRandom<T> clear() {
        if (this.weightMap != null) {
            this.weightMap.clear();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public T next() {
        void var1_1;
        void var2_2;
        if (MapUtil.isEmpty(this.weightMap)) {
            return null;
        }
        ThreadLocalRandom random = RandomUtil.getRandom();
        double randomWeight = this.weightMap.lastKey() * ((Random)random).nextDouble();
        NavigableMap<Double, T> tailMap = this.weightMap.tailMap((double)var2_2, false);
        return this.weightMap.get(var1_1.firstKey());
    }

    public static class WeightObj<T> {
        private T obj;
        private final double weight;

        /*
         * WARNING - void declaration
         */
        public WeightObj(T obj, double weight) {
            void var2_2;
            void var1_1;
            this.obj = var1_1;
            this.weight = var2_2;
        }

        public T getObj() {
            return this.obj;
        }

        /*
         * WARNING - void declaration
         */
        public void setObj(T obj) {
            void var1_1;
            this.obj = var1_1;
        }

        public double getWeight() {
            return this.weight;
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            void var2_2;
            int result = 31 + (this.obj == null ? 0 : this.obj.hashCode());
            long temp = Double.doubleToLongBits(this.weight);
            void v0 = var2_2;
            var1_1 = var1_1 * 31 + (int)(v0 ^ v0 >>> 32);
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void var1_1;
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WeightObj other = (WeightObj)obj;
            if (this.obj == null ? other.obj != null : !this.obj.equals(other.obj)) {
                return false;
            }
            return Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(var1_1.weight);
        }
    }
}

