/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Version
implements Serializable,
Comparable<Version> {
    private static final long serialVersionUID = 1L;
    private final String version;
    private final List<Object> sequence;
    private final List<Object> pre;
    private final List<Object> build;

    public static Version of(String v) {
        String string;
        return new Version(string);
    }

    public Version(String v) {
        Assert.notNull(v, "Null version string", new Object[0]);
        int n = v.length();
        if (n == 0) {
            throw new IllegalArgumentException("Empty version string");
        }
        this.version = v;
        this.sequence = new ArrayList<Object>(4);
        this.pre = new ArrayList<Object>(2);
        this.build = new ArrayList<Object>(2);
        char c = v.charAt(0);
        List<Object> sequence = this.sequence;
        List<Object> pre = this.pre;
        List<Object> build = this.build;
        int i = Version.takeNumber(v, 0, sequence);
        while (i < n) {
            c = v.charAt(i);
            if (c == '.') {
                ++i;
                continue;
            }
            if (c == '-' || c == '+') {
                ++i;
                break;
            }
            if (CharUtil.isNumber(c)) {
                i = Version.takeNumber(v, i, sequence);
                continue;
            }
            i = Version.takeString(v, i, sequence);
        }
        if (c == '-' && i >= n) {
            return;
        }
        while (i < n && (i = (c = v.charAt(i)) >= '0' && c <= '9' ? Version.takeNumber(v, i, pre) : Version.takeString(v, i, pre)) < n) {
            c = v.charAt(i);
            if (c == '.' || c == '-') {
                ++i;
                continue;
            }
            if (c != '+') continue;
            ++i;
            break;
        }
        if (c == '+' && i >= n) {
            return;
        }
        while (i < n && (i = (c = v.charAt(i)) >= '0' && c <= '9' ? Version.takeNumber(v, i, build) : Version.takeString(v, i, build)) < n) {
            c = v.charAt(i);
            if (c != '.' && c != '-' && c != '+') continue;
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Version that) {
        void var1_1;
        Version version = this;
        int c = version.compareTokens(version.sequence, that.sequence);
        if (c != 0) {
            return c;
        }
        if (this.pre.isEmpty()) {
            if (!that.pre.isEmpty()) {
                return 1;
            }
        } else if (that.pre.isEmpty()) {
            return -1;
        }
        Version version2 = this;
        c = version2.compareTokens(version2.pre, that.pre);
        if (c != 0) {
            void var2_2;
            return (int)var2_2;
        }
        Version version3 = this;
        return version3.compareTokens(version3.build, var1_1.build);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object ob) {
        void var1_1;
        if (!(ob instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)var1_1) == 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return this.version;
    }

    /*
     * WARNING - void declaration
     */
    private static int takeNumber(String s, int i, List<Object> acc) {
        void var1_1;
        void var2_2;
        char c;
        char c2 = s.charAt(i);
        int d = c2 - 48;
        int n = s.length();
        while (++i < n && CharUtil.isNumber(c = s.charAt(i))) {
            d = d * 10 + (c2 - 48);
        }
        var2_2.add(d);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int takeString(String s, int i, List<Object> acc) {
        void var1_1;
        void var3_3;
        String string;
        void var2_2;
        char c;
        int b = i;
        int n = s.length();
        while (++i < n && (c = s.charAt(i)) != '.' && c != '-' && c != '+' && (c < '0' || c > '9')) {
        }
        var2_2.add(string.substring((int)var3_3, i));
        return (int)var1_1;
    }

    private int compareTokens(List<Object> ts1, List<Object> ts2) {
        int n = Math.min(ts1.size(), ts2.size());
        for (int i = 0; i < n; ++i) {
            int c;
            Object o1 = ts1.get(i);
            Object o2 = ts2.get(i);
            if (!(o1 instanceof Integer && o2 instanceof Integer || o1 instanceof String && o2 instanceof String ? (c = CompareUtil.compare(o1, o2, null)) != 0 : (c = o1.toString().compareTo(o2.toString())) != 0)) continue;
            return c;
        }
        List<Object> rest = ts1.size() > ts2.size() ? ts1 : ts2;
        int e = rest.size();
        for (void i = var3_3; i < e; ++i) {
            Object o = rest.get((int)i);
            if (o instanceof Integer && (Integer)o == 0) continue;
            return ts1.size() - ts2.size();
        }
        return 0;
    }
}

